<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bobot_m extends CI_Model {
    var $table = 'kpi_aspek_bobot_p';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
        }
    
    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("
                    mj.id_jabatan,
                    mj.kode_jabatan,
                    mj.nama AS nama_jabatan,
                    IF(kabp.id_jabatan IS NULL, 'insert', 'update') AS action,
                    kabp.bobot_aspek_kinerja,
                    kabp.bobot_aspek_kepribadian,
                    kabp.bobot_aspek_kedisiplinan,
                    group.level AS nama_usergroup
            ")
            ->from('master_jabatan AS mj')
            ->join('kpi_aspek_bobot_p AS kabp', 'mj.id_jabatan = kabp.id_jabatan', 'LEFT')
            ->join('usergroup AS group', 'group.id = mj.level_user')
            ->where("mj.id_company", $this->id_company)
            ->where_not_in("mj.level_user", ['1', '6']);
    
         $column_search = array('mj.nama');
         $i = 0;
         foreach ($column_search as $item) {  // looping awal
             if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST
    
                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }
    
                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by('group.urutan ASC, mj.nama ASC');
        }
    }

    public function getDataById($id=""){
        return $this->db->select("
                    mj.id_jabatan,
                    mj.kode_jabatan,
                    mj.nama AS nama_jabatan,
                    IF(kabp.id_jabatan IS NULL, 'insert', 'update') AS action,
                    kabp.bobot_aspek_kinerja,
                    kabp.bobot_aspek_kepribadian,
                    kabp.bobot_aspek_kedisiplinan
            ")
            ->from('master_jabatan AS mj')
            ->join('kpi_aspek_bobot_p AS kabp', 'mj.id_jabatan = kabp.id_jabatan', 'LEFT')
            ->where("mj.id_company", $this->id_company)
            ->where("MD5(mj.id_jabatan)", $id)
            ->get()
            ->row();
    }

    public function save($data=[], $id="", $action=""){
        if($action == 'insert'){
            // PROSES SAVE
            $id_jabatan = $this->db->select('id_jabatan')
                                ->where('MD5(id_jabatan)', $id)
                                ->get('master_jabatan')->row()->id_jabatan;

            $user_input = array(
                'id_jabatan' => $id_jabatan,
                'tgl_input'  => date("Y-m-d H:i:s"),
                'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $save = $this->db->insert($this->table, array_merge($data, $user_input));
            return  __response_save($save);
        }else{
            // PROSES UPDATE
            $user_update    = array(
                'tgl_update'  => date("Y-m-d H:i:s"),
                'user_update' => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $this->db->where('id_company', $this->id_company);
            $this->db->where('MD5(id_jabatan)', $id);
            $update = $this->db->update($this->table, array_merge($data, $user_update));
            return  __response_update($update);
        }
    }
}