<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Rekap_reimburse_m extends CI_Model {
    public function __construct(){
        parent::__construct();

        $this->db->select("mc.flag");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang");
        $this->db->where("dk.id_company",$this->id_company);
        $this->db->where("dk.id_cabang",$this->id_cabang);
        $this->db->from("data_karyawan AS dk");
        $query = $this->db->get()->row();

        if($query->flag == "1"){
            $this->finance_pusat = true;
        }else{
            $this->finance_pusat = false;
        }
    }

    public function data_reimburse($id_cabang="all", $id_departemen="all", $id_karyawan="all", $tgl_mulai, $tgl_selesai){
        $this->db->select('rp.no_pengajuan,
                            rp.keterangan,
                            rp.id,
                            rp.tgl_pengajuan,
                            rp.id as id_pengajuan,
							dk.nik,
                            dk.nama_lengkap as nama_karyawan,
							mc.kode as kode_cabang,
							mc.nama as nama_cabang,
							md.kode as kode_departemen,
                            md.nama as nama_departemen');
        $this->db->join('data_karyawan AS dk', 'rp.id_karyawan = dk.id_karyawan');
        $this->db->join('master_cabang AS mc', 'rp.id_cabang = mc.id_cabang');
        $this->db->join('master_departemen AS md', 'rp.id_departemen = md.id_departemen', 'left');
        $this->db->from('reimbursement_pengajuan AS rp');
        $this->db->where('rp.id_company', $this->id_company);

        $this->db->where('rp.tgl_pengajuan >= ', date_format(date_create($tgl_mulai),"Y-m-d"));
		$this->db->where('rp.tgl_pengajuan <= ', date_format(date_create($tgl_selesai),"Y-m-d"));

        if($id_cabang != "all"){
            $this->db->where('rp.id_cabang', $id_cabang);
        }

        if($id_departemen != "all"){
            $this->db->where('rp.id_departemen', $id_departemen);
        }

        if($id_karyawan != "all"){
            $this->db->where('rp.id_karyawan', $id_karyawan);
        }


        $this->db->where('rp.status', '5');

		$this->db->group_by('rp.no_pengajuan');
        $order_by = array("rp.tgl_pengajuan"=>"ASC","rp.no_pengajuan"=>"ASC","md.nama"=>"ASC","dk.nama"=>"ASC");
        $this->db->order_by(key($order_by), $order_by[key($order_by)]);

        $query = $this->db->get();
        return $query->result();
    }


	public function data_export_reimburse($id_cabang="all", $id_departemen="all", $id_karyawan="all", $tgl_mulai, $tgl_selesai){
		$this->db->where('rp.tgl_pengajuan >= ', date_format(date_create($tgl_mulai),"Y-m-d"));
		$this->db->where('rp.tgl_pengajuan <= ', date_format(date_create($tgl_selesai),"Y-m-d"));
		$this->db->where('rp.id_cabang', $id_cabang);

		if($id_departemen != "all"){
			$this->db->where('rp.id_departemen', $id_departemen);
		}

        if($id_karyawan != "all"){
            if($id_karyawan != "-"){
                $this->db->where('rp.id_karyawan', $id_karyawan);
            }
		}

		$this->db->select('rp.no_pengajuan,
							rp.keterangan,
							rp.id,
							rp.tgl_pengajuan,
							rp.id as id_pengajuan,
							dk.nama_lengkap as nama_karyawan,
							dk.nik,
							mc.kode as kode_cabang,
							mc.nama as nama_cabang,
							md.kode as kode_departemen,
							md.nama as nama_departemen');
		$this->db->join('data_karyawan AS dk', 'rp.id_karyawan = dk.id_karyawan');
		$this->db->join('master_cabang AS mc', 'rp.id_cabang = mc.id_cabang');
		$this->db->join('master_departemen AS md', 'rp.id_departemen = md.id_departemen', 'left');
		$this->db->from('reimbursement_pengajuan AS rp');
		$this->db->where('rp.id_company', $this->id_company);
		$this->db->where('rp.status', '5');
		$order_by = array("rp.tgl_pengajuan"=>"ASC","rp.no_pengajuan"=>"ASC","md.nama"=>"ASC","dk.nama"=>"ASC");
		$this->db->order_by(key($order_by), $order_by[key($order_by)]);
		$query = $this->db->get();
		// echo $this->db->last_query();
		// die();
		return $query->result();
    }

    public function dropdown_karyawan($search){

        if( $this->finance_pusat == false){
            $this->db->where("data_karyawan.id_cabang",$this->id_cabang);
        }

        if($this->level_user == "5"){ # KEPALA CABANG
            if($this->multi_cabang == true){
                $this->db->where_in('data_karyawan.id_cabang', $this->id_cabang_arr);
            }else{
                $this->db->where('data_karyawan.id_cabang', $this->id_cabang);
            }
        }else if($this->level_user == "2"){ # KEPALA DEPARTEMEN
            if($this->multi_departemen == true){
                $this->db->where_in('data_karyawan.id_departemen', $this->id_departemen_arr);
            }else{
                $this->db->where('data_karyawan.id_departemen', $this->id_departemen);
            }
        }else if($this->level_user == "7"){ # SUPERVISI
            $this->db->group_start();
            $this->db->where("data_karyawan.supervisi",$this->id_karyawan);
            $this->db->or_where("data_karyawan.id_karyawan",$this->id_karyawan);
            $this->db->group_end();
        }

        $this->db->select('nama_lengkap, id_karyawan, nik');
        $this->db->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->where_in("status",["1","2","3","4"]);
        $this->db->where_not_in("master_jabatan.level_user",["1","6"]);
        $this->db->where("data_karyawan.id_company",$this->id_company);
        $this->db->group_start();
        $this->db->like('nama_lengkap', $search);
        $this->db->or_like('nik', $search);
        $this->db->group_end();
        $this->db->order_by('nama_lengkap', 'ASC');

        $result = $this->db->get('data_karyawan')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_karyawan, 'text'=>$rows->nik." - ".$rows->nama_lengkap];
        }
        echo json_encode($json);
    }

}
