<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if(!function_exists('mulai_kerja_bulan')) {
    function mulai_kerja_bulan($join_date) {
        if($join_date == '') {
            return '1';
        } else {
            $tahun_sekarang  = date('Y');
            $tahun_join_date = date('Y', strtotime($join_date));
            if($tahun_sekarang == $tahun_join_date) {
                return date('m', strtotime($join_date));
            } else {
                return '1';
            }
        }
    }
}

if(!function_exists('akhir_kerja_bulan')) {
    function akhir_kerja_bulan($tgl_berhenti_bekerja) {
        if($tgl_berhenti_bekerja == '') {
            return '12';
        } else {
            $tahun_sekarang         = date('Y');
            $tahun_berhenti_bekerja = date('Y', strtotime($tgl_berhenti_bekerja));
            if($tahun_sekarang == $tahun_berhenti_bekerja) {
                return date('m', strtotime($tgl_berhenti_bekerja));
            } else {
                return '12';
            }
        }
    }
}

if(!function_exists('pot_jabatan_atas_peng_bruto')) {
    function pot_jabatan_atas_peng_bruto($peng_bruto_ttl) {
        $potongan = $peng_bruto_ttl*(5/100);
        if($potongan > 500000) {
            return 500000;
        } else {
            return $potongan;
        }
    }
}

if(!function_exists('jml_ph_neto_disetahunkan')) {
    function jml_ph_neto_disetahunkan($peng_bruto_ttl, $ttl_potongan, $mulai_kerja_bulan, $akhir_kerja_bulan) {
        $bulan = ($akhir_kerja_bulan-$mulai_kerja_bulan)+1;
        return ($peng_bruto_ttl-$ttl_potongan)*$bulan;
    }
}

if(!function_exists('pkp')) {
    function pkp($jml_ph_neto_disetahunkan, $ptkp) {
        $potongan = round($jml_ph_neto_disetahunkan-$ptkp);
        if($potongan <= 0) {
            return 0;
        } else {
            $pembulatan = substr($potongan, -3);
            if($pembulatan != "000") {
                return substr($potongan, 0, strlen($potongan)-3)."000";
            } else {
                return $potongan;
            }
        }
    }
}

if(!function_exists('pkp_persen')) {
    function pkp_persen($persen, $balance) {
        if($persen == 35) {
            return [
                'result'  => $balance*($persen/100),
                'balance' => 0
            ];
        } else {
            $variabel_pkp = [
                '5'  => ['max' => 60000000],
                '15' => ['max' => 250000000],
                '25' => ['max' => 500000000],
                '30' => ['max' => 5000000000]
            ];

            if($balance > $variabel_pkp[$persen]['max']) {
                return [
                    'result'  => $variabel_pkp[$persen]['max']*($persen/100),
                    'balance' => $balance-$variabel_pkp[$persen]['max']
                ];
            } else {
                return [
                    'result'  => $balance*($persen/100),
                    'balance' => 0
                ];
            }
        }
    }
}

if(!function_exists('periode')) {
    function periode($bulan) {
        return date_format(date_create("01-".$bulan),"Y-m");
    }
}
