<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Kelurahan_m extends CI_Model
{
    function get_datatables($tahun="0000", $bulan="00", $id_group_m="all", $kelurahan="all"){
        $this->_get_datatables_query($tahun, $bulan, $id_group_m, $kelurahan);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($tahun="0000", $bulan="00", $id_group_m="all", $kelurahan="all"){
        $this->_get_datatables_query($tahun, $bulan, $id_group_m, $kelurahan);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all($tahun="0000", $bulan="00", $id_group_m="all", $kelurahan="all"){
        $this->_get_datatables_query($tahun, $bulan, $id_group_m, $kelurahan);
        return $this->db->count_all_results();
    }
    
    private function _get_datatables_query($tahun="0000", $bulan="00", $id_group_m="all", $kelurahan="all"){
        $this->db->select('
            sptx.kelurahan AS nama_kelurahan,
            sptx.kecamatan AS nama_kecamatan,
            sptx.kota AS nama_kota,
            sptx.provinsi AS nama_provinsi,
            COUNT(sptx.jumlah_layanan) AS jumlah,
            SUM(sptx.nominal_layanan) AS nominal
        ');
        $this->db->from('sales_pipeline_trx AS sptx');
        $this->db->where('sptx.id_company', $this->id_company);
        $this->db->where('sptx.tahun', $tahun);
        $this->db->where('sptx.jenis_tahapan', "wont");
        $this->db->where('sptx.kelurahan !=', "");
        $this->db->group_by('sptx.kecamatan, sptx.kelurahan');

        $this->db->join('
            (SELECT
                kel.id_kelurahan,
                kel.nama AS nama_kelurahan,
                kec.nama AS nama_kecamatan
            FROM master_kelurahan AS kel
            JOIN master_kecamatan AS kec
                ON kel.id_kecamatan = kec.id_kecamatan)
            AS kelurahan
        ',
        '   kelurahan.nama_kelurahan = sptx.kelurahan
                AND kelurahan.nama_kecamatan = sptx.kecamatan
        ');

        if($bulan != "all"){
            $this->db->where('sptx.bulan', sprintf('%02d', $bulan));
        }

        if($id_group_m != "all"){
            $this->db->where('sptx.id_group_m', $id_group_m);
        }

        if($kelurahan != "all"){
            $this->db->where('kelurahan.id_kelurahan', $kelurahan);
        }

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('sptx.id_group_m', explode(',', $this->sales_admin_group));
            }
        }
        
        // COLUMN ORDER
        $column_order = array('', 'sptx.nama', 'COUNT(sptx.jumlah_layanan)', 'SUM(sptx.nominal_layanan)');
        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by("COUNT(sptx.jumlah_layanan) DESC, kelurahan.id_kelurahan ASC");
        }
    }

    public function get_total_jumlah_dan_nominal($tahun="0000", $bulan="00", $id_group_m="all", $kelurahan="all"){
        $this->db->select('
            COUNT(sptx.jumlah_layanan) AS jumlah,
            SUM(sptx.nominal_layanan) AS nominal
        ');
        $this->db->from('sales_pipeline_trx AS sptx');
        $this->db->where('sptx.id_company', $this->id_company);
        $this->db->where('sptx.tahun', $tahun);
        $this->db->where('sptx.jenis_tahapan', "wont");
        $this->db->where('sptx.kelurahan !=', "");
        $this->db->group_by('sptx.id_company');

        if($bulan != "all"){
            $this->db->where('sptx.bulan', sprintf('%02d', $bulan));
        }

        if($id_group_m != "all"){
            $this->db->where('sptx.id_group_m', $id_group_m);
        }

        if($kelurahan != "all"){
            $this->db->join('
                (SELECT
                    kel.id_kelurahan,
                    kel.nama AS nama_kelurahan,
                    kec.nama AS nama_kecamatan
                FROM master_kelurahan AS kel
                JOIN master_kecamatan AS kec
                    ON kel.id_kecamatan = kec.id_kecamatan)
                AS kelurahan
            ',
            '   kelurahan.nama_kelurahan = sptx.kelurahan
                    AND kelurahan.nama_kecamatan = sptx.kecamatan
            ');

            $this->db->where('kelurahan.id_kelurahan', $kelurahan);
        }

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('sptx.id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        return $this->db->get()->row();
    }
}