<?php

class Template_m extends CI_Model {

    var $table = 'pkwt_template_m';
    
    public function __construct()
    {
        parent::__construct();
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->select("id_template")->from($this->table);
        $this->db->where("id_company", $this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query()
    {
        $this->db->select("id_template, nama")->from($this->table);
        $this->db->where("id_company", $this->id_company);
        $order_by = array("" => "DESC");
        $this->db->order_by("id_template", "desc");
    }

    public function getDataById($id) {
        $this->db->select('id_template, nama, template, parameter');
        $this->db->from($this->table);
        $this->db->where('md5(id_template)', $id);
        return $this->db->get()->row();
    }

    public function cekNamaTemplate() {
        $this->db->from($this->table);
        $this->db->like('nama', htmlentities($this->input->post('nama')));
        $this->db->where('id_company', $this->id_company);
        return $this->db->count_all_results();
    }

    public function cekTemplateDigunakan($template, $jenis = 'data') {
        $this->db->where('id_company', $this->id_company);
        $this->db->where('nm_draft_pkwt', $template);
        if($jenis == 'import') {
            return $this->db->count_all_results('pkwt_data_temp');
        } else {
            return $this->db->count_all_results('pkwt_data');
        }
    }
}