<?php

class Home_m extends CI_Model {

    function getDataTrx() {
        $periode = htmlentities($this->input->get('periode'));

        $this->db->select('trx.bulan, trx.id_karyawan, trx.tahun, trx.tgl_pengajuan, trx.status, actual.periode_mulai, actual.periode_selesai');
        $this->db->from('kpi_trx trx');
        $this->db->join('kpi_periode_actual_p actual', 'actual.tahun = trx.tahun and actual.bulan = trx.bulan and actual.id_company = trx.id_company');
        $this->db->where('trx.tahun', $periode);
        $this->db->where('trx.id_karyawan', $this->id_karyawan);
        $this->db->where_in('trx.status', ['1', '4', '6', '7', '9']);
        $this->db->order_by('trx.bulan', 'asc');
        return $this->db->get()->result_array();
    }

    public function setStatusDraft() {
        $this->db->set('status', '7');
        $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
        $this->db->where('tahun', htmlentities($this->input->post('tahun')));
        $this->db->where('bulan', htmlentities($this->input->post('bulan')));
        $this->db->update('kpi_trx');
    }

    function periodeActual($tahun = null, $bulan = null) {
        if($tahun == null) {
            $tahun = htmlentities($this->input->get('tahun'));
            $bulan = htmlentities($this->input->get('bulan'));
        }
        $this->db->select('tahun, bulan, periode_mulai, periode_selesai');
        $this->db->from('kpi_periode_actual_p');
        $this->db->where('bulan', $bulan);
        $this->db->where('tahun', $tahun);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get();
    }

}