<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Support_m extends CI_Model {
	
	function cek_karyawan_admin($id_company) {
		$this->db->select('users.username');
		$this->db->from('users');
		$this->db->join('data_karyawan', 'data_karyawan.id_karyawan = users.id_karyawan');
		$this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan');
		$this->db->where('users.id_company', $id_company);
		$this->db->where('master_jabatan.level_user', 1);
		return $this->db->get();
	}
	
	function cek_jabatan_admin($id_company) {
		$this->db->select('master_jabatan.id_jabatan');
		$this->db->from('master_jabatan');
		$this->db->where('master_jabatan.id_company', $id_company);
		$this->db->where('master_jabatan.level_user', 1);
		return $this->db->get();
	}
	
	function create_jabatan_admin($id_company) {
		$data = array(
			'id_jabatan'	=> $id_company.date('Ym').'001',
			'kode_jabatan'	=> 'ADMIN',
			'nama'			=> 'ADMIN',
			'level_user'	=> 1,
			'id_company'	=> $id_company
		);
		$this->db->insert('master_jabatan', $data);
	}
	
	function cek_cabang($id_company) {
		$this->db->select('master_cabang.id_cabang');
		$this->db->from('master_cabang');
		$this->db->where('master_cabang.id_company', $id_company);
		return $this->db->get();
	}
	
	function create_cabang($id_company) {
		$data = array(
			'id_cabang'		=> $id_company.date('Ym').'001',
			'kode'			=> 'PUSAT',
			'nama'			=> 'PUSAT',
			'flag'			=> '1',
			'id_company'	=> $id_company
		);
		$this->db->insert('master_cabang', $data);
	}
	
	function create_karyawan($id_company, $id_cabang, $id_jabatan_admin) {
		$data = array(
			'id_karyawan'	=> $id_company.date('Ym').'001',
			'nik'			=> $id_company.date('Ym').'001',
			'nama_lengkap'	=> 'ADM'.$id_company,
			'gelar_depan'	=> '',
			'id_cabang'		=> $id_cabang,
			'id_jabatan'	=> $id_jabatan_admin,
			'id_company'	=> $id_company
		);
		$this->db->insert('data_karyawan', $data);
	}
	
	function create_user($id_company, $username, $password_hash) {
		$data = array(
			'id_user'		=> $id_company.date('Ym').'001',
			'username'		=> $username,
			'password'		=> $password_hash,
			'id_karyawan'	=> $id_company.date('Ym').'001',
			'id_company'	=> $id_company
		);
		$this->db->insert('users', $data);
	}
	
	function detail_company($id_company) {
		$this->db->select('master_company.id_company, master_company.nama as nama_company, master_company.deskripsi, master_company.alamat as alamat_company
		, master_customer.nama as nama_customer, master_customer.propinsi, master_customer.kota, master_customer.alamat as alamat_customer
		,master_customer.email, master_customer.telp, tb_paket.nama as nama_paket');
		$this->db->from('master_company');
		$this->db->join('master_customer', 'master_company.id_customer = master_customer.id_customer');
		$this->db->join('tb_paket', 'master_company.id_tb_paket = tb_paket.id_tb_paket');
		$this->db->where('master_company.id_company', $id_company);
		return $this->db->get()->row();
	}
}
