<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Kelurahan extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sales_activity/demografi_pelanggan/wilayah/Kelurahan_m', 'model');
    }

    public function list_data(){
        $tahun      = $this->input->get('tahun');
        $bulan      = $this->input->get('bulan');
        $id_group_m = $this->input->get('id_group_m');
        $kelurahan  = $this->input->get('kelurahan');
        $list       = $this->model->get_datatables($tahun, $bulan, $id_group_m, $kelurahan);
        $total      = $this->model->get_total_jumlah_dan_nominal($tahun, $bulan, $id_group_m, $kelurahan);
        
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = "<span style='font-size:15px; text-transform: uppercase;'>". $field->nama_kelurahan. "<span>".
                        "<br><b style='font-size:10px'>". $field->nama_kecamatan. "<b>".
                        "<br><b style='font-size:10px'>". $field->nama_kota. "<b>".
                        "<br><b style='font-size:10px'>". $field->nama_provinsi. "<b>";

            $row[] = $field->jumlah;
            $row[] = number_format($field->nominal, 0,",",".");
    
            $data[] = $row;
        }
        
        if(!empty($data)){
            $row_total[] = "";
            $row_total[] = "<b>GRAND TOTAL</b>";
            $row_total[] = "<b>". $total->jumlah. "</b>";
            $row_total[] = "<b>". number_format($total->nominal, 0,",","."). "</b>";
            $row_total[] = "_colspan";
            $data[]      = $row_total;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($tahun, $bulan, $id_group_m, $kelurahan),
            "recordsFiltered" => $this->model->count_filtered($tahun, $bulan, $id_group_m, $kelurahan),
            "data"            => $data
        );
    
        $output = __response($this->MY_response, $output);
    
        echo json_encode($output);
    }

    public function dropdown_kelurahan()
    {
        $search = $this->input->get("q");

        $this->db->select('nama, id_kelurahan');
        $this->db->like('nama', $search);
        $this->db->order_by('id_kelurahan', 'ASC');
        $this->db->limit(100);

        $result = $this->db->get('master_kelurahan')->result();
        $json   = [];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->id_kelurahan, 'text' => $rows->nama];
        }
        echo json_encode($json);
    }

    public function download(){
        $tahun         = $this->input->get('tahun');
        $bulan         = $this->input->get('bulan');
        $id_group_m    = $this->input->get('id_group_m');
        $kelurahan     = $this->input->get('kelurahan');
        $data['tahun'] = $tahun;
        $data['list']  = $this->model->get_datatables($tahun, $bulan, $id_group_m, $kelurahan);

        if($bulan == "all"){
            $filename      = "DEMOGRAFI PELANGGAN BERDASARKAN KELURAHAN, Tahun ". $tahun;
            $data['bulan'] = "";
        }else{
            $nama_bulan    = $this->fungsi->konversi_bulan($bulan);
            $filename      = "DEMOGRAFI PELANGGAN BERDASARKAN KELURAHAN, Tahun ". $tahun. " Bulan ". $nama_bulan;
            $data['bulan'] = "BULAN ". $nama_bulan;
        }

        if($id_group_m == "all"){
            $filename           .= ", SEMUA GROUP";
            $data['nama_group']  = "SEMUA GROUP";
        }else{
            $nama_group          = $this->input->get('nama_group');
            $filename           .= ", ". $nama_group;
            $data['nama_group']  = $nama_group;
        }

		$output  = true;
		$sb_view = $this->load->view('sales_activity/demografi_pelanggan/wilayah/kelurahan/download', $data, $output);

        // Format Column
        $format_columns = [
			'A' => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
			'B' => ['width' => 40, 'align' => 'left', 'valign' => 'middle'],
			'C' => ['width' => 40, 'align' => 'left', 'valign' => 'middle'],
			'D' => ['width' => 40, 'align' => 'left', 'valign' => 'middle'],
			'E' => ['width' => 40, 'align' => 'left', 'valign' => 'middle'],
			'F' => ['width' => 12, 'align' => 'center', 'valign' => 'middle'],
			'G' => ['width' => 20, 'align' => 'right', 'valign' => 'middle', 'format'=>'text', 'rupiah'=>true],
		];

        // Bold Header & Footer Table
        $bold_footer = COUNT($data['list']) + 6;
        $thead       = ['5', strval($bold_footer)];

        $param = [
			'download'    => true,
			'cLength'     => 6,
			'file_name'   => strtoupper($filename),
			'paper_size'  => 'LEGAL',
			'font-size'   => 11,
			'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation' => 'landscape',
			'header'      => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'4' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
			],
			'thead' => $thead,
			'tbody' => [
				'start'  => '5',
				'height' => 15,
				'wrap'   => ['B','C','D','E'],
				'column' => $format_columns,
			],
            'align_column_unit' => [
                [   'align' => 'center', 'column' => ['E4'] ]
            ]
        ];
        
        $this->load->library('PHPExcel/Excel');

		if ($output) {
			$this->excel->generateExcel($sb_view, $param);
		} 
		exit;
    }
}