<script type="text/javascript">
    $(function() {
        $('#departemen').select2({
            tags: true,
            // minLength: 3,
            placeholder: 'Pilih Departemen',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.departemen") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            templateSelection: function(tag, container) {

                var $option = $('#departemen option[value="' + tag.id + '"]');
                if ($option.attr('locked')) {
                    $(container).addClass('locked-tag');
                    tag.locked = true;
                }
                return tag.text;
            },
        });
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id" class="form-control" value="<?= ((isset($data))?md5($data->id):'') ?>">
    <div class="row form-group">
        <div class="col-md-12">
            <label>Karyawan</label><br>
            <label class="font-weight-bold"><?= $karyawan->nik . " - " . $karyawan->nama_lengkap ?></label>
            <input type="hidden" id="id_karyawan" class="form-control" value="<?= $karyawan->id_karyawan ?>">
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label>Cabang</label><br>
            <label class="font-weight-bold"><?= $karyawan->kode_cabang . " - " . $karyawan->nama_cabang ?></label>
            <input type="hidden" id="id_cabang" class="form-control" value="<?= $karyawan->id_cabang ?>">
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label>Departemen <i class="text-danger">*</i></label>
            <select id="departemen" multiple="multiple" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                <?php
                    foreach ($departemen as $rows) {
                        if($rows->flag == "1"){
                            $locked = 'locked="locked"';
                        }else{
                            $locked = '';
                        }
                        echo '<option value="'.$rows->id_departemen.'"  '.$locked.' selected>'.$rows->kode.' - '.$rows->nama.'</option>';
                    }
                ?>
            </select>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

