<script type="text/javascript">
    $(document).ready(function() {
        table = $('#list_data').DataTable({
                "processing": true, //Feature control the processing indicator.
                "serverSide": true, //Feature control DataTables' server-side processing mode.
                "order": [], //Initial no order.
                "searching": true,
                'ordering'    : true,
                'paging'      : true,
                'lengthChange': true,
                'info'        : true,
                'language'    :{
                                'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                "processing"  : true,
                "serverSide"  : true,
                "order"       : [],

                "ajax"        : {
                                    "url": "<?= route('reimburse.list.data') ?>",
                                    "type": "POST",
                                    "data": {
                                                    tipe : function() {
                                                        return $("#tipe_pengajuan").val();
                                                    },
                                            },
                                    "complete" : function(data){
                                        // reconfigure(data);
                                    }
                                },

                "aoColumnDefs": [
                                    { "aTargets": [ 0 ], "bSortable": false },
                                    { "aTargets": [ -1 ], "bSortable": false }
                                ],
                "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                        $('td:eq(0)', nRow).css({'text-align':'center','width':'50px'});
                        $('td:eq(1)', nRow).css({'text-align':'center','width':'100px'});
                        $('td:eq(2)', nRow).css({'text-align':'center','width':'100px'});
                        $('td:eq(6)', nRow).css({'text-align':'right','width':'100px'});
                        $('td:eq(8)', nRow).css({'text-align':'center','width':'100px'});
                }

        });
    });

    function list_data(value) {
        $("#tipe_pengajuan").val(value);
        table.ajax.reload();
    }
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Reimbursement</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <!-- <div class="float-md-right">
                <a href="<?= site_url(); ?>/informasi/gaji/import-main">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-upload"></i> Import Data
                </button>
                </a>
            </div> -->
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="nav-tabs-boxed">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item"><a href="#" onclick="list_data(1)" class="nav-link active" data-toggle="tab" role="tab"><h6><i class="fa fa-file-text"></i> Pengajuan</h6></a></li>
                    <li class="nav-item"><a href="#" onclick="list_data(4)" class="nav-link" data-toggle="tab" role="tab"><h6><i class="fa fa-file-text"></i> Revisi</h6></a></li>
                    <li class="nav-item"><a href="#" onclick="list_data(3)" class="nav-link" data-toggle="tab" role="tab"><h6><i class="fa fa-file-text"></i> Ditolak</h6></a></li>
                    <li class="nav-item"><a href="#" onclick="list_data(5)" class="nav-link" data-toggle="tab" role="tab"><h6><i class="fa fa-file-text"></i> Distujui</h6></a></li>
                </ul>
            </div>


            <div class="row mt-3">
                <div class="col-md-12">
                    <input type="hidden" id="tipe_pengajuan" value="1">
                    <table id="list_data" class="table table-striped table-hover" style="width:100%">
                        <thead>
                            <tr class="bg-tr">
                                <th class="text-center">NO</th>
                                <th class="text-center">TANGGAL</th>
                                <th class="text-center">NO PENGAJUAN</th>
                                <th class="text-left">KARYAWAN</th>
                                <th class="text-left">CABANG</th>
                                <th class="text-left">DEPARTEMEN</th>
                                <th class="text-right">NOMINAL</th>
                                <th class="text-left">KETERANGAN</th>
                                <th class="text-center">DETAIL</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


