<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_akun_m extends CI_Model {
    var $table = 'users';

    public function getDataLokasi($id_karyawan = null){
        $id_company = $this->session->userdata("id_company");
        $this->db->select("data_lokasi_kantor.id_lokasi_kantor,
                        data_lokasi_kantor.nama_kantor")
                ->from("data_lokasi_kantor")
                ->join("data_karyawan","FIND_IN_SET(data_lokasi_kantor.id_lokasi_kantor, data_karyawan.id_lokasi)")
                ->where("data_karyawan.id_company",$id_company)
                ->where("md5(data_karyawan.id_karyawan)",$id_karyawan);

        $query = $this->db->get()->result();
        return $query;
    }

    public function getDataByIdKaryawan($id_karyawan = null){
        $id_company = $this->session->userdata('id_company');
        $this->db->select("users.id_user,
                            users.username,
                            users.lock_device,
                            users.lock_facerecognition,
                            users.foto_facerecognition,
                            users.device_id,
                            users.kamera,
                            data_karyawan.id_karyawan,
                            data_karyawan.nama_lengkap,
                            data_karyawan.lock_lokasi")
                ->from("data_karyawan")
                ->join("users","data_karyawan.id_karyawan = users.id_karyawan")
                ->where("MD5(data_karyawan.id_karyawan)",$id_karyawan)
                ->where("data_karyawan.id_company",$id_company);
        $query = $this->db->get();
        return $query->row();
    }

    public function getDataByIdUser($id_user = null){
        $id_company = $this->session->userdata('id_company');
        $this->db->select("users.id_user,
                            users.username,
                            users.lock_device,
                            users.lock_facerecognition,
                            users.foto_facerecognition,
                            users.device_id,
                            users.kamera,
                            data_karyawan.id_karyawan,
                            data_karyawan.lock_lokasi")
                ->from("data_karyawan")
                ->join("users","data_karyawan.id_karyawan = users.id_karyawan")
                ->where("MD5(users.id_user)",$id_user)
                ->where("data_karyawan.id_company",$id_company);
        $query = $this->db->get();
        return $query->row();
    }

    public function save($data_user, $data_lokasi, $id_karyawan, $id_user){
        $id_company = $this->session->userdata('id_company');

        $cek_user = $this->db->select("id_user")
                            ->from("users")
                            ->where("username",$data_user["username"])
                            ->where("MD5(id_user) !=",$id_user)
                            ->get()
                            ->num_rows();

        if($cek_user > 0){
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, username sudah digunakan</font>';
            return __response_update(false,["message"=>$message]);
        }

        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(FALSE); # See Note 01. If you wish can remove as well

        $this->db->where(array('md5(id_user)'=>$id_user, 'id_company'=>$id_company));
        $this->db->update('users',$data_user);

        $this->db->where(array('md5(id_karyawan)'=>$id_karyawan, 'id_company'=>$id_company));
        $this->db->update('data_karyawan',$data_lokasi);


        $this->db->trans_complete(); # Completing transaction


        if ($this->db->trans_status() === FALSE) {
            # Something went wrong.
            $this->db->trans_rollback();
            return __response_update(false);
        }else{
            # Everything is Perfect.
            # Committing data to the database.
            $this->db->trans_commit();
            return __response_update(true);
        }
    }


    public function reset_deviceid($data, $id_user){
        $id_company = $this->session->userdata('id_company');

        $this->db->where(array('md5(id_user)'=>$id_user, 'id_company'=>$id_company));
        $update = $this->db->update('users',$data);

        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Device id berhasil direset</font>';
        return __response_update($update,["message"=>$message]);

    }

    public function reset_facerecognition($data, $id_user){
        $id_company = $this->session->userdata('id_company');

        $this->db->where(array('md5(id_user)'=>$id_user, 'id_company'=>$id_company));
        $update = $this->db->update('users',$data);
        $message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Data face recognition berhasil direset</font>';
        return __response_update($update,["message"=>$message]);

    }

    public function save_camera($data, $id_user){
        $id_company = $this->session->userdata('id_company');
        if($data["kamera"] == "0"){
            $this->db->select("foto_facerecognition");
            $this->db->where("md5(id_user)",$id_user);
            $this->db->where("id_company",$id_company);
            $this->db->from("users");
            $data_user = $this->db->get()->row();

            $foto_facerecognition = $this->config->item('base_upload').$data_user->foto_facerecognition;
        }else{
            $foto_facerecognition = "";
        }

        $this->db->where(array('md5(id_user)'=>$id_user, 'id_company'=>$id_company));
        $update = $this->db->update('users',$data);

        if($update){
            if(!empty($foto_facerecognition)){
                unlink($foto_facerecognition);
            }
        }

        return __response_update($update);

    }

}