<?= $tab; ?>
<br>
<div class="table-responsive">
    <table id="list_data" class="table table-striped" style="width:100%">
        <thead>
            <tr>
                <th class="text-center">NO</th>
                <th class="text-center text-uppercase"><?= $this->lang->line('jenis_pengajuan') ?></th>
                <th class="text-center text-uppercase"><?= $this->lang->line('nama_perusahaan') ?></th>
                <th class="text-center text-uppercase"><?= $this->lang->line('jenis_perusahaan') ?></th>
                <th class="text-center text-uppercase"><?= $this->lang->line('jabatan_terakhir') ?></th>
                <th class="text-center text-uppercase"><?= $this->lang->line('tgl') ?></th>
                <th class="text-center"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script type="text/javascript">
    $(function() {
        // reconfigure();
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Tanggal'
                <?php else : ?> 'searchPlaceholder': 'Date'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('master.karyawan.pengalamankerja.histori.table') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                    d.id_karyawan = '<?= $id_karyawan_md5 ?>';
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                "aTargets": [0,6],
                "bSortable": false
            }],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(5)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(6)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(6)', nRow).css({
                    'width': '100px'
                });
            }

        });

    });

    function detail(id) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.histori.detail') ?>/" + id, function() {
            $('#modal_form').modal('show');
            $(".title").text("Detail Data");
        });
    }
</script>
