<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Target_kuartal_m extends CI_Model
{
    var $table = 'sales_target_kuartal_p';

    function get_datatables($tahun=""){
        return $this->_get_datatables_query($tahun);
    }

    private function _get_datatables_query($tahun=""){
        $target_tahunan = $this->_get_target_tahunan($tahun);
        $target_kuartal = $this->_get_target_kuartal($tahun);
        $data           = array();

        foreach($target_tahunan AS $value_1){
            $data['target_tahunan']['data'][$value_1->id_group_m][$value_1->tahun][$value_1->bulan]['nominal']  = $value_1->nominal;
            $data['target_tahunan']['total_nominal'][$value_1->id_group_m][$value_1->tahun]                    += $value_1->nominal;
        }

        foreach($target_kuartal AS $value_2){
            $data['target_kuartal']['data'][$value_2->id_group_m][$value_2->tahun][$value_2->bulan]['nominal']  = $value_2->nominal;
            $data['target_kuartal']['total_nominal'][$value_2->id_group_m][$value_2->tahun]                    += $value_2->nominal;

            if($value_2 != ""){
                $data['target_kuartal']['total_target_per_bulan'][$value_2->tahun][$value_2->bulan]                += $value_2->nominal;
                $data['target_kuartal']['total_seluruh_target'][$value_2->tahun]                                   += $value_2->nominal;
            }
        }
        
        return $data;
    }

    private function _get_target_tahunan($tahun = ""){
        $this->db->select("
            tahun,
            bulan,
            nominal,
            id_group_m
        ")
        ->from('sales_target_tahunan_p')
        ->where("id_company", $this->id_company)
        ->where("tahun", $tahun)
        ->order_by('bulan ASC');

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        return $this->db->get()->result();
    }

    private function _get_target_kuartal($tahun = ""){
        $this->db->select("
            tahun,
            bulan,
            nominal,
            id_group_m
        ")
        ->from($this->table)
        ->where("id_company", $this->id_company)
        ->where("tahun", $tahun)
        ->order_by('bulan ASC');

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        return $this->db->get()->result();
    }
}