<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pengaturan_notif_m extends CI_Model {
    var $table = 'p_notification';

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){
        $this->db->select("id_notification")->from($this->table);
        $this->db->where("id_company",$_SESSION['id_company']);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("p_notification.id_notification, p_notification.id_karyawan, p_notification.notif_hrd, p_notification.notif_finance, data_karyawan.nik, data_karyawan.nama_lengkap")->from($this->table);
        $this->db->join('data_karyawan','p_notification.id_karyawan  = data_karyawan.id_karyawan', 'left');
        $this->db->where("p_notification.id_company",$_SESSION['id_company']);
    
        $column_search = array('data_karyawan.nik','data_karyawan.nama_lengkap');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','id_karyawan');
    
        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } 
        else{
            $order_by = array("id_notification"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT p_notification.id_notification,
                                            p_notification.id_karyawan,
                                            p_notification.notif_hrd, notif_finance,
                                            data_karyawan.nik,
                                            data_karyawan.nama_lengkap
                                    FROM p_notification
                                    JOIN data_karyawan ON data_karyawan.id_karyawan = p_notification.id_karyawan
                                    WHERE MD5(p_notification.id_notification) = ?
                                    AND p_notification.id_company = '".$_SESSION["id_company"]."'",[$id])->row();
        return $select;
    }

    public function save($data,$id = null){
        if($id != null){
            $this->db->where(array('md5(id_notification)'=>$id, 'id_company'=>$_SESSION['id_company']));
            $update = $this->db->update($this->table,$data);
            $this->logger->create_log('pengaturan_notif', 'edit', $this->db->last_query());
            return  __response_update($update);
        }else{
            $nextId = $this->fungsi->getNextId($this->table,'id_notification',$_SESSION['id_company'],3);
            $id_notification = array('id_notification' => $nextId);
            $save = $this->db->insert($this->table, array_merge($data,$id_notification));
            return __response_save($save);
    
        }
        
    }

    public function delete($id=null){
        $this->db->where(array('md5(id_notification)'=>$id));
        $delete =$this->db->delete($this->table);
        $this->logger->create_log('pengaturan_notif', 'delete', $this->db->last_query());
        return  __response_delete($delete);
    }

}