<?php

if(!function_exists('kolom_alphabet')) {
    function kolom_alphabet($huruf_awal, $total_tambahan) {
        $kolom_awal  = range('A', 'Z');
        $index_awal  = array_search($huruf_awal, $kolom_awal);
        $total       = $index_awal+$total_tambahan;
        $kolom_baru  = [];
        $index_baru  = 0;
        $index_awal_baru = $index_awal+1;
        $prefix_index_baru = 0;
        while($index_baru < $total) {
            if(count($kolom_baru) == 0) {
                $kolom_baru = $kolom_awal;
            } else {
                $prefix_baru = $kolom_awal[$prefix_index_baru];
                foreach($kolom_awal as $row) {
                    $kolom_baru[] = $prefix_baru.$row;
                }
                $prefix_index_baru++;
            }
            $index_baru+=26;
        }
        return [
            'kolom'           => $kolom_baru,
            'index_awal_baru' => $index_awal_baru
        ];
    }
}

if(!function_exists('kolom_highlight_libur')) {
    function kolom_highlight_libur($kolom_existing, $header, $tgl_mulai, $tgl_selesai, $id_cabang, $start) {
        $CI =& get_instance();
        $CI->load->helper(['excel', 'tanggal']);
        $CI->load->model('Pengaturan_shift_m');

		$m_jam_kerja_libur = ["6", "7"];
        $m_libur_nasional  = $CI->Pengaturan_shift_m->m_libur_nasional(Y_m_d($tgl_mulai), Y_m_d($tgl_selesai));

        $huruf_awal     = array_key_last($kolom_existing);
        $kolom_alphabet = kolom_alphabet($huruf_awal, count($header));
        $kolom = $kolom_alphabet['kolom'];
        $index = $kolom_alphabet['index_awal_baru'];
        foreach($header as $row) {
			$tanggal = Y_m_d($row['tanggal']);
            if(in_array(date('N', strtotime($tanggal)), $m_jam_kerja_libur) or in_array($tanggal, $m_libur_nasional)) {
				$kolom_existing[$kolom[$index]] = [
					'hightlight_libur' => ['start' => $start]
				];
			}
            $index++;
        }
        return $kolom_existing;
    }
}

if(!function_exists('baris_highlight_libur')) {
    function baris_highlight_libur($parameter) {
        $CI =& get_instance();
        $CI->load->helper('tanggal');
        $CI->load->model('Pengaturan_shift_m');

        $m_jam_kerja_libur = [6, 7];
        $m_libur_nasional  = $CI->Pengaturan_shift_m->m_libur_nasional($parameter['periode_awal'], $parameter['periode_akhir']);
        $list_tanggal      = list_tanggal($parameter['periode_awal'], $parameter['periode_akhir']);

        $row    = [];
        $header = $parameter['header'];
        $index  = $header;
        if($parameter['jenis'] == 'data_absensi') {
            for($i = 1; $i <= count($parameter['data']); $i++) {
                foreach($list_tanggal as $tanggal) {
                    if(in_array(date("N", strtotime($tanggal)), $m_jam_kerja_libur) or in_array($tanggal, $m_libur_nasional)) {
                        $row[$index] = [
                            'highlight_libur' => ['awal' => $parameter['awal'], 'akhir' => $parameter['akhir']],
                            'height'          => 30
                        ];
                    } else {
                        $row[$index] = ['height' => 30];
                    }
                    $index++;
                }    
                $index = $index+$header+1;
            }
        } elseif($parameter['jenis'] == 'laporan_aktivitas') {
            foreach($parameter['data'] as $data_per_karyawan) {
                foreach($data_per_karyawan['data_aktivitas'] as $waktu => $data_aktivitas_detail) {
                    if(in_array(date("N", strtotime($waktu)), $m_jam_kerja_libur) or in_array(Y_m_d($waktu), $m_libur_nasional)) {
                        $row[$index] = [
                            'highlight_libur' => ['awal' => $parameter['awal'], 'akhir' => $parameter['akhir']],
                            'height'          => 30
                        ];
                    } else {
                        $row[$index] = ['height' => 30];
                    }
                    $index++;
                }
                $index = $index+$header+1;
            }
        }
        return $row;
    }
}