<form>
    <table id="list_data_aspek_kepribadian" class="table table-striped table-bordered">
        <thead style="font-family: Poppins SemiBold;">
            <tr>
                <th class="align-middle _vtop_center" rowspan=2>No</th>
                <th class="align-middle _vtop" rowspan=2>Personal Aspek</th>
                <th class="align-middle _vtop" rowspan=2 width=250>Description</th>
                <th class="align-middle _vtop_center" rowspan=2>Bobot</th>
                <th class="align-middle" colspan=5>Target</th>
                <th class="align-middle _vtop_center" width=150 rowspan=2>Aktual</th>
                <th class="align-middle _vtop_center" width=150 rowspan=2>Skor</th>
            </tr>
            <tr>
                <th class="align-middle _vtop" width=150>1</th>
                <th class="align-middle _vtop" width=150>2</th>
                <th class="align-middle _vtop" width=150>3</th>
                <th class="align-middle _vtop" width=150>4</th>
                <th class="align-middle _vtop" width=150>5</th>
            </tr>
        </thead>
        <tbody></tbody>
        <tfoot>
            <tr height=50>
                <th class="align-middle text-center" colspan=3 style="font-family: 'Poppins Bold';">Total</th>
                <th class="align-middle" style="font-family: 'Poppins Bold';">0%</th>
                <th colspan=7></th>
            </tr>
        </tfoot>
    </table>
    <div class="row mt-2">
        <div id="message" class="col-md-10"></div>
        <div id="div_draft" class="col-md-2 text-right"></div>
    </div>
</form>
<script>
    $(function() {
        list_data = $('#list_data_aspek_kepribadian').DataTable({
            searching: false,
            ordering : false,
            paging   : false,
            info     : false,
            scrollY  : true,
            scrollX  : false,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            columnDefs: [
                { targets: '_center', className: "text-center" },
                { targets: '_vtop', className: "align-top" },
                { targets: '_vtop_center', className: "align-top text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.approval.detail.aspek-kepribadian.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    d.karyawan = $('#karyawan').val();
                    d.tahun    = $('#tahun').val();
                    d.bulan    = $('#bulan').val();
                },
                complete: function(data) {
                    var pembungkus = $(".div_pembungkus_js_menu_context")
                    if(pembungkus == null || pembungkus == undefined){
                        // jalankan selanjutnya
                    }else{
                        var outerHeight = $('.body_laporan').outerHeight();
                        outerHeight = outerHeight * 90 / 100;
                        pembungkus.css('height', outerHeight);
                    }
                },
            },
            footerCallback: function(row, data) {
                var total = 0;
                data.forEach((item) => total = total + parseInt(item[3].replace("%", "")));
                this.api().column(3).footer().innerHTML = total+"%";
            },
            drawCallback: function() {
                const modal = $('#modal_form').hasClass("show");
                const message = $('#tampil_form #message').html();
                if(modal == true && message == '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Aspek kepribadian belum dilengkapi</font>' ) {
                    var   rules = {};
                    const total = $("select[name^='actual']").length;
                    for(i = 0; i < total; i++) {
                        rules["actual["+i+"]"] = {selectKpiAct: true};
                    }
                    
                    $('form').validate({
                        rules: rules
                    });
                    $('form').valid();
                }

                button('draft');
            }
        });
    });

    $(document).off('submit', 'form');
    $(document).on('submit', 'form', function(e) {
        $('form #message').html('');
        e.preventDefault();
        const l = Ladda.create(document.querySelector('#simpan'));
        const data = "&karyawan="+$('#karyawan').val()+"&tahun="+$('#tahun').val()+"&bulan="+$('#bulan').val()+"&jabatan="+$('#jabatan').val();
        l.start();
        $.post("<?= route('kpi.approval.detail.aspek-kepribadian.save') ?>", $(this).serialize()+data, function(result) {
            $('form #message').html(result.message);
            l.stop();
        }, 'json');
    });
</script>