<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Wizard_m extends CI_Model{

  public function __construct()
  {
    parent::__construct();
    //Codeigniter : Write Less Do More
  }

  function buat_karyawan($data) {
      $data_karyawan = array(
          'id_karyawan'	=> $data['id_karyawan'],
          'nama_lengkap'	=> $data['nama'],
          'id_cabang' 	=> $data['id_cabang'],
          'id_jabatan'	=> $data['id_jabatan'],
          'id_departemen' => $data['id_departemen'],
          'status' 		=> '2',
          'jatah_cuti' 	=> '12',
          'nik' => $data['nik'],
          'id_company' 	=> $data['id_company']
      );
      $data_temp['data_karyawan']	= $data_karyawan;

      $data_users = array(
          'id_user'		=> $data['id_user'],
          'username' 		=> $data['username'],
          'password' 		=> sha1(sha1(md5($data['password']))),
          'password_2'  => $data['password'],
          'id_karyawan' 	=> $data['id_karyawan'],
          'id_company' 	=> $data['id_company']
      );
      $data_temp['data_users']	= $data_users;
      return $data_temp;
  }

  function data_cabang() {
    $id_company = $this->session->userdata('id_company');

    $this->db->where('id_company', $id_company);
    $this->db->order_by('id_cabang','desc');
    $this->db->limit(1);
    return $this->db->get('master_cabang')->row_array();
  }

  function data_departemen() {
    $id_company = $this->session->userdata('id_company');

    $this->db->where('id_company', $id_company);
    $this->db->order_by('id_departemen','desc');
    $this->db->limit(1);
    return $this->db->get('master_departemen')->row_array();
  }

  function data_jabatan() {
    $id_company = $this->session->userdata('id_company');

    $this->db->where('level_user', 2);
    $this->db->where('id_company', $id_company);
    $this->db->order_by('id_jabatan', 'desc');
    $this->db->limit(1);
    return $this->db->get('master_jabatan')->row_array();
  }

  function data_jabatan_staff() {
    $id_company = $this->session->userdata('id_company');

    $this->db->where('level_user', 3);
    $this->db->where('id_company', $id_company);
    $this->db->order_by('id_jabatan', 'desc');
    $this->db->limit(1);
    return $this->db->get('master_jabatan')->row_array();
  }

  function cek_id_absensi_masuk($id_company) {
    $this->db->select('id_absensi_masuk');
    $this->db->like('id_absensi_masuk', $id_company.date('Ym'), 'after');
    $this->db->order_by('id_absensi_masuk', 'desc');
    $this->db->limit(1);
    return $this->db->get('absensi_masuk');
  }

  function cek_id_absensi_pulang($id_company) {
    $this->db->select('id_absensi_pulang');
    $this->db->like('id_absensi_pulang', $id_company.date('Ym'), 'after');
    $this->db->order_by('id_absensi_pulang', 'desc');
    $this->db->limit(1);
    return $this->db->get('absensi_pulang');
  }

  function id_absensi_masuk($id_company) {
    //mengecek apakah ada id absensi pada bulan tsb
    $cek = $this->cek_id_absensi_masuk($id_company);
    if($cek->num_rows() > 0) {
      //jika ada ambil dan tambah 1
      $id = (int)ltrim(str_replace($id_company.date('Ym'), "", $cek->row()->id_absensi_masuk), '0')+1;
      return $id;
    } else {
      //jika tidak ada isi 1
      return 1;
    }
  }

  function id_absensi_pulang($id_company) {
    //mengecek apakah ada id absensi pada bulan tsb
    $cek = $this->cek_id_absensi_pulang($id_company);
    if($cek->num_rows() > 0) {
      //jika ada ambil dan tambah 1
      $id = (int)ltrim(str_replace($id_company.date('Ym'), "", $cek->row()->id_absensi_pulang), '0')+1;
      return $id;
    } else {
      //jika tidak ada isi 1
      return 1;
    }
  }

  function buat_absensi($data_karyawan, $data_cabang, $data_departemen, $data_jabatan) {

		$tanggal_sekarang = date('Y-m-d');
		$tanggal_temp = explode("-", $tanggal_sekarang);
		$bulan = $tanggal_temp[1]-1;
		$tahun = $tanggal_temp[0];
		if($bulan == "0") {
			$tahun = $tahun-1;
			$bulan = "12";
		} elseif(strlen($bulan) == 1) {
			$bulan = "0".$bulan;
		}

		$tanggal_satu_bulan_lampau =$tahun."-".$bulan."-01";
		$begin = new DateTime($tanggal_satu_bulan_lampau);
		$end = new DateTime($tanggal_sekarang);

		$interval = DateInterval::createFromDateString('1 day');
		$period = new DatePeriod($begin, $interval, $end);
		$no_masuk = $this->id_absensi_masuk($data_karyawan['id_company']);
		$no_pulang = $this->id_absensi_pulang($data_karyawan['id_company']);
		foreach ($period as $dt) {
		    $tanggal = $dt->format("Y-m-d");
				$weekend = $dt->format("w");
				$id_absensi_masuk = $data_karyawan['id_company'].date('Ym').str_pad($no_masuk, 5, "0", STR_PAD_LEFT);
				$id_absensi_pulang = $data_karyawan['id_company'].date('Ym').str_pad($no_pulang, 5, "0", STR_PAD_LEFT);
				$random_jam_absen_masuk = date('Y-m-d H:i:s', rand(strtotime($tanggal.' 07:30:00'), strtotime($tanggal.' 08:30:00')));
				$random_jam_absen_pulang = date('Y-m-d H:i:s', rand(strtotime($tanggal.' 16:30:00'), strtotime($tanggal.' 17:30:00')));

				if(strtotime($random_jam_absen_masuk) > strtotime($tanggal.' 08:00:00')) {
					$from_time = strtotime($tanggal.' 08:00:00');
					$to_time = strtotime($random_jam_absen_masuk);

					$terlambat = floor(round(abs($to_time - $from_time) / 60, 2));
					$kode_absen = 'H,(T)';
				} else {
					$terlambat = 0;
					$kode_absen = 'H';
				}
				$kode_absensi = $kode_absen;

				if(strtotime($random_jam_absen_pulang) < strtotime($tanggal.' 17:00:00')) {
					$from_time = strtotime($random_jam_absen_pulang);
					$to_time = strtotime($tanggal.' 17:00:00');
					$kode_absensi = $kode_absensi.',(PC)';
					$pulang_cepat = floor(round(abs($to_time - $from_time) / 60, 2));
				} else {
					$pulang_cepat = '0';
				}

				//jika libur w = 6 atau w = 0 maka tidak diinsert
				if($weekend != 6 and $weekend != 0) {
					$absensi_masuk[] = array(
						'id_absensi_masuk' => $id_absensi_masuk,
						'id_karyawan'	=> $data_karyawan['id_karyawan'],
						'tgl_absen' => $tanggal,
						'jenis_absen' => 'reguler',
						'jam_kerja' => '08:00:00',
						'jam_absen' => $random_jam_absen_masuk,
						'terlambat' => $terlambat,
						'kode_absen' => $kode_absen,
						'ket_kode' => 'Reguler',
						'lokasi_absen' => 'Di luar radius kantor',
						'timezone' => 'Asia/Jakarta',
						'gmt' => '+07:00',
						'latitude' => '-6.1731155',
						'longitude' => '106.8715982',
						'keterangan' => '',
						'foto' => '',
						'id_company' => $data_karyawan['id_company']
					);
				}

				//jika libur w = 6 atau w = 0 maka tidak diinsert
				if($weekend != 6 and $weekend != 0) {
					$absensi_pulang[] = array(
						'id_absensi_pulang'	=> $id_absensi_pulang,
						'id_karyawan'	=> $data_karyawan['id_karyawan'],
						'id_masuk'	=> $id_absensi_masuk,
						'tgl_absen' => $tanggal,
						'jam_kerja' => '17:00:00',
						'jam_absen' => $random_jam_absen_pulang,
						'pulang_cepat' => $pulang_cepat,
						'keterangan' => '',
						'lokasi_absen' => 'Di luar radius kantor',
						'timezone' => 'Asia/Jakarta',
						'gmt' => '+07:00',
						'latitude' => '-6.1731155',
						'longitude' => '106.8715982',
						'foto' => '',
						'id_company' => $data_karyawan['id_company']
					);
				}

				$rekap = array(
					'id_karyawan' => $data_karyawan['id_karyawan'],
					'nik' => $data_karyawan['nik'],
					'nama_karyawan' => $data_karyawan['nama_lengkap'],
					'id_cabang'	=> $data_cabang['id_cabang'],
					'kode_cabang' => $data_cabang['kode'],
					'nama_cabang' => $data_cabang['nama'],
					'id_departemen' => $data_departemen['id_departemen'],
					'kode_departemen' => $data_departemen['kode'],
					'nama_departemen' => $data_departemen['nama'],
					'id_jabatan' => $data_jabatan['id_jabatan'],
					'kode_jabatan' => $data_jabatan['kode_jabatan'],
					'nama_jabatan' => $data_jabatan['nama'],
					'tgl_absen' => $tanggal,
					'id_company' => $data_karyawan['id_company']
				);

				if($weekend != 6 and $weekend != 0) {
					$rekap['jenis_absen'] = 'reguler';
					$rekap['kode_absensi'] = $kode_absensi;
					$rekap['ket_kode'] = 'Reguler';
					$rekap['jam_masuk_kerja'] = '08:00:00';
					$rekap['absen_masuk'] = $random_jam_absen_masuk;
					$rekap['terlambat'] = $terlambat;
					$rekap['lokasi_masuk'] = 'Di luar radius kantor';
					$rekap['timezone_masuk'] = 'Asia/Jakarta';
					$rekap['gmt_masuk'] = '+07:00';
					$rekap['lat_masuk'] = '-6.1731155';
					$rekap['long_masuk'] = '106.8715982';
					$rekap['ket_absen_masuk'] = '';
					$rekap['foto_masuk'] = '';
					$rekap['jam_pulang_kerja'] = '17:00:00';
					$rekap['absen_pulang'] = $random_jam_absen_pulang;
					$rekap['pulang_cepat'] = $pulang_cepat;
					$rekap['lokasi_pulang'] = 'Di luar radius kantor';
					$rekap['timezone_pulang'] = 'Asia/Jakarta';
					$rekap['gmt_pulang'] = '+07:00';
					$rekap['lat_pulang'] = '-6.1731155';
					$rekap['long_pulang'] = '106.8715982';
					$rekap['ket_absen_pulang'] = '';
					$rekap['foto_absen_pulang'] = '';
				} else {
					$rekap['jenis_absen'] = 'libur';
					$rekap['kode_absensi'] = 'L';
					$rekap['ket_kode'] = 'Libur';
					$rekap['jam_masuk_kerja'] = '00:00:00';
					$rekap['absen_masuk'] = '';
					$rekap['terlambat'] = 0;
					$rekap['lokasi_masuk'] = '';
					$rekap['timezone_masuk'] = '';
					$rekap['gmt_masuk'] = '';
					$rekap['lat_masuk'] = '';
					$rekap['long_masuk'] = '';
					$rekap['ket_absen_masuk'] = '';
					$rekap['foto_masuk'] = '';
					$rekap['jam_pulang_kerja'] = '00:00:00';
					$rekap['absen_pulang'] = '';
					$rekap['pulang_cepat'] = 0;
					$rekap['lokasi_pulang'] = '';
					$rekap['timezone_pulang'] = '';
					$rekap['gmt_pulang'] = '';
					$rekap['lat_pulang'] = '';
					$rekap['long_pulang'] = '';
					$rekap['ket_absen_pulang'] = '';
					$rekap['foto_absen_pulang'] = '';
				}
				$r_absensi[] = $rekap;
				$no_masuk++;
        $no_pulang++;
		}

		$data['absensi_masuk'] = $absensi_masuk;
		$data['absensi_pulang'] = $absensi_pulang;
		$data['r_absensi'] = $r_absensi;
		return $data;
	}

  function cek_max_id($tabel, $where, $digit, $tahun_sekarang) {
    $this->db->select("RIGHT(MAX(".$where."), ".$digit.") as no_urut");
    $this->db->like($where, $tahun_sekarang, "after");
    return $this->db->get($tabel);
  }

  function generate_id($tabel, $where, $digit, $id_company = "", $default = 1) {
    /* Tahun + 5 digit nomor urut 		= Id_company, id_customer
     * id company + yyyymm + 3 digit 	= Id_cabang, id jabatan, id_departemen
     * id company + yyyymm + 4 digit 	= id karyawan, id_user
     * id company + yyyy + 2 digit		= id_transaksi
     * Cari dulu apakah ada MAX berdasarkan tahun sekarang, jika tidak ada buat baru
     * Jika ada tambah satu dari MAX yang ada */

     if($digit == 5 or $digit == 2) {
      $tanggal_sekarang	= date("Y");
     } else {
      $tanggal_sekarang	= date("Ym");
     }
     $cek_max_id	= $this->cek_max_id($tabel, $where, $digit, $id_company.$tanggal_sekarang);

     if($cek_max_id->num_rows() > 0) {
      $no_urut		= $cek_max_id->row()->no_urut;
      $no_urut_inc	= $this->no_urut_inc($no_urut, $digit, $default);
      $id				= $id_company.$tanggal_sekarang.$no_urut_inc;
     } else {
       $id			= $id_company.$tanggal_sekarang.str_repeat(0, $digit-1)."1";
     }
     return $id;
  }

  function no_urut_inc($no_urut, $length, $default) {
		$number				= (int)$no_urut;
		$number_plus_one	= $number+$default;
		$string 			= substr(str_repeat(0, $length).$number_plus_one, - $length);
		return $string;
	}

  function total_departemen() {
    $this->db->where('id_company', $this->session->userdata('id_company'));
    return $this->db->count_all_results('master_departemen');
  }

  function total_karyawan_level($level) {
    $this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan');
    $this->db->where('level_user', $level);
    $this->db->where('data_karyawan.id_company', $this->session->userdata('id_company'));
    return $this->db->count_all_results('data_karyawan');
  }
}
