<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Group_product extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/master/Group_product_m');
    }

    public function list_data(){                                                                                                                                                  
        $list = $this->Group_product_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();

            $row[] = '<span class="sort" style="cursor:-webkit-grab; cursor:grab;" title="Tarik keatas / kebawah" data-key="' . $field->id_product_group_m . '">
                        <i class="fa fa-sort"></i>&nbsp&nbsp'. $no.
                    '</span>';
            
            $row[] = htmlspecialchars($field->kode);
            $row[] = htmlspecialchars($field->nama);

            if($this->fungsi->cek_adm_satu_grup() == false){
                $row[] = $field->nama_group_area . "<br><b>" . $field->kode_group_area . "</b>";
            }

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_product_group_m) . '" class="btn_edit_m_group_product fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_product_group_m) . '" class="btn_delete_m_group_product fa fa-trash"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Group_product_m->count_all(),
            "recordsFiltered" => $this->Group_product_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Group_product_m->getDataById($id);
		}
		$this->load->view('sales_activity/master/group_product/form',$data);
    }

    public function save(){
        $id = $this->input->post('id_product_group_m');

        $data = array(
                'nama'       => $this->input->post('nama'),
                'kode'       => $this->input->post('kode'),
                'id_group_m' => $this->input->post('id_group_m'),
                'id_company' => $this->id_company
            );
        
        $this->Group_product_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Group_product_m->delete($id);
    }

    public function update_order(){
        $order = $this->input->post('order');

        $data = array();
        foreach ($order as $key) {
            $data[] = [
                'concat(id_product_group_m,id_company)' => $key['id_product_group_m'] . $this->id_company,
                'no_urut' => $key['no_urut']
            ];
        }

        $this->Group_product_m->update_order($data);
    }
}