<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Jabatan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Jabatan_m');

        check_login();
    }

    public function index()
    {
        $data['judul']   = $this->lang->line('menu_jabatan');
        $data['aktif']   = 'jabatan';
        $data['level']   = $this->Jabatan_m->getLevelUser();
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('jabatan/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data()
    {
        $leveluser = $this->input->get("leveluser");
        $list = $this->Jabatan_m->get_datatables($leveluser);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->kode_jabatan;
            $row[] = $field->nama;
            $row[] = $field->level;

            if (in_array($this->level_user, array("1")) || in_array($this->session->userdata('level_khusus'), array("1"))) {
                if ($field->kode_jabatan == 'HR') {
                    $row[] = '';
                } else {
                    $row[] = '<a href="#" class="text-warning" title="EDIT">
								<i id="' . md5($field->id_jabatan) . '" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
							<a href="#" class="text-danger" title="' . $this->lang->line('hapus') . '">
								<i id="' . md5($field->id_jabatan) . '" class="btn_delete fa fa-trash"></i>
							</a>';
                }
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Jabatan_m->count_all($leveluser),
            "recordsFiltered" => $this->Jabatan_m->count_filtered($leveluser),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null)
    {
        $data['level']   = $this->Jabatan_m->getLevelUser();
        if ($id != null) {
            $data['data'] = $this->Jabatan_m->getDataById($id);
        }
        $this->load->view('jabatan/form', $data);
    }

    public function save()
    {
        $id = $this->input->post('id_jabatan');
        $level_user_lama = $this->input->post('level_user_lama');

        $data = array(
            'kode_jabatan' => $this->input->post('kd_jabatan'),
            'nama'         => $this->input->post('nm_jabatan'),
            'level_user'   => $this->input->post('level'),
            'id_company'   => $this->id_company
        );

        $this->Jabatan_m->save($data, $id, $level_user_lama);
    }

    public function delete()
    {
        $id = $this->input->post("id_jabatan");
        $this->Jabatan_m->delete($id);
    }
}
