<style>
    .custom-loader {
        width: 25px;
        height: 25px;
        border-radius: 50%;
        border: 4px solid;
        border-color: #E4E4ED;
        border-right-color: #1c77d4;
        animation: s2 1s infinite linear;
    }

    @keyframes s2 {
        to {
            transform: rotate(1turn)
        }
    }
</style>
<script>
    $(function() {
        dropdown_bulan();
        list_datatable();

        // Action Button Filter
        $("#btn_filter").on("click", function() {
            if ($("#view-table").length) {
                list_datatable("chart", this);
            } else {
                list_datatable("table", this);
            }
        });
    });

    function dropdown_bulan() {
        $(".filter #bulan").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });

        $(".filter #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
            endDate: "today"
        });
    }

    function dropdown_group() {
        let bulan = $(".filter #bulan").val();
        $(".filter #nama_group").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.data.sales.dropdown.group") ?>' + '/' + bulan,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_dropdown_bulan() {
        dropdown_group();
    }

    function list_datatable(view = "table", e = "") {
        if (e !== "") {
            var loading = Ladda.create(e);
            loading.start();
        }

        var load_url   = "";
        var bulan      = $(".filter #bulan").val();
        var nama_group = $(".filter #nama_group").val() ? $('.filter #nama_group').val() : "all";

        if (view === "table") {
            load_url = "<?= route('sales_activity.report.data.sales.view.data', ['bulan' => '" + bulan + "', 'nama_group' => '" + nama_group + "']) ?>";
        } else {
            load_url = "<?= route('sales_activity.report.data.sales.view.diagram', ['bulan' => '" + bulan + "', 'nama_group' => '" + nama_group + "']) ?>";
        }

        return $.get(load_url, function(data) {
            $("#view_data").html(data);
            if (e !== "") loading.stop();
        });
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Report <?= $this->lang->line('pipeline'); ?></h5>
    </div>
</div>
<hr>

<div class="filter mt-2">
    <div class="row">
        <div class="col-md-2">
            <label><?= $this->lang->line('bulan'); ?></label>
            <input type="text" id="bulan" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('m-Y') ?>" onchange="onchange_dropdown_bulan()">
        </div>

        <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
            <div class="col-md-3">
                <label><?= $this->lang->line('group_area'); ?></label>
                <select class="form-control" id="nama_group" style="width: 100%"></select>
            </div>
        <?php endif; ?>

        <div class="col-md-1 align-self-end">
            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>

<div id="view_data"></div>
