<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= site_url('pengaturan/atasan-khusus/list-data') ?>",
                                    "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false }
                                         <?php
                                            if (in_array($this->session->userdata('level_user'), array("1"))) {
                                        ?>
                                        , { "aTargets": [5], "bSortable": false }

                                        <?php }?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(0)', nRow).css({'width':'10px'});


                             <?php
                                if (in_array($this->session->userdata('level_user'), array("1"))) {
                            ?>

                            $('td:eq(5)', nRow).css({'text-align':'center'});
                            $('td:eq(5)', nRow).css({'width':'100px'});

                            <?php }?>
                    }
        
        });


        $(document).on('click','.btn_tambah',function(){
            $('#tampil_form').load("<?= site_url('pengaturan/atasan-khusus/form/tambah') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('SIMPAN');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= site_url('pengaturan/atasan-khusus/form/edit/') ?>"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_delete',function(){
            $('#tampil_form').load("<?php echo site_url('pengaturan/atasan-khusus/form/hapus/') ?>"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $("#cabang, #departemen, #jabatan, #atasan").prop("disabled", true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('HAPUS');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click','#btn_new_input', function(){
            $("#cabang, #departemen, #jabatan, #atasan").prop("disabled", false);
            $("#cabang").val('').trigger('change');
            $("#departemen").val('').trigger('change');
            $("#jabatan").val('').trigger('change');
            $("#atasan").val('').trigger('change');
            
            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);
        
            if($("#cabang").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                $('#cabang').focus();
                return false;
            }else if($("#departemen").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Departemen belum dipilih</font>");
                $('#departemen').focus();
                return false;
            }else if($("#jabatan").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Jabatan belum dipilih</font>");
                $('#jabatan').focus();
                return false;
            }else if($("#atasan").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Atasan belum dipilih</font>");
                $('#atasan').focus();
                return false;
            }
            
            loading.start();
            
            var param = new FormData();
                      param.append('cabang',$("#cabang").val());
                      param.append('departemen',$("#departemen").val());
                      param.append('jabatan',$("#jabatan").val());
                      param.append('atasan',$("#atasan").val());
                      param.append('id',$("#id").val());
        
            $.ajax({
                type: 'POST',
                url: "<?= site_url('pengaturan/atasan-khusus/save') ?>",
                data: param,
                dataType:'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#cabang, #departemen, #jabatan, #atasan").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click','.btn_hapus',function(){
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('pengaturan/atasan-khusus/delete') ?>",
                data: 'id='+$("#id").val(),
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message);
                    
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Master Data</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
            ?>
            <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">CABANG</th>
                            <th class="text-left">DEPARTEMEN</th>
                            <th class="text-left">JABATAN</th>
                            <th class="text-left">ATASAN</th>
                           <?php
                                if(in_array($this->session->userdata('level_user'), array("1"))) {
                            ?>
                            <th class="text-center">AKSI</th>
                            <?php
                                }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


