<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_kepegawaian') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row mt-2">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-3">
                            <label><?= $this->lang->line('nama_karyawan') ?></label>
                            <select id="karyawan" class="select2 form-control" style="width: 100%;">
                            </select>
                        </div>
                        <div class="col-md-2 align-self-end">
                            <button type="button" id="btn_cari" class="btn btn-info ladda-button" data-style="expand-left"><?= $this->lang->line('button_cari') ?></button>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-md-3">
                            <label><?= $this->lang->line('jabatan') ?></label>
                            <select id="jabatan" class="select2 form-control" style="width: 100%;"></select>
                        </div>
                        <?php
                        if (in_array($this->level_user, array("1", "4")) || $this->multi_cabang == true) {
                        ?>
                            <div class="col-md-3">
                                <label><?= $this->lang->line('cabang') ?></label>
                                <select id="cabang" class="select2 form-control" style="width: 100%;">
                                </select>
                            </div>
                        <?php
                        }

                        if (in_array($this->level_user, array("1", "4", "5")) || $this->multi_departemen == true) {
                        ?>
                            <div class="col-md-2">
                                <label><?= $this->lang->line('departemen') ?></label>
                                <select id="departemen" class="select2 form-control" style="width: 100%;">
                                </select>
                            </div>
                        <?php } ?>
                        <div class="col-md-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <label>Status</label>
                                    <select id="status" class="select2 form-control" style="width: 100%;">
                                        <option value="0" selected><?= $this->lang->line('semua') ?></option>
                                        <option value="1"><?= $this->lang->line('kontrak') ?></option>
                                        <option value="2"><?= $this->lang->line('tetap') ?></option>
                                        <option value="3"><?= $this->lang->line('izin_belajar') ?></option>
                                        <option value="4"><?= $this->lang->line('tugas_belajar') ?></option>
                                        <option value="5"><?= $this->lang->line('resign') ?></option>
                                        <option value="6"><?= $this->lang->line('dikeluarkan') ?></option>
                                        <option value="7"><?= $this->lang->line('pensiun') ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label><?= $this->lang->line('jenis_kelamin') ?></label>
                                    <select id="jenis_kelamin" class="form-control">
                                        <option value="ALL" selected><?= $this->lang->line('semua') ?></option>
                                        <option value="L"><?= $this->lang->line('laki_laki') ?></option>
                                        <option value="P"><?= $this->lang->line('perempuan') ?></option>
                                        <option value="uknown"><?= $this->lang->line('belum_diatur') ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-1 align-self-end">
                            <button type="button" id="btn_filter" class="btn btn-info ladda-button" data-style="expand-left">FILTER</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-12 table-responsive">
                    <table id="list_data" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>NO</th>
                                <th class="text-uppercase"><?= $this->lang->line('foto') ?></th>
                                <th width="15%" class="text-left"><?= $this->lang->line('karyawan') ?></th>
                                <th class="text-left text-uppercase"><?= $this->lang->line('cabang') ?></th>
                                <th class="text-left text-uppercase"><?= $this->lang->line('departemen') ?></th>
                                <th class="text-left text-uppercase"><?= $this->lang->line('jabatan') ?></th>
                                <th class="text-uppercase">STATUS</th>
                                <th class="text-uppercase"><?= $this->lang->line('jenis_kelamin') ?></th>
                                <th class="text-uppercase"><?= $this->lang->line('aksi') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        if (sessionStorage.getItem("back_button") == "true") {
            restore_session();
        }

        if (sessionStorage.getItem("back_button") == "true" && sessionStorage.getItem("search_jenis") == "cari") {
            var id_cabang = 0;
            var id_departemen = 0;
            var id_jabatan = 0;
            var status = 0;
            var jenis_kelamin = $("#jenis_kelamin").val();
            var id_karyawan = sessionStorage.getItem("karyawan");
        } else if (sessionStorage.getItem("back_button") == "true" && sessionStorage.getItem("search_id") == "filter") {
            var id_cabang = (sessionStorage.getItem("cabang") == null) ? "0" : sessionStorage.getItem("cabang");
            var id_departemen = (sessionStorage.getItem("departemen") == null) ? "0" : sessionStorage.getItem("departemen");
            var id_jabatan = (sessionStorage.getItem("jabatan") == null) ? "0" : sessionStorage.getItem("jabatan");
            var status = $("#status").val();
            var jenis_kelamin = $("#jenis_kelamin").val();
            var id_karyawan = 0;
        } else {
            var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
            var id_departemen = ($("#departemen").val() == null) ? "0" : $("#departemen").val();
            var id_jabatan = ($("#jabatan").val() == null) ? "0" : $("#jabatan").val();
            var status = $("#status").val();
            var jenis_kelamin = $("#jenis_kelamin").val();
            var id_karyawan = 0;
        }

        if (sessionStorage.getItem("dt_paging_current") != null) {
            var page = parseInt(sessionStorage.getItem("dt_paging_current"));
        } else {
            var page = 0;
        }

        var option = {
            'searching': false,
            'searchDelay': 250,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            <?php if ($this->code_lang == 'id') {
                echo "
                'language': {
                    'url': '" . base_url("assets/plugins/datatables/dataTables-language-id.json") . "',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan'
                },";
            }; ?> "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('dashboard.kepegawaian.notif.list-data') ?>" + "/filter/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + status + "/" + jenis_kelamin + "/" + id_karyawan,
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                    d.start = page * d.length;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                },
                {
                    "aTargets": [1],
                    "bSortable": false
                },
                {
                    "aTargets": [-1],
                    "bSortable": false
                }
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(1)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(6)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(7)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(-1)', nRow).css({
                    'text-align': 'center',
                    'width': '50'
                });
            },
            initComplete: function() {
                set_default_page();
            }
        };

        if (sessionStorage.getItem("dt_length") != null) {
            option.pageLength = parseInt(sessionStorage.getItem("dt_length"));
        }

        list_data = $('#list_data').DataTable(option);

        list_data.on('page.dt', function() {
            page = list_data.page();
        });

        list_data.on('length.dt', function() {
            page = 0;
            list_data.page(0).draw('page');
        });

        $('#karyawan').select2({
            placeholder: '<?= $this->lang->line('semua_karyawan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.karyawan")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#jabatan').select2({
            placeholder: '<?= $this->lang->line('semua_jabatan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                // url: '<?= route("dropdown.jabatan.by.departemen") ?>'+"/"+id_cabang+"/"+id_departemen,
                url: '<?= route("dropdown.jabatan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#cabang').change(function() {
            if (sessionStorage.getItem("cabang") == null) {
                $('#departemen').val('0').trigger("change");
                departemen();
            }
        });

        departemen();

        sessionStorage.clear();
    });

    function departemen() {
        var level_user = '<?= $this->level_user ?>';
        var multi_cabang = '<?= $this->multi_cabang ?>';

        if (level_user == "1" || level_user == "4") { // ADMIN HR DAN DIREKSI
            var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
        } else { // KEPALA CABANG
            if (multi_cabang == '1') {
                var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
            } else {
                var id_cabang = '<?= $this->id_cabang ?>';
            }
        }

        $('#departemen').select2({
            placeholder: '<?= $this->lang->line('semua_departemen') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.departemen.by.cabang") ?>' + "/" + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    $('#btn_cari').click(function() {
        page = 0;
        save_filter_session_search('cari');

        var loading = Ladda.create(this);
        loading.start();

        var id_cabang = 0;
        var id_departemen = 0;
        var id_jabatan = 0;
        var status = 0;
        var jenis_kelamin = $('#jenis_kelamin').val();
        var id_karyawan = ($("#karyawan").val() == null) ? "0" : $("#karyawan").val();

        list_data.ajax.url("<?= route('dashboard.kepegawaian.notif.list-data') ?>" + "/cari/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + status + "/" + jenis_kelamin + "/" + id_karyawan)
        list_data.ajax.reload(function() {
            loading.stop();
        });
    });

    $('#btn_filter').click(function() {
        page = 0;
        save_filter_session_search('filter');

        var loading = Ladda.create(this);
        loading.start();

        var level_user = '<?= $this->level_user ?>';
        var multi_departemen = '<?= $this->multi_departemen ?>';
        var multi_cabang = '<?= $this->multi_cabang ?>';

        var id_jabatan = ($("#jabatan").val() == null) ? "0" : $("#jabatan").val();
        var status = $("#status").val();
        var jenis_kelamin = $('#jenis_kelamin').val();
        var id_karyawan = 0;

        if (level_user == "3") {
            var id_karyawan = "<?= $this->id_karyawan ?>";
        } else {
            var id_karyawan = 0;
        }


        if (level_user == "1" || level_user == "4") { // ADMIN HR DAN DIREKSI
            var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
            var id_departemen = ($("#departemen").val() == null) ? "0" : $("#departemen").val();
        } else if (level_user == "5") { // KEPALA CABANG
            if (multi_cabang == '1') {
                var id_cabang = ($("#cabang").val() == null) ? "0" : $("#cabang").val();
            } else {
                var id_cabang = '<?= $this->id_cabang ?>';
            }
            var id_departemen = ($("#departemen").val() == null) ? "0" : $("#departemen").val();
        } else if (level_user == "2") { // KEPALA DEPARTEMEN
            var id_cabang = '<?= $this->id_cabang ?>';
            if (multi_departemen == '1') {
                var id_departemen = ($("#departemen").val() == null) ? "0" : $("#departemen").val();
            } else {
                var id_departemen = '<?= $this->id_departemen ?>';
            }
        } else {
            var id_cabang = '<?= $this->id_cabang ?>';
            var id_departemen = '<?= $this->id_departemen ?>';
        }

        list_data.ajax.url("<?= route('dashboard.kepegawaian.notif.list-data') ?>" + "/filter/" + id_cabang + "/" + id_departemen + "/" + id_jabatan + "/" + status + "/" + jenis_kelamin + "/" + id_karyawan)
        list_data.ajax.reload(function() {
            loading.stop();
        });
    });

    // save filter session menggunakan session storage
    function save_filter_session() {
        var list_filter = ['karyawan', 'jabatan', 'cabang', 'departemen', 'jenis_kelamin', 'status'];

        list_filter.forEach(function(value) {
            var temp = $('#' + value).val();
            if (temp != null) {
                sessionStorage.setItem(value, temp);
            }
        });
        sessionStorage.setItem("back_notif_kepegawaian", "<?= route('dashboard.kepegawaian.notif') ?>");
        sessionStorage.setItem("dt_length", list_data.page.len());
        sessionStorage.setItem("dt_paging_current", list_data.page.info().page); //start from index 0
    }

    function save_filter_session_search(jenis) {
        sessionStorage.setItem("search_jenis", jenis);
    }

    function restore_session() {
        var search_jenis = sessionStorage.getItem("search_jenis");
        if (search_jenis != null) {
            restore_search_session();
            restore_filter_session();
        }
    }

    function restore_filter_session() {
        // restore filter
        if (sessionStorage.getItem("search_jenis") == "filter") {
            var list_filter = ['jabatan', 'cabang', 'departemen', 'jenis_kelamin', 'status'];
            list_filter.forEach(function(value) {
                var temp_value = sessionStorage.getItem(value);
                if (temp_value != null) {
                    if (value == 'jenis_kelamin') {
                        $('#jenis_kelamin').val(temp_value);
                    } else {
                        select2_preselect(value, temp_value);
                    }
                }
            });
        }
    }

    function restore_search_session() {
        // restore cari
        if (sessionStorage.getItem("search_jenis") == "cari") {
            var list_filter = ['karyawan'];
            list_filter.forEach(function(value) {
                var temp_value = sessionStorage.getItem(value);
                if (temp_value != null) {
                    select2_preselect(value, temp_value);
                }
            });
        }
    }

    function select2_preselect(id, value) {
        var tempSelect = $('#' + id);
        $.ajax({
            type: 'GET',
            url: '<?= site_url("dropdown/preselect") ?>/' + id + '/' + value,
            dataType: "json"
        }).then(function(data) {
            // create the option and append to Select2
            var option = new Option(data.text, data.id, true, true);
            tempSelect.append(option).trigger('change');
        });
    }

    function clear_session_search() {
        sessionStorage.removeItem("search_jenis");
    }

    function set_default_page() {
        if (sessionStorage.getItem("dt_paging_current") != null) {
            list_data.page(parseInt(sessionStorage.getItem("dt_paging_current"))).draw('page');
        }

        // clear session
        if (sessionStorage.getItem("back_button") == "true") {
            // simpan temp search
            var search_jenis = sessionStorage.getItem("search_jenis");

            sessionStorage.clear();
            if (search_jenis != null) {
                sessionStorage.setItem("search_jenis", search_jenis);
            }
        }
    }
</script>
