<script>
    function informasi_gaji_form_update(element, action) {
        const column = $(element).closest("div").attr("id");
        if (action == "update") {
            $("#" + column).load("<?= route('master.karyawan.payroll.informasi_gaji.form', ['column' => '" + column + "', 'id_karyawan' => $id_karyawan]) ?>");
        } else {
            const persen = $(element).data("persen");

            $("#modal_form #tampil_form").load("<?= route('master.karyawan.payroll.informasi_gaji.form_komponen') ?>", function() {
                $("#modal_form").modal("show");
                if (action == "delete") {
                    $(".title").text("Hapus nominal komponen?");
                    $("#btn_submit").html("<i class='fa fa-trash (alias)'></i> HAPUS");
                    $("#btn_submit").addClass("btn_submit btn btn-danger");
                } else {
                    $(".title").text("Tambah nominal " + persen + "% dari gapok?");
                    $("#btn_submit").html("<i class='fa fa-plus (alias)'></i> Tambah");
                    $("#btn_submit").addClass("btn_submit btn btn-primary");
                }

                $('.btn_submit').one('click', function(e) {
                    e.preventDefault();
                    var loading = Ladda.create(this);
                    loading.start();

                    var param = {};
                    param.action = action;
                    param.column = column;
                    param.id_karyawan = "<?= $id_karyawan ?>";

                    $.ajax({
                        type: 'POST',
                        url: "<?= route('master.karyawan.payroll.informasi_gaji.save_komponen') ?>",
                        data: param,
                        dataType: 'JSON',
                        success: function(result) {
                            loading.stop();
                            if (result.success == true) {
                                $("#modal_form").modal("hide");
                                load_informasi_gaji();
                            } else {
                                showMsg(result.message, false);
                            }
                        },
                        error: function() {
                            loading.stop();
                            showMsg("error", false);
                        }
                    });
                });
            });
        }
    }

    function informasi_gaji_disable_form(form, disabled = true) {
        $("#" + form + " input").attr("disabled", disabled);
    }

    function informasi_gaji_get_value_form(form) {
        return $("#" + form + " input").val();
    }
</script>
<div>
    <h5 class="text-primary mt-1">Informasi Gaji</h5>
    <hr>
    <h6 class="my-1 font-weight-bold">Pendapatan</h6>
    <div class="row">
        <div class="col-md-6">
            <div class="d-flex justify-content-between">
                <label>Gaji Pokok</label>
                <div class="form-inline justify-content-between font-weight-bold w-25" id="gapok">
                    <span>Rp</span>
                    <span><?= $gapok != '' ? dec_to_num($gapok, 2) : '0,00' ?></span>
                    <a href="javascript:void(0)" class="text-primary position-absolute" style="right: -10px" onclick="informasi_gaji_form_update(this, 'update')"><i class="fa fa-edit"></i></a>
                </div>
            </div>
            <div id="tunj_tetap">
                <?php if ($tunj_tetap->num_rows() > 0) {
                    foreach ($tunj_tetap->result() as $row) {
                ?>
                        <div class="d-flex justify-content-between">
                            <label><?= $row->nm_tunjangan ?></label>
                            <div class="form-inline justify-content-between font-weight-bold w-25" id="tunj_tetap_<?= $gapok . '_' . md5($row->id_item) ?>">
                                <span>Rp</span>
                                <span class="form-control-static"><?= $row->nominal_tunjangan != '' ? dec_to_num($row->nominal_tunjangan, 2) : '0,00' ?></span>
                                <?php if ($row->flag_persentase_gapok == '0') : ?>
                                    <a href="javascript:void(0)" class="text-primary position-absolute" style="right: -10px" onclick="informasi_gaji_form_update(this, 'update')"><i class="fa fa-edit"></i></a>
                                <?php else : ?>
                                    <?php if ($row->nominal_tunjangan > 0) : ?>
                                        <a href="javascript:void(0)" class="text-danger position-absolute" style="right: -10px" data-persen="<?= $row->gapok_persen ?>" onclick="informasi_gaji_form_update(this, 'delete')"><i class="fa fa-trash"></i></a>
                                    <?php else : ?>
                                        <a href="javascript:void(0)" class="text-primary position-absolute" style="right: -10px" data-persen="<?= $row->gapok_persen ?>" onclick="informasi_gaji_form_update(this, 'add')"><i class="fa fa-plus"></i></a>
                                    <?php endif; ?>
                                <?php endif ?>
                            </div>
                        </div>
                        <?php if ($row->flag_persentase_gapok == '1' && $row->nominal_tunjangan > 0) : ?>
                            <p class="text-right" style="font-size: 11px">(<?= $row->gapok_persen ?>% dari gapok)</p>
                        <?php endif; ?>
                <?php }
                } ?>
            </div>
            <hr>
            <div class="d-flex justify-content-between">
                <label>Total Pendapatan</label>
                <span class="d-flex justify-content-between font-weight-bold w-25">
                    <span>Rp</span>
                    <span><?= dec_to_num($gapok + $ttl_tunj_tetap, 2) ?></span>
                </span>
            </div>
        </div>
    </div>
    <h6 class="my-1 font-weight-bold">Potongan</h6>
    <div class="row">
        <div class="col-md-6">

            <div id="tunj_pot">
                <?php if ($pot_tetap->num_rows() > 0) {
                    foreach ($pot_tetap->result() as $row) {
                ?>
                        <div class="d-flex justify-content-between">
                            <label><?= $row->nm_potongan ?></label>
                            <div class="form-inline justify-content-between font-weight-bold w-25" id="pot_tetap_<?= $gapok . '_' . md5($row->id_item) ?>">
                                <span>Rp</span>
                                <span class="form-control-static"><?= $row->nominal_potongan != '' ? dec_to_num($row->nominal_potongan, 2) : '0,00' ?></span>
                                <?php if ($row->flag_persentase_gapok == '0') : ?>
                                    <a href="javascript:void(0)" class="text-primary position-absolute" style="right: -10px" onclick="informasi_gaji_form_update(this, 'update')"><i class="fa fa-edit"></i></a>
                                <?php else : ?>
                                    <?php if ($row->nominal_potongan > 0) : ?>
                                        <a href="javascript:void(0)" class="text-danger position-absolute" style="right: -10px" data-persen="<?= $row->gapok_persen ?>" onclick="informasi_gaji_form_update(this, 'delete')"><i class="fa fa-trash"></i></a>
                                    <?php else : ?>
                                        <a href="javascript:void(0)" class="text-primary position-absolute" style="right: -10px" data-persen="<?= $row->gapok_persen ?>" onclick="informasi_gaji_form_update(this, 'add')"><i class="fa fa-plus"></i></a>
                                    <?php endif; ?>
                                <?php endif ?>
                            </div>
                        </div>
                        <?php if ($row->flag_persentase_gapok == '1' && $row->nominal_potongan > 0) : ?>
                            <p class="text-right" style="font-size: 11px">(<?= $row->gapok_persen ?>% dari gapok)</p>
                        <?php endif; ?>
                <?php }
                } ?>
            </div>
            <div class="d-flex justify-content-between">
                <label for="pot_bpjs_kes">Potongan BPJS Kesehatan</label>
                <div class="form-inline justify-content-between font-weight-bold w-25" id="pot_bpjs_kes">
                    <span>Rp</span>
                    <span><?= $pot_bpjs_kes != '' ? dec_to_num($pot_bpjs_kes, 2) : '0,00' ?></span>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <label for="pot_bpjs_jht">Potongan JHT</label>
                <div class="form-inline justify-content-between font-weight-bold w-25" id="pot_bpjs_jht">
                    <span>Rp</span>
                    <span><?= $pot_bpjs_tk->pot_jht_kry_rp != '' ? dec_to_num($pot_bpjs_tk->pot_jht_kry_rp, 2) : '0,00' ?></span>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <label for="pot_bpjs_jp">Potongan JP</label>
                <div class="form-inline justify-content-between font-weight-bold w-25" id="pot_bpjs_jp">
                    <span>Rp</span>
                    <span><?= $pot_bpjs_tk->pot_jp_kry_rp != '' ? dec_to_num($pot_bpjs_tk->pot_jp_kry_rp, 2) : '0,00' ?></span>
                </div>
            </div>
            <hr>
            <div class="d-flex justify-content-between">
                <label>Total Potongan</label>
                <span class="d-flex justify-content-between font-weight-bold w-25">
                    <span>Rp</span>
                    <span><?= dec_to_num($ttl_pot, 2) ?></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row my-1">
        <div class="col-md-6">
            <div class="form-group">
                <div class="d-flex justify-content-between">
                    <h6 class="font-weight-bold">Gaji Yang Diterima</h6>
                    <span class="d-flex justify-content-between font-weight-bold w-25">
                        <span>Rp</span>
                        <span><?= dec_to_num(($gapok + $ttl_tunj_tetap) - $ttl_pot, 2) ?></span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>
