<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Bpjs_master_m extends CI_Model
{

    var $table = 'data_karyawan';

    public function __construct()
    {
        parent::__construct();

        $this->id_company = $this->session->userdata('id_company');
        $this->id_karyawan = $this->session->userdata('id_karyawan');
        $this->nama_user   = $this->session->userdata('nama_user');
    }

    function get_datatables($params)
    {
        $this->_get_datatables_query($params);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($params)
    {
        $this->_get_datatables_query($params);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($params)
    {
        $this->db->select("id_karyawan")->from($this->table);
        $this->db->join(
            'payroll_bpjs_tk_m',
            'payroll_bpjs_tk_m.id_karyawan = data_karyawan.id_karyawan and
        	payroll_bpjs_tk_m.id_company = data_karyawan.id_company'
        );
        $this->db->join(
            'payroll_bpjs_kes_m',
            'payroll_bpjs_kes_m.id_karyawan = data_karyawan.id_karyawan and
        	payroll_bpjs_kes_m.id_company = data_karyawan.id_company'
        );
        $this->db->where("data_karyawan.id_company", $this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($params)
    {
        $param = explode('.', $params);
        $id_karyawan   = $param[0];
        $id_cabang     = $param[1];
        $id_departemen = $param[2];

        if ($id_karyawan != 'all') $this->db->where('data_karyawan.id_karyawan', $id_karyawan);
        if ($id_cabang != 'all') $this->db->where('master_cabang.id_cabang', $id_cabang);
        if ($id_departemen != 'all') $this->db->where('master_departemen.id_departemen', $id_departemen);

        $this->db->select("
        	data_karyawan.id_karyawan,
        	data_karyawan.nama_lengkap,
        	data_karyawan.nik,
        	data_karyawan.no_bpjs_kes,
        	data_karyawan.no_bpjs_tk,
        	data_karyawan.jml_anak,
        	payroll_bpjs_kes_m.tunj_perus_rp as bpjs_kes_tunj_perus_rp,
        	payroll_bpjs_kes_m.pot_kry_rp as bpjs_kes_pot_kry_rp,
        	payroll_bpjs_tk_m.tunj_jht_perus_rp as bpjs_tk_tunj_jht_perus_rp,
            payroll_bpjs_tk_m.ttl_gaji_terdaftar,
        	payroll_bpjs_tk_m.pot_jht_kry_rp as bpjs_tk_pot_jht_kry_rp,
        	payroll_bpjs_tk_m.tunj_jkk_rp as bpjs_tk_tunj_jkk_rp,
        	payroll_bpjs_tk_m.tunj_jkm_rp as bpjs_tk_tunj_jkm_rp,
        	payroll_bpjs_tk_m.tunj_jp_perus_rp as bpjs_tk_tunj_jp_perus_rp,
        	payroll_bpjs_tk_m.pot_jp_kry_rp as bpjs_tk_pot_jp_kry_rp,
        	payroll_bpjs_tk_m.ttl_pot_karyawan,
        	payroll_bpjs_tk_m.ttl_tunj_dibiayai_perus
        ");
        $this->db->from($this->table);
        $this->db->join(
            'payroll_bpjs_tk_m',
            'payroll_bpjs_tk_m.id_karyawan = data_karyawan.id_karyawan and
        	payroll_bpjs_tk_m.id_company = data_karyawan.id_company'
        );
        $this->db->join(
            'payroll_bpjs_kes_m',
            'payroll_bpjs_kes_m.id_karyawan = data_karyawan.id_karyawan and
        	payroll_bpjs_kes_m.id_company = data_karyawan.id_company'
        );
        $this->db->join(
            'master_cabang',
            'master_cabang.id_cabang = data_karyawan.id_cabang and
        	master_cabang.id_company = data_karyawan.id_company'
        );
        $this->db->join(
            'master_departemen',
            'master_departemen.id_departemen = data_karyawan.id_departemen and
        	master_departemen.id_company = data_karyawan.id_company',
            'left'
        );
        $this->db->where("data_karyawan.id_company", $this->id_company);

        $column_search = array('nik', 'nama_lengkap');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array(
            '',
            'data_karyawan.nama_lengkap',
            'payroll_bpjs_tk_m.ttl_gaji_terdaftar',
            'data_karyawan.no_bpjs_kes',
            'data_karyawan.jml_anak',
            'payroll_bpjs_kes_m.tunj_perus_rp',
            'payroll_bpjs_kes_m.pot_kry_rp',
            'data_karyawan.no_bpjs_tk',
            'payroll_bpjs_tk_m.tunj_jht_perus_rp',
            'payroll_bpjs_tk_m.pot_jht_kry_rp',
            'payroll_bpjs_tk_m.tunj_jkk_rp',
            'payroll_bpjs_tk_m.tunj_jkm_rp',
            'payroll_bpjs_tk_m.tunj_jp_perus_rp',
            'payroll_bpjs_tk_m.pot_jp_kry_rp',
            'payroll_bpjs_tk_m.ttl_pot_karyawan',
            'payroll_bpjs_tk_m.ttl_tunj_dibiayai_perus'
        );

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("payroll_bpjs_kes_m.tgl_input" => "DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function get_ttl_tunj_tetap($id_karyawan)
    {
        $this->db->select_sum('nominal_tunjangan');
        $this->db->from('payroll_tunj_tetap_m');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('flag_bpjs', '1');
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->nominal_tunjangan;
    }

    public function save($id_karyawan)
    {
        $this->db->trans_start();
        if ($this->input->post('bpjs_kes_flag') == '1') {
            $this->update_data_karyawan($id_karyawan);
        }
        $this->save_bpjs_kes($id_karyawan);
        $this->save_bpjs_tk($id_karyawan);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    private function update_data_karyawan($id_karyawan, $md5 = FALSE)
    {
        $jml_anak = $this->input->post('jml_anak');
        if ($jml_anak != FALSE) {
            $this->db->set('jml_anak', $jml_anak);
            if ($md5 == TRUE) {
                $this->db->where('md5(id_karyawan)', $id_karyawan);
            } else {
                $this->db->where('id_karyawan', $id_karyawan);
            }
            $this->db->where('id_company', $this->id_company);
            $this->db->update('data_karyawan');
        }
    }

    private function save_bpjs_kes($id_karyawan, $md5 = FALSE)
    {
        $tunj_perus_rp = $this->input->post('bpjs_kes_tunj_perus_rp');
        $pot_kry_rp = $this->input->post('bpjs_kes_pot_kry_rp');

        $data = array(
            'flag' => $this->input->post('bpjs_kes_flag'),
            'jml_anak' => ($this->input->post('bpjs_kes_flag') == '1') ? $this->input->post('jml_anak') : 0,
            'ttl_gaji_terdaftar' => num_to_dec($this->input->post('gaji_daftar')),
            'tunj_perus_persen' => $this->input->post('bpjs_kes_tunj_perus'),
            'pot_kry_persen' => $this->input->post('bpjs_kes_pot_kry')
        );

        if ($tunj_perus_rp != false) {
            $data['tunj_perus_rp'] = num_to_dec($tunj_perus_rp);
        }
        if ($pot_kry_rp != false) {
            $data['pot_kry_rp'] = num_to_dec($pot_kry_rp);
        }

        if ($md5 == FALSE) {
            // jika insert
            $data['id_karyawan'] = $id_karyawan;
            $data['id_company'] = $this->id_company;
            $data['user_input'] = $this->id_karyawan . '-' . $this->nama_user;
            $data['tgl_input'] = date('Y-m-d H:i:s');
            $this->db->insert('payroll_bpjs_kes_m', $data);
        } else {
            // jika update
            $data['user_update'] = $this->id_karyawan . '-' . $this->nama_user;
            $data['tgl_update'] = date('Y-m-d H:i:s');
            $this->db->where('md5(id_karyawan)', $id_karyawan);
            $this->db->where('id_company', $this->id_company);
            $this->db->update('payroll_bpjs_kes_m', $data);
        }
    }

    private function save_bpjs_tk($id_karyawan, $md5 = FALSE)
    {
        $ttl_gaji_terdaftar = num_to_dec($this->input->post('gaji_daftar'));
        $tunj_jht_perus_rp = $this->input->post('bpjs_tk_tunj_jht_perus_rp');
        $pot_jht_kry_rp = $this->input->post('bpjs_tk_pot_jht_kry_rp');
        $tunj_jkk_rp = $this->input->post('bpjs_tk_tunj_jkk_rp');
        $tunj_jp_perus_rp = $this->input->post('bpjs_tk_tunj_jp_perus_rp');
        $pot_jp_kry_rp = $this->input->post('bpjs_tk_pot_jp_kry_rp');
        $tunj_jkm_rp = $this->input->post('bpjs_tk_tunj_jkm_rp');
        $ttl_pot_karyawan = num_to_dec($this->input->post('ttl_pot_kry'));
        $ttl_tunj_dibiayai_perus = num_to_dec($this->input->post('ttl_tunj_dibiayai_perus'));

        $data = array(
            'ttl_gaji_terdaftar' => $ttl_gaji_terdaftar,
            'tunj_jht_perus_persen' => $this->input->post('bpjs_tk_tunj_jht_perus'),
            'pot_jht_kry_persen' => $this->input->post('bpjs_tk_pot_jht_kry'),
            'flag_jht' => $this->input->post('bpjs_tk_flag_jht'),
            'tunj_jkk_persen' => $this->input->post('bpjs_tk_tunj_jkk'),
            'flag_jkk' => $this->input->post('bpjs_tk_flag_jkk'),
            'tunj_jp_perus_persen' => $this->input->post('bpjs_tk_tunj_jp_perus'),
            'pot_jp_kry_persen' => $this->input->post('bpjs_tk_pot_jp_kry'),
            'flag_jp' => $this->input->post('bpjs_tk_flag_jp'),
            'tunj_jkm_persen' => $this->input->post('bpjs_tk_tunj_jkm'),
            'flag_jkm' => $this->input->post('bpjs_tk_flag_jkm'),
            'ttl_pot_karyawan' => $ttl_pot_karyawan,
            'ttl_tunj_dibiayai_perus' => $ttl_tunj_dibiayai_perus
        );
        if ($tunj_jht_perus_rp != false) {
            $data['tunj_jht_perus_rp'] = num_to_dec($tunj_jht_perus_rp);
        }
        if ($pot_jht_kry_rp != false) {
            $data['pot_jht_kry_rp'] = num_to_dec($pot_jht_kry_rp);
        }
        if ($tunj_jkk_rp != false) {
            $data['tunj_jkk_rp'] = num_to_dec($tunj_jkk_rp);
        }
        if ($tunj_jp_perus_rp != false) {
            $data['tunj_jp_perus_rp'] = num_to_dec($tunj_jp_perus_rp);
        }
        if ($pot_jp_kry_rp != false) {
            $data['pot_jp_kry_rp'] = num_to_dec($pot_jp_kry_rp);
        }
        if ($tunj_jkm_rp != false) {
            $data['tunj_jkm_rp'] = num_to_dec($tunj_jkm_rp);
        }
        if ($md5 == FALSE) {
            // jika insert
            $data['id_karyawan'] = $id_karyawan;
            $data['id_company'] = $this->id_company;
            $data['user_input'] = $this->id_karyawan . '-' . $this->nama_user;
            $data['tgl_input'] = date('Y-m-d H:i:s');
            $this->db->insert('payroll_bpjs_tk_m', $data);
        } else {
            // jika update
            $data['user_update'] = $this->id_karyawan . '-' . $this->nama_user;
            $data['tgl_update'] = date('Y-m-d H:i:s');
            $this->db->where('md5(id_karyawan)', $id_karyawan);
            $this->db->where('id_company', $this->id_company);
            $this->db->update('payroll_bpjs_tk_m', $data);
        }
    }

    public function update($id_karyawan)
    { //md5
        $this->db->trans_start();
        $this->update_data_karyawan($id_karyawan, TRUE);
        $this->save_bpjs_kes($id_karyawan, TRUE);
        $this->save_bpjs_tk($id_karyawan, TRUE);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function delete($id)
    {
        $this->db->trans_start();
        $this->delete_bpjs_kes($id);
        $this->delete_bpjs_tk($id);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    private function delete_bpjs_kes($id_karyawan)
    {
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_bpjs_kes_m');
    }

    private function delete_bpjs_tk($id_karyawan)
    {
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_bpjs_tk_m');
    }
}
