<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengajuan_lembur extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Pengajuan_lembur_m');
        $this->load->model('Db_model', 'db_model');
    }

    //CRUD
    public function index()
    {
        $data['judul']            = $this->lang->line('menu_pengajuan_lembur');
        $data['aktif']            = 'lembur';
        $data['level_user']       = $this->level_user;
        $data['multi_cabang']     = $this->multi_cabang;
        $data['multi_departemen'] = $this->multi_departemen;
        $data['periode_awal']     = date('d-m-Y',  strtotime(date('Y-m-') . '01'));
        $data['periode_akhir']    = date('d-m-Y',  strtotime(date('Y-m-d')));
        $data['menu']             = $this->load->view('main_menu', $data, true);
        $data['content']          = $this->load->view('pengajuan_lembur/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function data_lembur($id_lembur)
    {
        $data['judul'] = $this->lang->line('menu_pengajuan_lembur');
        $data['aktif'] = 'lembur';

        $slq = 'id_lemmulai, id_karyawan, tgl_absen, jam_absen, lokasi_absen, timezone, gmt, latitude, longitude,
                keterangan, foto, id_company, approve, status, approval_spv, approval_kedep, approval_kacab, approval_hrd,
                approval_direksi, user_spv, user_kedep, user_kacab, user_hrd, user_direksi, tgl_apv_spv, tgl_apv_kedep, tgl_apv_kacab,
                tgl_apv_hrd, tgl_apv_direksi, tgl_input';

        $query = $this->db->select($slq)->from("lembur_mulai")->where("md5(id_lemmulai)", $id_lembur)->get()->row();

        $cabang = $this->db->select("id_cabang")->from("data_karyawan")->where("id_karyawan", $query->id_karyawan)->get()->row()->id_cabang;

        $departemen = $this->db->select("id_departemen")->from("data_karyawan")->where("id_karyawan", $query->id_karyawan)->get()->row()->id_departemen;

        $data['tgl_mulai']     = $this->fungsi->format_date_strip($query->tgl_absen);
        $data['tgl_selesai']   = $this->fungsi->format_date_strip($query->tgl_absen);
        $data['id_cabang']     = $cabang;
        $data['id_departemen'] = $departemen;
        $data['id_karyawan']   = $query->id_karyawan;

        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_lembur/home_data', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data($tgl_mulai = 0, $tgl_selesai = 0, $status = 0, $id_karyawan = 0, $id_cabang = 0, $id_departemen = 0)
    {
        $data['judul']         = $this->lang->line('menu_pengajuan_lembur');
        $data['aktif']         = 'lembur';
        $data['status']        = $status;
        $data['id_karyawan']   = $id_karyawan;
        $data['id_cabang']     = $id_cabang;
        $data['id_departemen'] = $id_departemen;
        $data['tgl_mulai']     = date('Y-m-d', strtotime($tgl_mulai));
        $data['tgl_selesai']   = date('Y-m-d', strtotime($tgl_selesai));
        $this->load->view('pengajuan_lembur/list_data', $data, false);
    }

    public function list_data($tgl_mulai = 0, $tgl_selesai = 0, $status = 0, $id_karyawan = 0, $id_cabang = 0, $id_departemen = 0)
    {

        switch ($this->level_user) {
            case '1':
                $str = 'hrd';
                break;
            case '2':
                $str = 'kedep';
                break;
            case '4':
                $str = 'direksi';
                break;
            case '5':
                $str = 'kacab';
                break;
            case '7':
                $str = 'spv';
                break;

            default:
                $str = 'hrd';
                break;
        }

        $appv_sts = [];
        if ($status == '1') {
            $appv_sts = ['1'];
        } elseif ($status == '2') {
            $appv_sts = ['3'];
        } elseif ($status == '3') {
            $appv_sts = ['4'];
        } elseif ($status == '0') {
            $appv_sts = ['1', '2', '3', '4'];
        }
        $appv_lvl = 'lembur_mulai.approval_' . $str;
        $stts['appv_lvl'] = $appv_lvl;
        $stts['appv_sts'] = $appv_sts;
        $stts['appv_flt'] = $status;

        $recordsTotal    = $this->Pengajuan_lembur_m->count_all($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        $recordsFiltered = $this->Pengajuan_lembur_m->count_filtered($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        $list            = $this->Pengajuan_lembur_m->get_datatables($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        $data            = array();
        $no              = $_GET['start'];

        foreach ($list as $field) {
            $no++;

            $lembur_mulai   = strtotime($field->jam_absen);
            $lembur_selesai = strtotime($field->jam_lembur_selesai);
            $selisih_detik  = $lembur_selesai - $lembur_mulai;
            $lama_lembur    = floor($selisih_detik / 60);

            if ($this->level_user == '1') {
                if (!in_array($field->status,['3','4'])) {
                    $btn_hapus_lselesai = '<a href="javascript:;" class="text-danger" title="DELETE">
                                            <i id="' . md5($field->id_lemmulai) . '" class="btn_delete_lselesai fa fa-trash"></i>
                                        </a>';
                }else{
                    $btn_hapus_lselesai = '';
                }
            }

            $row = array();

            $row[] = $no;
            $row[] = $field->nama_lengkap . '<br>' . $field->nik;
            $row[] = date('d-m-Y', strtotime($field->tgl_absen));
            $row[] = date_format(date_create($field->jam_absen), "d-m-Y H:i:s") .
                '<br /><a data-toggle="modal" data-target="#modalViewDetail" href="javascript:;" data-uri="' . site_url("pengajuan/lembur/detail-lembur-mulai") . '/' . md5($field->id_lemmulai) . '"
				style="border-radius: 5px" class="btn btn-success btn-sm">Detail</a>';
            $row[] = date_format(date_create($field->jam_lembur_selesai), "d-m-Y H:i:s") .
                '<br /><a data-toggle="modal" data-target="#modalViewDetail" href="javascript:;" data-uri="' . site_url("pengajuan/lembur/detail-lembur-selesai") . '/' . md5($field->id_lemselesai) . '"
            style="border-radius: 5px" class="btn btn-danger btn-sm">Detail</a>'."<br>".$btn_hapus_lselesai;
            $row[] = $lama_lembur;

            $row[] = $field->keterangan;
            $row[] = $field->ls_keterangan;
            $level_approval = $field->level_approval;

            $get_lev = explode(',', $level_approval);

            if (in_array($this->level_user, ['1', '7'])) {
                if ($field->approval_spv == 1) {
                    $spv = '<a href="#" id="' . md5($field->id_lemmulai) . '" class="btn_verif_spv btn-sm btn btn-primary">
                            <i class="fa fa-check"> </i> ' . $this->lang->line('button_verifikasi') . '</a>&nbsp;';
                } else {
                    $spv = $this->fungsi->get_approval($field->approval_spv);
                }
            } else {
                $spv = $this->fungsi->get_approval($field->approval_spv);
            }

            $row[] = $spv;

            if (in_array($this->level_user, ['1', '2'])) {
                $key = array_search(2, $get_lev);
                $approv = $get_lev[$key - 1];

                if ($approv == '7') {
                    $approv_col = $field->approval_spv;
                }

                if ($approv_col == '3') {
                    $kedep = $this->fungsi->get_approval('');
                } else {
                    if ($field->approval_kedep == 1) {
                        $kedep = '<a href="#" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kedep btn-sm btn btn-primary">
                                    <i class="fa fa-check"> </i> ' . $this->lang->line('button_verifikasi') . '</a>&nbsp;';
                    } else {
                        $kedep = $this->fungsi->get_approval($field->approval_kedep);
                    }
                }
            } else {
                $kedep = $this->fungsi->get_approval($field->approval_kedep);
            }

            $row[] = $kedep;

            if (in_array($this->level_user, ['1', '5'])) {
                $key = array_search(5, $get_lev);
                $approv = $get_lev[$key - 1];
                $approv_2 = $get_lev[$key - 2];

                if ($approv == '7') {
                    $approv_col = $field->approval_spv;
                } else if ($approv == '2') {
                    $approv_col = $field->approval_kedep;
                }

                if ($approv_2 == '7') {
                    $approv_col_2 = $field->approval_spv;
                }

                if ($approv_col == '3' || $approv_col_2 == '3') {
                    $kacab = $this->fungsi->get_approval('');
                } else {
                    if ($field->approval_kacab == 1) {
                        $kacab = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kacab btn-sm btn btn-primary" title="' . $this->lang->line('button_verifikasi') . '">
                                <i class="fa fa-check"> </i> ' . $this->lang->line('button_verifikasi') . '</a>&nbsp;';
                    } else {
                        $kacab = $this->fungsi->get_approval($field->approval_kacab);
                    }
                }
            } else {
                $kacab = $this->fungsi->get_approval($field->approval_kacab);
            }

            $row[] = $kacab;

            if (in_array($this->level_user, ['1', '4'])) {
                $key = array_search(4, $get_lev);
                $approv = $get_lev[$key - 1];
                $approv_2 = $get_lev[$key - 2];
                $approv_3 = $get_lev[$key - 3];

                if ($approv == '7') {
                    $approv_col = $field->approval_spv;
                } elseif ($approv == '2') {
                    $approv_col = $field->approval_kedep;
                } elseif ($approv == '5') {
                    $approv_col = $field->approval_kacab;
                }

                if ($approv_2 == '2') {
                    $approv_col_2 = $field->approval_kedep;
                }

                if ($approv_3 == '7') {
                    $approv_col_3 = $field->approval_spv;
                }

                if ($approv_col == '3' || $approv_col_3 == '3' || $approv_col_2 == '3') {
                    $direksi = $this->fungsi->get_approval('');
                } else {
                    if ($field->approval_direksi == 1) {
                        $direksi = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_direksi btn-sm btn btn-primary" title="' . $this->lang->line('button_verifikasi') . '">
                                <i class="fa fa-check"> </i> ' . $this->lang->line('button_verifikasi') . '</a>&nbsp;';
                    } else {
                        $direksi = $this->fungsi->get_approval($field->approval_direksi);
                    }
                }
            } else {
                $direksi = $this->fungsi->get_approval($field->approval_direksi);
            }

            $row[] = $direksi;

            if ($this->level_user == 1) {
                $key = array_search(1, $get_lev);
                $approv = $get_lev[$key - 1];
                $approv_2 = $get_lev[$key - 2];
                $approv_3 = $get_lev[$key - 3];
                $approv_4 = $get_lev[$key - 4];

                if ($approv == '7') {
                    $approv_col = $field->approval_spv;
                } elseif ($approv == '2') {
                    $approv_col = $field->approval_kedep;
                } elseif ($approv == '5') {
                    $approv_col = $field->approval_kacab;
                } elseif ($approv == '4') {
                    $approv_col = $field->approval_direksi;
                }

                if ($approv_2 == '5') {
                    $approv_col_2 = $field->approval_kacab;
                }

                if ($approv_3 == '2') {
                    $approv_col_3 = $field->approval_kedep;
                }

                if ($approv_4 == '7') {
                    $approv_col_4 = $field->approval_spv;
                }

                if ($approv_col == '3' || $approv_col_4 == '3' || $approv_col_3 == '3' || $approv_col_2 == '3') {
                    $hrd = $this->fungsi->get_approval('');
                } else {
                    if ($field->approval_hrd == 1) {
                        $hrd = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_hrd btn-sm btn btn-primary" title="' . $this->lang->line('button_verifikasi') . '">
                                <i class="fa fa-check"> </i> ' . $this->lang->line('button_verifikasi') . '</a>&nbsp;';
                    } else {
                        $hrd = $this->fungsi->get_approval($field->approval_hrd);
                    }
                }
            } else {
                $hrd = $this->fungsi->get_approval($field->approval_hrd);
            }

            $row[] = $hrd;

            if (in_array($this->session->userdata('level_user'), array("1"))) {

                $jam_lembur_mulai = date_format(date_create($field->jam_absen), "H:i:s");

                $row[] = '<a href="javascript:;" class="text-danger" title="DELETE">
                                <i id="' . md5($field->id_lemmulai) . '/' . $field->status . '/' . $field->id_karyawan . '/' . $field->tgl_absen . '/' . $jam_lembur_mulai . '" class="btn_delete fa fa-trash"></i>
                            </a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $recordsTotal,
            "recordsFiltered" => $recordsFiltered,
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }


    public function detail_lembur($id)
    {
        $data['judul']     = $this->lang->line('menu_pengajuan_lembur');
        $data['sub_judul'] = 'Detail Lembur';
        $data['aktif']     = 'lembur';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $coords = $this->db->select("
                                    k.nama_lengkap,
                                    k.nik,
                                    m.id_lemmulai,
                                    m.tgl_absen as tgl_mulai,
                                    m.jam_absen as jam_mulai,
                                    m.latitude as latitude_mulai,
                                    m.longitude as longitude_mulai,
                                    m.approve as approve_mulai,
                                    m.lokasi_absen as lokasi_mulai,
                                    m.keterangan as keterangan_mulai,
                                    m.foto as foto_mulai,
                                    s.tgl_absen as tgl_selesai,
                                    s.jam_absen as jam_selesai,
                                    s.latitude as latitude_selesai,
                                    s.longitude as longitude_selesai,
                                    s.lokasi_absen as lokasi_selesai,
                                    s.keterangan as keterangan_selesai,
                                    s.foto as foto_selesai,
                                    j.nama as nama_jabatan,
                                    d.nama as nama_departemen,
                                    c.nama as nama_cabang,
                                    cp.nama as nama_company,
                                    m.approval_spv,
                                    m.approval_kedep,
                                    m.approval_kacab,
                                    m.approval_hrd,
                                    m.approval_direksi
                                    ")
            ->join("lembur_selesai s", 's.id_lemmulai=m.id_lemmulai')
            ->join("data_karyawan k", "k.id_karyawan = m.id_karyawan")
            ->join('master_jabatan j', 'j.id_jabatan=k.id_jabatan')
            ->join('master_departemen d', 'd.id_departemen=k.id_departemen')
            ->join('master_cabang c', 'c.id_cabang=k.id_cabang')
            ->join('master_company cp', 'cp.id_company=k.id_company')
            ->from("lembur_mulai m")
            ->where("md5(m.id_lemmulai)", $id)
            ->get()
            ->row();

        // mulai
        $this->load->library('googlemaps/Googlemaps');
        $config = array();
        $config['center'] = $coords->latitude_mulai . ',' . $coords->longitude_mulai;
        $config['zoom'] = 18;
        $config['map_height'] = "400px";
        $this->googlemaps->initialize($config);

        $marker = array();
        $marker['position'] = $coords->latitude_mulai . "," . $coords->longitude_mulai;
        $marker['title'] = $coords->nama_lengkap;
        $this->googlemaps->add_marker($marker);

        $data['map_mulai'] = $this->googlemaps->create_map();

        // selesai
        $this->load->library('googlemaps2/Googlemaps2');
        $config2 = array();
        $config2['center'] = $coords->latitude_selesai . ',' . $coords->longitude_selesai;
        $config2['zoom'] = 18;
        $config2['map_height'] = "400px";
        $this->googlemaps2->initialize($config2);

        $marker2 = array();
        $marker2['position'] = $coords->latitude_selesai . "," . $coords->longitude_selesai;
        $marker2['title'] = $coords->nama_lengkap;
        $this->googlemaps2->add_marker($marker2);

        $data['map_selesai'] = $this->googlemaps2->create_map();

        $data['data'] = $coords;

        switch ($this->level_user) {
            case '1':
                $str = 'hrd';
                break;
            case '2':
                $str = 'kedep';
                break;
            case '4':
                $str = 'direksi';
                break;
            case '5':
                $str = 'kacab';
                break;
            case '7':
                $str = 'spv';
                break;

            default:
                $str = 'hdr';
                break;
        }

        $data['lv_appv'] = $str;

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_lembur/detail_lembur', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function detail_lembur_mulai($id)
    {
        $data['judul'] = $this->lang->line('detail_lembur_mulai');
        $data['aktif'] = 'lembur';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $coords = $this->db->select("lembur_mulai.tgl_absen, lembur_mulai.jam_absen, lembur_mulai.latitude, lembur_mulai.longitude, lembur_mulai.approve, lembur_mulai.lokasi_absen, lembur_mulai.keterangan, lembur_mulai.foto, data_karyawan.nama_lengkap")->from("lembur_mulai")->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")->where("md5(id_lemmulai)", $id)->get()->row();
        $data['nama'] = $coords->nama_lengkap;
        $data['lokasi'] = $coords->lokasi_absen;
        $data['jam_absen'] = $coords->jam_absen;
        $data['tanggal'] = date('d-m-Y', strtotime($coords->tgl_absen));
        $data['keterangan'] = $coords->keterangan;
        $data['foto'] = $coords->foto;

        if (empty($coords->longitude)) {
            $foto = $this->config->item('base_image') . 'image?_t=lokasi&_d=';
            $html = '<img src="' . $foto . '" class="portrait" style="max-height:400px">';
            $maps = ["js" => "", "html" => $html];
            $lokasi = $maps;
            $data['map'] = $lokasi;
        } else {
            $data['lat']   = $coords->latitude;
            $data['long']  = $coords->longitude;
            $data['title'] = "kkk";
        }

        $this->load->view('pengajuan_lembur/peta_lembur_mulai', $data);
    }

    public function detail_lembur_selesai($id)
    {
        $data['judul'] = $this->lang->line('detail_lembur_selesai');
        $data['aktif'] = 'lembur';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $coords             = $this->db->select("lembur_selesai.tgl_absen, lembur_selesai.jam_absen, lembur_selesai.latitude, lembur_selesai.longitude, lembur_selesai.lokasi_absen, lembur_selesai.keterangan, lembur_selesai.foto, data_karyawan.nama_lengkap")->from("lembur_selesai")->join("data_karyawan", "data_karyawan.id_karyawan = lembur_selesai.id_karyawan", "left")->where("md5(id_lemselesai)", $id)->get()->row();
        $data['nama']       = $coords->nama_lengkap;
        $data['lokasi']     = $coords->lokasi_absen;
        $data['jam_absen']  = $coords->jam_absen;
        $data['tanggal']    = date('d-m-Y', strtotime($coords->tgl_absen));
        $data['keterangan'] = $coords->keterangan;
        $data['foto']       = $coords->foto;

        if (empty($coords->longitude)) {
            $foto = $this->config->item('base_image') . 'image?_t=lokasi&_d=';
            $html = '<img src="' . $foto . '" class="portrait" style="max-height:400px">';
            $maps = ["js" => "", "html" => $html];
            $lokasi = $maps;
            $data['map'] = $lokasi;
        } else {
            $data['lat']   = $coords->latitude;
            $data['long']  = $coords->longitude;
            $data['title'] = "kkk";
        }

        $data['content'] = $this->load->view('pengajuan_lembur/peta_lembur_selesai', $data);
    }

    public function modal($id)
    {
        $res = $this->db->select('m.id_lemmulai, m.id_karyawan, m.tgl_absen, m.jam_absen as absen_mulai, s.jam_absen as absen_selesai, m.keterangan as keterangan_mulai, s.keterangan as keterangan_selesai')
            ->join('lembur_selesai s', 's.id_lemmulai=m.id_lemmulai')
            ->from('lembur_mulai m')
            ->where('md5(m.id_lemmulai)', $id)
            ->get()->row();

        $data['id']          = $id;
        $data['jam_mulai']   = $res->absen_mulai;
        $data['jam_selesai'] = $res->absen_selesai;
        $data['tanggal']     = $res->tgl_absen;
        $data['ket_mulai']   = $res->keterangan_mulai;
        $data['ket_selesai'] = $res->keterangan_selesai;
        $data['id_karyawan'] = $res->id_karyawan;
        $this->load->view('pengajuan_lembur/modal', $data);
    }

    public function delete($id_lemmulai, $status, $id_karyawan, $tgl_absen, $jam_lembur_mulai)
    {
        // $id = $this->input->post("id_lembur");
        $this->Pengajuan_lembur_m->delete($id_lemmulai, $status, $id_karyawan, $tgl_absen, $jam_lembur_mulai);
    }

    public function delete_lembur_selesai($id)
    {
        $this->Pengajuan_lembur_m->delete_lembur_selesai($id);
    }

    public function approve_to_service($act, $id_lemmulai)
    {
        $res = $this->db->select('m.id_lemmulai, m.id_karyawan, m.jam_absen as absen_mulai, s.jam_absen as absen_selesai')
            ->join('lembur_selesai s', 's.id_lemmulai=m.id_lemmulai')
            ->from('lembur_mulai m')
            ->where('md5(m.id_lemmulai)', $id_lemmulai)
            ->get()->row();

        if ($res != null) {
            $id_pengaprove = $this->session->userdata('id_karyawan');
            $id_company    = $this->session->userdata('id_company');
            $base          = $this->config->item('url_api');

            if($this->adm_absensi == true){
                $id_pengaprove = $this->fungsi->get_id_superadmin();
            }

            $post_data = "id_lemmulai=" . $res->id_lemmulai;

            if ($act == '4') {
                $ok = true;

                $t_mulai = date('Y-m-d H:i:s', strtotime($this->input->post('tgl_mulai') . ' ' . $this->input->post('jam_mulai')));
                $t_selesai = date('Y-m-d H:i:s', strtotime($this->input->post('tgl_selesai') . ' ' . $this->input->post('jam_selesai')));

                if ((strtotime($t_selesai) < strtotime($t_mulai)) || strtotime($t_mulai) > strtotime($t_selesai)) {
                    $ok = false;
                    $ms = $this->lang->line('error_lembur_selesai_kurang');
                }

                if ((date('Y-m-d H:i', strtotime($res->absen_mulai)) == date('Y-m-d H:i', strtotime($t_mulai))) && (date('Y-m-d H:i', strtotime($res->absen_selesai)) == date('Y-m-d H:i', strtotime($t_selesai)))) {
                    $u = false;
                } else {
                    $u = true;
                }


                if ($ok) {
                    if ($u == true) {
                        $tgl_absen_mulai   = date('Y-m-d', strtotime($this->input->post('tgl_mulai')));
                        $jam_absen_mulai   = $t_mulai;
                        $tgl_absen_selesai = date('Y-m-d', strtotime($this->input->post('tgl_selesai')));
                        $jam_absen_selesai = $t_selesai;

                        $u_mulai = $this->db->where('id_lemmulai', $res->id_lemmulai)
                            ->where('id_karyawan', $res->id_karyawan)
                            ->set('tgl_absen', $tgl_absen_mulai)
                            ->set('jam_absen', $jam_absen_mulai)
                            ->update('lembur_mulai');

                        $u_selesai = $this->db->where('id_lemmulai', $res->id_lemmulai)
                            ->where('id_karyawan', $res->id_karyawan)
                            ->set('tgl_absen', $tgl_absen_selesai)
                            ->set('jam_absen', $jam_absen_selesai)
                            ->update('lembur_selesai');
                    }

                    #setujui
                    $url_act = $base . '/lembur/setujui/' . $res->id_lemmulai;
                } else {
                    $url_act = false;
                    $msg = $ms;
                }
            } elseif ($act == '3') {
                #tolak
                $url_act = $base . '/lembur/tolak/' . $res->id_lemmulai;
            } else {
                $url_act = false;
            }

            if ($url_act !== false) {
                $curl = curl_init();
                $data_karyawan = array(
                    "id-company:" . $this->id_company,
                    "id-karyawan:" . $id_pengaprove,
                    "api-key:absenku123**"
                );

                curl_setopt($curl, CURLOPT_USERAGENT, 'absenku_v3_250801_multi');
                curl_setopt($curl, CURLOPT_URL, $url_act);
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PATCH');
                curl_setopt($curl, CURLOPT_POSTFIELDS, $post_data);
                curl_setopt($curl, CURLOPT_HTTPHEADER, $data_karyawan);

                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($curl);
                curl_close($curl);

                //     echo '<pre>'.var_export($response, true).'</pre>';
                // exit;

                if ($response != '') {
                    $json = json_decode($response);

                    $data['status'] = $json->success;
                    $data['message'] = $json->message;
                } else {
                    $data['status'] = false;
                    $data['message'] = (isset($msg)) ? $msg : $this->lang->line('error_req_tidak_diketahui');
                }
            } else {
                $data['status'] = false;
                $data['message'] = (isset($msg)) ? $msg : $this->lang->line('error_req_tidak_diketahui');
            }
        } else {
            $data['status'] = false;
            $data['message'] = $this->lang->line('error_req_tidak_diketahui');
        }

        return $data;
    }

    public function approve_spv()
    {
        $id_lemmulai = $this->input->post('id');
        $con = $this->input->post('status');
        $res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
            $color  = '#009900';
            $status = true;
            $icon   = 'fa-check-square';
        } else {
            $color  = '#eb3a28';
            $status = false;
            $icon   = 'fa-close';
        }

        $json['alert'] = '<font color="' . $color . '"><i class="fa ' . $icon . '">&nbsp;</i> ' . $res['message'] . '</font>';
        $json['success'] = $status;

        $json = __response($this->MY_response, $json);
        echo json_encode($json);
    }

    public function approve_kedep()
    {
        $id_lemmulai = $this->input->post('id');
        $con = $this->input->post('status');
        $res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
            $color  = '#009900';
            $status = true;
            $icon   = 'fa-check-square';
        } else {
            $color  = '#eb3a28';
            $status = false;
            $icon   = 'fa-close';
        }

        $json['alert']   = '<font color="' . $color . '"><i class="fa ' . $icon . '">&nbsp;</i> ' . $res['message'] . '</font>';
        $json['success'] = $status;

        $json = __response($this->MY_response, $json);
        echo json_encode($json);
    }

    public function approve_kacab()
    {
        $id_lemmulai = $this->input->post('id');
        $con = $this->input->post('status');
        $res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
            $color  = '#009900';
            $status = true;
            $icon   = 'fa-check-square';
        } else {
            $color  = '#eb3a28';
            $status = false;
            $icon   = 'fa-close';
        }

        $json['alert']   = '<font color="' . $color . '"><i class="fa ' . $icon . '">&nbsp;</i> ' . $res['message'] . '</font>';
        $json['success'] = $status;

        $json = __response($this->MY_response, $json);
        echo json_encode($json);
    }

    public function approve_hrd()
    {
        $id_lemmulai = $this->input->post('id');
        $con = $this->input->post('status');
        $res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
            $color  = '#009900';
            $status = true;
            $icon   = 'fa-check-square';
        } else {
            $color  = '#eb3a28';
            $status = false;
            $icon   = 'fa-close';
        }

        $json['alert']   = '<font color="' . $color . '"><i class="fa ' . $icon . '">&nbsp;</i> ' . $res['message'] . '</font>';
        $json['success'] = $status;

        $json = __response($this->MY_response, $json);
        echo json_encode($json);
    }

    public function approve_direksi()
    {
        $id_lemmulai = $this->input->post('id');
        $con = $this->input->post('status');
        $res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
            $color  = '#009900';
            $status = true;
            $icon   = 'fa-check-square';
        } else {
            $color  = '#eb3a28';
            $status = false;
            $icon   = 'fa-close';
        }

        $json['alert']   = '<font color="' . $color . '"><i class="fa ' . $icon . '">&nbsp;</i> ' . $res['message'] . '</font>';
        $json['success'] = $status;

        $json = __response($this->MY_response, $json);
        echo json_encode($json);
    }

    public function download($tgl_mulai = 0, $tgl_selesai = 0, $status = 0, $id_karyawan = 0, $id_cabang = 0, $id_departemen = 0)
    {

        switch ($this->level_user) {
            case '1':
                $str = 'hrd';
                break;
            case '2':
                $str = 'kedep';
                break;
            case '4':
                $str = 'direksi';
                break;
            case '5':
                $str = 'kacab';
                break;
            case '7':
                $str = 'spv';
                break;

            default:
                $str = 'hrd';
                break;
        }

        $appv_sts = [];
        if ($status == '1') {
            $appv_sts = ['1'];
        } elseif ($status == '2') {
            $appv_sts = ['3'];
        } elseif ($status == '3') {
            $appv_sts = ['4'];
        } elseif ($status == '0') {
            $appv_sts = ['1', '2', '3', '4'];
        }
        $appv_lvl = 'lembur_mulai.approval_' . $str;
        $stts['appv_lvl'] = $appv_lvl;
        $stts['appv_sts'] = $appv_sts;
        $stts['appv_flt'] = $status;

        $list = $this->Pengajuan_lembur_m->download($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        // echo $this->db->last_query();
        // die();

        $data['data'] = $list;
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = $this->lang->line('data_lembur_download') . " " . $nama;
        } else {

            if ($id_cabang == "0") {
                $filename = $this->lang->line('data_lembur_download') . " " . $this->lang->line('semua_cabang');
            } else {
                if ($id_departemen != "0") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = " " . $this->lang->line('cabang_for_download') . " " . $nama_cab . ", " . $this->lang->line('departemen_for_download') . " " . str_replace("/", "-", $nama_dep);
                    $filename = $this->lang->line('data_lembur_download') . " " . $nama;
                } else {
                    $nama     = $this->_nama_cabang($id_cabang);
                    $filename = $this->lang->line('data_lembur_download') . " " . $this->lang->line('cabang_for_download') . " " . $nama . " " . $this->lang->line('semua_departemen');
                }
            }
        }

        $data["title"]           = $filename;
        $data["tanggal_mulai"]   = date_format(date_create($tgl_mulai), "d-m-Y");
        $data["tanggal_selesai"] = date_format(date_create($tgl_selesai), "d-m-Y");
        $output                  = true;
        $data['is_excel']        = true;
        $sb_view                 = $this->load->view('pengajuan_lembur/download', $data, $output);
        // echo $sb_view;
        // exit();
        $tcol = (isset($addcol[0])) ? $addcol[0] : 0;
        $c_length = 16;

        $param = [
            'download'    => true,
            'cLength'     => $c_length,
            'file_name'   => strtoupper(str_replace("/", "_", $filename)),
            'paper_size'  => 'LEGAL',
            'font-size'   => 9,
            'pagebreak'   => true,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'landscape',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

                '4' => ['weight' => 'bold'],
                '5' => ['weight' => 'bold'],
                '6' => ['weight' => 'bold'],
            ],
            // 'freezecolumn'	   => ['O6'],
            'thead' => ['8', '9'],
            'tbody' => [
                'start'        => '8',
                'height'       => 13,
                'jarak_footer' => 2,
                // 'runFunction'	=> ['highlightlibur' => 'P'],
                'wrap'   => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N'],
                'column' => [
                    'A' => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
                    'B' => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
                    'C' => ['width' => 10, 'align' => 'center'],
                    'D' => ['width' => 10, 'align' => 'center'],
                    'E' => ['width' => 22, 'align' => 'center'],
                    'F' => ['width' => 9, 'align' => 'center'],
                    'G' => ['width' => 9, 'align' => 'center'],
                    'H' => ['width' => 9, 'align' => 'center'],
                    'I' => ['width' => 9, 'align' => 'center'],
                    'J' => ['width' => 9, 'align' => 'center'],
                    'K' => ['width' => 9, 'align' => 'center'],
                    'L' => ['width' => 10, 'align' => 'center'],
                    'M' => ['width' => 18, 'align' => 'center'],
                    'N' => ['width' => 13, 'align' => 'center'],
                    'O' => ['width' => 9, 'align' => 'center'],
                    'P' => ['width' => 9, 'align' => 'center'],
                ],
            ],
        ];
        $this->load->library('PHPExcel/Excel');
        if ($output) {
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    function list_karyawan()
    {
        $key = $this->input->get("q");
        return $this->Pengajuan_lembur_m->list_karyawan($key);
    }

    private function _nama_cabang($id_cabang = "0")
    {
        $this->db->select("nama")
            ->from("master_cabang")
            ->where("id_cabang", $id_cabang)
            ->where("id_company", $this->id_company);

        $query = $this->db->get()->row();
        return $query->nama;
    }

    private function _nama_departemen($id_departemen = "0")
    {
        $this->db->select("nama")
            ->from("master_departemen")
            ->where("id_departemen", $id_departemen)
            ->where("id_company", $this->id_company);

        $query = $this->db->get()->row();
        return $query->nama;
    }

    private function _nama_karyawan($id_karyawan = "0")
    {
        $this->db->select("nama_lengkap")
            ->from("data_karyawan")
            ->where("id_karyawan", $id_karyawan)
            ->where("id_company", $this->id_company);

        $query = $this->db->get()->row();
        return $query->nama_lengkap;
    }
}
