<script>
    $(function () {
        tanggal();
        dropdown_group();
        dropdown_karyawan();
        // pickrange();
        pickrange('#periode_mulai', '#periode_selesai');


        $("#btn_filter").on("click", function () {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function () {
                loading.stop();
            });
        });

        $("#btn_download").click(function () {
            let periode_mulai = $(".filter #periode_mulai").val();
            let periode_selesai = $(".filter #periode_selesai").val();
            let id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
            let nm_group = !$(".filter #id_group").val() ? 'Semua Group' : $(".filter #id_group").select2('data')[0]['nm-group'];
            let id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val()
            let nm_karyawan = !$(".filter #id_karyawan").val() ? 'Semua Sales' : $(".filter #id_karyawan").select2('data')[0]['nm-karyawan'];

            urlExcel = "<?= route('sales_activity.report.realisasi.won.download') ?>" +
                '?periode_mulai=' + periode_mulai +
                '&periode_selesai=' + periode_selesai +
                '&id_group=' + id_group +
                '&nm_group=' + nm_group +
                '&id_karyawan=' + id_karyawan +
                '&nm_karyawan=' + nm_karyawan;
            downloadFile(urlExcel, this);
        });
    });

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function () {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                endDate: d,
                autoclose: true,
            });
        });
    }

    function dropdown_group() {
        let periode_mulai = $(".filter #periode_mulai").val();
        let periode_selesai = $(".filter #periode_selesai").val();
        $(".filter #id_group").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.realisasi.won.dropdown.group") ?>' + '?periode_mulai=' + periode_mulai + '&periode_selesai=' + periode_selesai,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_karyawan() {
        let periode_mulai = $(".filter #periode_mulai").val();
        let periode_selesai = $(".filter #periode_selesai").val();
        let id_group = (!$('.filter #id_group').val()) ? "all" : $('.filter #id_group').val();

        $(".filter #id_karyawan").select2({
            placeholder: "Semua Sales",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.realisasi.won.dropdown.karyawan") ?>' +
                    '?periode_mulai=' + periode_mulai +
                    '&periode_selesai=' + periode_selesai +
                    '&id_group=' + id_group,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_dropdown_periode() {
        $(".filter #id_group").val('').trigger('change');
        $(".filter #id_karyawan").val('').trigger('change');
        dropdown_group()
        dropdown_karyawan();
    }

    function onchange_dropdown_group() {
        $(".filter #id_karyawan").val('').trigger('change');
        dropdown_karyawan();
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Report <?= $this->lang->line('realisasi_won'); ?></h5>
    </div>
</div>
<hr>


<div class="filter row">
    <div class="col-md-4">
        <label><?= $this->lang->line('periode'); ?></label>
        <?php
        $periode_mulai   = date('d-m-Y', strtotime(date('Y-m-') . '01'));
        $periode_selesai = date('d-m-Y', strtotime(date('Y-m-d')));
        ?>
        <div class="input-group input-daterange">
            <input type="text" id="periode_mulai" class="form-control masktanggal" value="<?= $periode_mulai; ?>" onchange="onchange_dropdown_periode()" required>
            <div class="align-self-center">&nbsp;<?= $this->lang->line('s/d'); ?>&nbsp;</div>
            <input type="text" id="periode_selesai" class="form-control masktanggal" value="<?= $periode_selesai; ?>" onchange="onchange_dropdown_periode()" required>
        </div>
    </div>

    <?php if ($this->fungsi->cek_adm_satu_grup() == false): ?>
        <div class="col-md-3">
            <label><?= $this->lang->line('group_area'); ?></label>
            <select id="id_group" class="form-control" style="width: 100%" onchange="onchange_dropdown_group()"></select>
        </div>
    <?php endif; ?>

    <div class="col-md-4">
        <label>Sales</label>
        <select id="id_karyawan" class="form-control" style="width: 100%"></select>
    </div>

    <div class="col-md-1 align-self-end">
        <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
    </div>
</div>

<div class="table-responsive mt-4">
    <div id="data-actions" class="pull-right ml-1">
        <button type="button" id="btn_download" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle">NO</th>
                <th class="text-center align-middle">TANGGAL</th>
                <th class="text-center align-middle">SALES</th>
                <th class="text-center align-middle">NOMINAL</th>
                <th class="text-center align-middle">PRODUK</th>
                <th class="text-center align-middle">PELANGGAN</th>
                <th class="text-center align-middle">TITLE</th>
                <th class="text-center align-middle">KATEGORI</th>
                <th class="text-center align-middle">JENIS</th>
                <th class="text-center align-middle">LEAD SOURCE</th>
                <th class="text-center align-middle">LAMA CLOSING</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': false,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': false,
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama Sales'
                <?php else: ?> 'searchPlaceholder': 'Employees Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "layout": {
                "topEnd": [
                    $("#data-actions")
                ]
            },
            "ajax": {
                "url": "<?= route('sales_activity.report.realisasi.won.list.data') ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.periode_mulai = $(".filter #periode_mulai").val();
                    d.periode_selesai = $(".filter #periode_selesai").val();
                    d.id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
                    d.id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val();
                },
                "complete": function (data) {
                    let loading = Ladda.create(document.getElementById("btn_download"));
                    loading.stop();
                    $("#btn_download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                render: function (data, type, full, meta) {
                    return "<div style='text-wrap:wrap !important; width:90px; text-align:center'>" + data + "</div>";
                },
                targets: 1
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                // $('td:eq(1)', nRow).css({
                //     'text-align': 'center',
                //     'width': '200px'
                // });
                $('td:eq(2)', nRow).css({
                    'text-align': 'left',
                    'width': '300px'
                });
                $('td:eq(3)', nRow).css({
                    'text-align': 'right',
                    'width': '100px'
                });
                $('td:eq(7)', nRow).css({
                    'text-align': 'left',
                    'width': '100px'
                });
                $('td:eq(8)', nRow).css({
                    'text-align': 'left',
                    'width': '100px'
                });
                $('td:eq(9)', nRow).css({
                    'text-align': 'left',
                    'width': '100px'
                });
                $('td:eq(10)', nRow).css({
                    'text-align': 'left',
                    'width': '100px'
                });
            },
        });
    });
</script>