<div class="position-relative pull-right" style="top: -2.6em;">
    <button id="view-table" type="button" class="ml-1 btn btn-biru ladda-button" data-style="expand-left">
        <i class="fa fa-table"></i> View Table
    </button>
</div>

<div class="py-2">
    <div class="position-absolute pt-1 w-100 text-right" style="right: 15px;">
        <button id="download-diagram-jumlah" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <div class="w-100 mt-1" style="overflow-x: auto;">
        <div style="height: 60vh;">
            <canvas id="list_data_diagram_jumlah"></canvas>
        </div>
    </div>
</div>
<hr>
<div class="pt-2">
    <div class="position-absolute pt-1 w-100 text-right" style="right: 15px;">
        <button id="download-diagram-nominal" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
            <i class="fa fa-download"></i> Download
        </button>
    </div>
    <div class="w-100 mt-1" style="overflow-x: auto;">
        <div style="height: 60vh;">
            <canvas id="list_data_diagram_nominal"></canvas>
        </div>
    </div>
</div>

<script>
    $(function() {
        $("#view-table").click(function() {
            list_datatable("table", this);
        });

        $("#download-diagram-jumlah").click(function() {
            downloadChartImage("Report Pipeline Berdasarkan Jumlah", ctxListDataDiagramJumlah, this);
        });

        $("#download-diagram-nominal").click(function() {
            downloadChartImage("Report Pipeline Berdasarkan Nominal", ctxListDataDiagramNominal, this);
        });

        $('#resetZoomJumlah').click(function() {
            listDataDiagramJumlah.resetZoom();
        });

        $('#resetZoomNominal').click(function() {
            listDataDiagramNominal.resetZoom();
        });

        initCharts();
        view_diagram("<?= $bulan ?>", "<?= $nama_group ?>");
    });

    var ctxListDataDiagramJumlah = document.getElementById('list_data_diagram_jumlah').getContext('2d');
    var ctxListDataDiagramNominal = document.getElementById('list_data_diagram_nominal').getContext('2d');
    var listDatasetsJumlah = [];
    var listDatasetsNominal = [];
    <?php foreach ($tahapan_trx as $value) : ?>
        listDatasetsJumlah.push({
            minBarLength: 10,
            label: "<?= $value->nama ?>",
            backgroundColor: "<?= $value->warna ?>",
            data: [],
            yAxisID: 'yAxis'
        });

        listDatasetsNominal.push({
            minBarLength: 10,
            label: "<?= $value->nama ?>",
            backgroundColor: "<?= $value->warna ?>",
            data: [],
            yAxisID: 'yAxis'
        });
    <?php endforeach; ?>

    var listDataDiagramJumlah, listDataDiagramNominal;

    function initCharts() {
        listDataDiagramJumlah = new Chart(ctxListDataDiagramJumlah, {
            type: 'bar',
            data: {
                labels: [],
                datasets: listDatasetsJumlah,
            },
            options: {
                maintainAspectRatio: false,
                responsive: true,
                layout: {
                    padding: {
                        left: 20,
                        right: 20,
                        top: 20,
                        bottom: 10
                    }
                },
                scales: {
                    yAxis: {
                        offset: true,
                        beginAtZero: true,
                        position: 'right',
                        axis: 'y',
                        ticks: {
                            display: true
                        },
                        grid: {
                            display: true
                        },
                        border: {
                            display: false,
                        }
                    },
                    x: {
                        ticks: {
                            autoSkip: false,
                            callback: function(value, index, values) {
                                var label = this.getLabelForValue(value);
                                if (values.length > 20) {
                                    if (label.length > 25) {
                                        return label.substring(0, 22) + '...';
                                    }
                                }
                                return label;
                            }
                        }
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        align: 'start',
                        text: 'Report Pipeline Berdasarkan Jumlah',
                        color: '#1c77d4',
                        font: {
                            size: 16,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 10
                        }
                    },
                    subtitle: {
                        display: true,
                        align: 'start',
                        text: 'Bulan <?= $periode ?>',
                        font: {
                            size: 14,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 10
                        }
                    },
                    legend: {
                        labels: {
                            boxWidth: 20,
                        },
                        display: true,
                        position: 'bottom',
                    },
                },
            },
        });

        listDataDiagramNominal = new Chart(ctxListDataDiagramNominal, {
            type: 'bar',
            data: {
                labels: [],
                datasets: listDatasetsNominal,
            },
            options: {
                maintainAspectRatio: false,
                responsive: true,
                layout: {
                    padding: {
                        left: 20,
                        right: 20,
                        top: 20,
                        bottom: 10
                    }
                },
                scales: {
                    yAxis: {
                        offset: true,
                        beginAtZero: true,
                        position: 'right',
                        axis: 'y',
                        ticks: {
                            display: true
                        },
                        grid: {
                            display: true
                        },
                        border: {
                            display: false,
                        }
                    },
                    x: {
                        ticks: {
                            autoSkip: false,
                            callback: function(value, index, values) {
                                var label = this.getLabelForValue(value);
                                if (values.length > 20) {
                                    if (label.length > 25) {
                                        return label.substring(0, 22) + '...';
                                    }
                                }
                                return label;
                            }
                        }
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        align: 'start',
                        text: 'Report Pipeline Berdasarkan Nominal',
                        color: '#1c77d4',
                        font: {
                            size: 16,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 10
                        }
                    },
                    subtitle: {
                        display: true,
                        align: 'start',
                        text: 'Bulan <?= $periode ?>',
                        font: {
                            size: 14,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 10
                        }
                    },
                    legend: {
                        labels: {
                            boxWidth: 20,
                        },
                        display: true,
                        position: 'bottom',
                    },
                },
            },
        });
    }

    function view_diagram(periode = "", nama_group = "all") {
        return $.get("<?= route('sales_activity.report.data.sales.list.data.diagram', ['bulan' => '" + periode + "', 'nama_group' => '" + nama_group + "']) ?>", function(data) {
            var result = JSON.parse(data);

            if (result.nama.length > 20) {
                var widthChart = result.nama.length * 55;
                $("#view_data #list_data_diagram_jumlah").closest("div").css("width", widthChart + "px");
                $("#view_data #list_data_diagram_nominal").closest("div").css("width", widthChart + "px");
            } else {
                $("#view_data #list_data_diagram_jumlah").closest("div").css("width", "100%");
                $("#view_data #list_data_diagram_nominal").closest("div").css("width", "100%");
            }

            // Fill Diagram Jumlah with Data
            listDataDiagramJumlah.data.labels = result.nama;
            result.datasets_jumlah.forEach(function(value, index) {
                if (listDataDiagramJumlah.data.datasets[index]) {
                    listDataDiagramJumlah.data.datasets[index].data = value;
                }
            });

            // Adjust Scale Jumlah
            if (result.maxJumlah >= 10) {
                var maxJumlah = Math.round((result.maxJumlah * 1.2) / 10) * 10;
                listDataDiagramJumlah.options.scales.yAxis.steps = 0;
                listDataDiagramJumlah.options.scales.yAxis.max = maxJumlah;
                listDataDiagramJumlah.options.scales.yAxis.ticks.stepSize = maxJumlah / 10;
            } else {
                listDataDiagramJumlah.options.scales.yAxis.steps = 0;
                listDataDiagramJumlah.options.scales.yAxis.max = 10;
                listDataDiagramJumlah.options.scales.yAxis.ticks.stepSize = 1;
            }

            // UPDATE DIAGRAM
            listDataDiagramJumlah.update();

            // Fill Diagram Nominal with Data
            listDataDiagramNominal.data.labels = result.nama;
            result.datasets_nominal.forEach(function(value, index) {
                if (listDataDiagramNominal.data.datasets[index]) {
                    listDataDiagramNominal.data.datasets[index].data = value;
                }
            });

            // Adjust Scale Nominal
            var maxNominal = result.maxNominal;
            var normalizationFactor = 1000000;
            var normalizedMaxNominal = Math.round((maxNominal * 1.2) / normalizationFactor) * normalizationFactor;
            listDataDiagramNominal.options.scales.yAxis.steps = 0;
            listDataDiagramNominal.options.scales.yAxis.max = normalizedMaxNominal;
            listDataDiagramNominal.options.scales.yAxis.ticks.stepSize = normalizedMaxNominal / 10;

            // UPDATE DIAGRAM
            listDataDiagramNominal.update();
        });
    }
</script>
