<script type="text/javascript">
    $(function() {
        $(document).on('click', '.btn_tambah_m_aktivitas', function() {
            $('#tampil_form').load("<?= route("sales_activity.master.aktivitas.form.tambah") ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save_m_aktivitas").addClass("btn_save_m_aktivitas btn btn-primary");
                $(".btn_save_m_aktivitas").append('<i class="fa fa-save"></i> ');
                $(".btn_save_m_aktivitas").append("<?= $this->lang->line('button_form_simpan') ?>");
                $("#btn_new_input_m_aktivitas").hide();
            });
        });

        $(document).on('click', '.btn_edit_m_aktivitas', function() {
            $('#tampil_form').load("<?= route('sales_activity.master.aktivitas.form.edit') ?>"+ "/" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_save_m_aktivitas").addClass("btn_save_m_aktivitas btn btn-warning");
                $(".btn_save_m_aktivitas").append('<i class="fa fa-update"></i> ');
                $(".btn_save_m_aktivitas").append("<?= $this->lang->line('button_form_perbarui') ?>");
                $("#btn_new_input_m_aktivitas").hide();
            });
        });

        $(document).on('click', '.btn_delete_m_aktivitas', function() {
            $('#tampil_form').load("<?= route('sales_activity.master.aktivitas.form.hapus') ?>"+ "/" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                $("#form_input_m_aktivitas input[type=text]").prop("disabled", true);
                $("#form_input_m_aktivitas input[type=number]").prop("disabled", true);
                $("#form_input_m_aktivitas input[type=radio][value='1']").prop("disabled", true);
                $(".btn_save_m_aktivitas").append('<i class="fa fa-trash"></i> ');
                $(".btn_save_m_aktivitas").append('<?= $this->lang->line('button_form_hapus') ?>');
                $(".btn_save_m_aktivitas").removeClass("btn_save_m_aktivitas").addClass("btn_hapus_m_aktivitas btn btn-danger");
            });
        });

        $(document).on('click', '#btn_new_input_m_aktivitas', function() {
            $("#form_input_m_aktivitas :input").prop("disabled", false);
            $("#form_input_m_aktivitas input[type=text]").val('');
            $("#form_input_m_aktivitas input[type=number]").val('');
            $("#form_input_m_aktivitas input[type=radio][value='0']").prop('checked', true);
            $('.btn_save_m_aktivitas').show();
            $('#btn_new_input_m_aktivitas').hide();
            $('#message').html('');
        });

        $(document).on("click", ".btn_save_m_aktivitas", function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#form_input_m_aktivitas #nama").val() == '') {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_kategori') ?></font>");
                $("#form_input_m_aktivitas #nama").focus();
                return false;
            } else if ($("#form_input_m_aktivitas #poin").val() == '') {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jumlah_poin') ?></font>");
                $("#form_input_m_aktivitas #poin").focus();
                return false;
            } else if ($("#form_input_m_aktivitas #flag_lokasi").val() == '') {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_flag_lokasi') ?></font>");
                $("#form_input_m_aktivitas #flag_lokasi").focus();
                return false;
            } else if ($("#form_input_m_aktivitas #flag_upload foto").val() == '') {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_flag_foto') ?></font>");
                $("#form_input_m_aktivitas #flag_upload foto").focus();
                return false;
            }

            loading.start();
            var param = {};
            param.id_activity_m     = $("#form_input_m_aktivitas #id_activity_m").val();
            param.nama              = $("#form_input_m_aktivitas #nama").val();
            param.poin              = $("#form_input_m_aktivitas #poin").val();
            param.flag_lokasi       = $("#form_input_m_aktivitas input[name='flag_lokasi']:checked").val();
            param.flag_upload_foto  = $("#form_input_m_aktivitas input[name='flag_upload_foto']:checked").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('sales_activity.master.aktivitas.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input_m_aktivitas :input").prop("disabled", true);
                            $('.btn_save_m_aktivitas').hide();
                            $('#btn_new_input_m_aktivitas').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        $(document).on('click', '.btn_hapus_m_aktivitas', function() {
            var loading = Ladda.create(this);
            loading.start();

            var param = {};
            param.id = $("#id_activity_m").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('sales_activity.master.aktivitas.delete') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    });

    // function reorder() {
    //     var order = [];
    //     $('#list_data_m_aktivitas tbody tr').each(function(index, element) {
    //         order.push({
    //             id_item: $(this).find("td:eq(0) i").data("key"),
    //             no_urut: index + 1
    //         });
    //     });
    //     return order;
    // }
</script>