<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Target_kpi_m extends CI_Model
{
    var $table = 'kpi_periode_target_p';

    function get_datatables($tahun){
        $this->_get_datatables_query($tahun);
        $query = $this->db->get();
        return $query->result_array();
    }

    private function _get_datatables_query($tahun){
        $this->db->select("tahun,
            bulan,
            periode_mulai,
            periode_selesai,
            id_company")
                    ->from($this->table)
                    ->where("id_company", $this->id_company)
                    ->where("tahun", $tahun)
                    ->order_by('bulan ASC');
    }

    public function getDataById($id = null)
    {
        $this->db->select('
            tahun,
            bulan,
            periode_mulai,
            periode_selesai,
            id_company
        ');
        $this->db->from($this->table);
        $this->db->where("(concat(tahun,bulan,id_company))", $id);
        $this->db->where("id_company", $this->id_company);
        $query = $this->db->get();
        return $query->row();
    }

    public function save($data, $id = null, $jenis)
    {
        if($jenis == 'update'){
            $this->db->where(array('(concat(tahun,bulan,id_company))'=>$id, 'id_company'=>$this->id_company));
            $update = $this->db->update($this->table,$data);
            return  __response_update($update);
        }else{
            $save = $this->db->insert($this->table,$data);
            return __response_save($save);
        }        
    }
}