<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pengaturan_umum_m extends CI_Model
{
    var $table = 'master_company';

    public function getData()
    {
        $select = $this->db->select("lock_device, lock_lokasi, lock_facerecognition")
            ->from($this->table)
            ->where("id_company", $this->id_company)
            ->get()
            ->row();
        return $select;
    }

    public function getDataPengaturanShift()
    {
        $select = $this->db->select("aktif")
            ->from('shift_p')
            ->where("id_company", $this->id_company)
            ->get()
            ->row();
        return $select;
    }

    public function getDataPengaturanCuti()
    {
        $select = $this->db->select('
                id_cuti_p,
                reset_jenis,
                reset_saldo,
                jenis_karyawan,
                periode_cuti,
                join_date_bulan,
                carry_forward_maks_saldo,
                carry_forward_maks_bulan
            ')
            ->from('cuti_p')
            ->where("id_company", $this->id_company)
            ->get()
            ->row();
        return $select;
    }

    public function getDataPengaturanNotifAbsensi()
    {
        $select = $this->db->select('
                absensi_masuk_sebelum_flag,
                absensi_masuk_sebelum_menit,
                absensi_masuk_setelah_flag,
                absensi_masuk_setelah_menit,
                absensi_pulang_setelah_flag,
                absensi_pulang_setelah_menit
            ')
            ->from('notif_absensi_p')
            ->where("id_company", $this->id_company)
            ->get()
            ->row();
        return $select;
    }

    public function save($master_company = null, $data_karyawan = null, $data_users = null, $pengaturan = null)
    {
        if ($master_company == null) {
            return __response_update(false);
        } else {

            $this->db->trans_start();

            if (!empty($pengaturan)) {
                # Update Pengaturan
                $this->db->where(array('id_company' => $this->id_company));
                $this->db->update($pengaturan, $master_company);
                $this->logger->create_log('pengaturan_umum_tukar_shift', 'edit', $this->db->last_query());
            } else {
                # Update Master Company
                $this->db->where(array('id_company' => $this->id_company));
                $this->db->update($this->table, $master_company);
                $this->logger->create_log('pengaturan_umum', 'edit', $this->db->last_query());
            }

            # Update Data Karyawan
            if ($data_karyawan != null) {
                $this->db->where(array('id_company' => $this->id_company));
                $this->db->update('data_karyawan', $data_karyawan);
                $this->logger->create_log('pengaturan_umum_lock_lokasi', 'edit', $this->db->last_query());
            }

            # Update Data Users
            if ($data_users != null) {
                $this->db->where(array('id_company' => $this->id_company));
                $this->db->update('users', $data_users);
                $this->logger->create_log('pengaturan_umum_users', 'edit', $this->db->last_query());
            }

            $this->db->trans_complete();

            /*Optional*/
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return  __response_update(false);
            } else {
                $this->db->trans_commit();
                return  __response_update(true);
            }
        }
    }

    /**
     * insert atau update pengaturan reset saldo cuti
     *
     * @param array $data
     * @param string $for (insert / update)
     * @param string $id (id_cuti_p)
     * @return void
     */
    public function reset_cuti($data = null, $for = 'update', $id = null)
    {
        $this->db->trans_start();

        if ($for == 'store') {
            $nextId = $this->fungsi->getNextId('cuti_p', 'id_cuti_p', $this->id_company, 4);
            $data['id_cuti_p'] = $nextId;
            $data['user_input'] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $data['id_company'] = $this->id_company;
            $this->db->insert('cuti_p', $data);
            $this->logger->create_log('pengaturan_umum_cuti_reset', 'insert', $this->db->last_query());
        } else if ($for == 'update') {
            $data['user_update'] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $data['tgl_update'] = date('Y-m-d H:i:s');
            $this->db->update('cuti_p', $data, ['id_cuti_p' => $id, 'id_company' => $this->id_company]);
            $this->logger->create_log('pengaturan_umum_cuti_reset', 'edit', $this->db->last_query());
        } else {
            $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> '.$this->lang->line('error').'</font>');
            return  __response_update(false, $message);
        }

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            if ($for == 'store') {
                return  __response_save(false);
            }
            return  __response_update(false);
        } else {
            $this->db->trans_commit();
            if ($for == 'store') {
                // fill type jadi id_cuti_p
                $type = ['type' => $nextId];
                return  __response_save(true, $type);
            }
            return  __response_update(true);
        }
    }

    public function notif_absensi_save($data){
        $cek_data = $this->db->select('id_company')
                            ->from('notif_absensi_p')
                            ->where('id_company', $this->id_company)
                            ->get()
                            ->row()
                            ->id_company;

        if(empty($cek_data)){
            // PROSES SAVE
            $user_input = array(
                'tgl_input'     => date("Y-m-d H:i:s"),
                'user_input'    => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $save = $this->db->insert('notif_absensi_p', array_merge($data, $user_input));
            return  __response_save($save);
        }else{
            // PROSES UPDATE
            $user_update = array(
                'tgl_update'     => date("Y-m-d H:i:s"),
                'user_update'	=> $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $this->db->where('id_company', $this->id_company);
            $update = $this->db->update('notif_absensi_p', array_merge($data, $user_update));
            return  __response_update($update);
        }
    }
}
