<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ttd extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('pkwt/master/Ttd_m');
    }

	public function index(){
		$data['judul'] = 'TTD Direksi';
		$data['aktif'] = 'master_ttd_direksi';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pkwt/master/ttd/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Ttd_m->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan;
			$row[] = $field->nm_jabatan;
			$row[] = '<img src="' . $this->config->item('base_image') . 'image?_t=file&_d=' . $field->path_ttd . '" width="120">';
			$row[] = '<a href="#" class="text-warning" title="EDIT">
						<i id="'.md5($field->id_karyawan).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
					<a href="#" class="text-danger" title="HAPUS">
						<i id="'.md5($field->id_karyawan).'" class="btn_delete fa fa-trash"></i>
					</a>';
	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Ttd_m->count_all(),
							"recordsFiltered" => $this->Ttd_m->count_filtered(),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id = null){
		if($id != null){
			$data['data'] = $this->Ttd_m->getDataById($id);
		}
		$this->load->view('pkwt/master/ttd/form',$data);
	}

	public function save(){
		$this->load->library('Uploadfile');

		$id 			= $this->input->post('id');
		$id_karyawan 	= $this->input->post('id_karyawan');
		$nm_jabatan 	= $this->input->post('nm_jabatan');
		$foto_lama 		= $this->input->post('file_lama');
		$nm_karyawan	= $this->_get_nm_karyawan($id_karyawan);

		$file1 = $_FILES['file'];

		if($file1['name'] == ""){
			$foto_file = $foto_lama;
		}else{
			$fileUpload['fname']          = 'file';
			$fileUpload['location']       = 'pkwt/ttd_direksi';
			$fileUpload['allowed']        = 'jpg|png|jpeg';
			$fileUpload['compress_image'] = true;
			$fileUpload['filename']       = preg_replace('/[^A-Za-z0-9\-]/', '', $id_karyawan);

			$upload = $this->uploadfile->doUpload($fileUpload);
			
			if($upload["success"] == true){
				$foto_file = $upload['url'];
				if(!empty($foto_lama)){
					if($foto_file != $foto_lama){
						$path = $this->config->item('base_upload').$foto_lama;
						unlink($path);
					}
				}
			}else{
				$message = ["message"=>$upload["message"]];
				return __response_save(false,["params"=>$message]);
			}
		}
	
		$data = array(	'id_karyawan'	=> $id_karyawan,
						'nm_karyawan'	=> $nm_karyawan,
						'nm_jabatan'	=> $nm_jabatan,
						'path_ttd'		=> $foto_file,
						'id_company' 	=> $this->id_company);

		$this->Ttd_m->save($data, $id, $foto_lama); 
	}

	public function delete(){
		$id = $this->input->post("id"); 
		$path = $this->Ttd_m->getDataById($id)->path_ttd;
		if(file_exists($this->config->item('base_upload').$path)) {
			unlink($this->config->item('base_upload').$path);
		}
		$this->Ttd_m->delete($id);
	}

	private function _get_nm_karyawan($id_karyawan){
		$query = $this->db->select('nama_lengkap')
							->from('data_karyawan')
							->where('id_karyawan', $id_karyawan)
							->where('id_company', $this->id_company)
							->get()
							->row()
							->nama_lengkap;
		return $query;
	}
	
}
