<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Master_gapok extends MY_Controller{

	public function __construct(){
        parent::__construct();
        $this->load->model('payroll/Master_gapok_m');
        $this->load->library('form_validation');
    }

	public function index(){
		$data['judul'] = 'Master Gapok';
		$data['aktif'] = 'master_gapok';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('payroll/master_gapok/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Master_gapok_m->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan."<br><b>".$field->nik."</b>";
			$row[] = $field->nm_cabang."<br><b>".$field->kd_cabang."</b>";
			$row[] = number_format($field->nominal,0,',','.');
			$row[] = number_format($field->lembur_per_jam,0,',','.');

			$btn_edit	= '<a href="#" class="text-warning" title="EDIT"> <i id="'.md5($field->id_karyawan).'" class="btn_edit fa fa-edit (alias) "> </i></a>';
			$btn_hapus	= '<a href="#" class="text-danger" title="HAPUS"><i id="'.md5($field->id_karyawan).'" class="btn_delete fa fa-trash"></i></a>';

			$row[] 	= $btn_edit.' '.$btn_hapus;

			$data[] = $row;
		}

		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->Master_gapok_m->count_all(),
						"recordsFiltered" => $this->Master_gapok_m->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('payroll/master_gapok/form');
		}else{
			$data['data'] = $this->Master_gapok_m->getDataById($id);
			$this->load->view('payroll/master_gapok/form',$data);
		}

	}

	public function save(){
        $id_karyawan		= $this->input->post('id_karyawan');
		$nominal	    	= $this->input->post('nominal_gapok');
		$lembur_per_jam	    = $this->input->post('lembur_per_jam');

		$data = array(	'id_karyawan'		=> $id_karyawan,
						'nominal'		    => str_replace(".","",$nominal),
						'lembur_per_jam'    => str_replace(".","",$lembur_per_jam));

		$this->Master_gapok_m->save($data);
	}

	public function update(){
		$nominal	= $this->input->post('nominal_gapok');
		$lembur_per_jam	    = $this->input->post('lembur_per_jam');

		$data = array(	'nominal' => str_replace(".","",$nominal),
						'lembur_per_jam' => str_replace(".","",$lembur_per_jam));

		$this->Master_gapok_m->update($data);
	}

	public function delete(){
		$id = $this->input->post("id_karyawan");
		$this->Master_gapok_m->delete($id);
	}
}
