<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('kpi/kpi');
    }

    public function index()
    {
        $this->load->view('kpi/user/approval/home');
    }
    
    public function list_data()
    {
        $this->load->model('kpi/user/approval/home_m');

		$list = $this->home_m->get_datatables();
		$data = array();
		$no   = $_GET['start'];
		foreach ($list as $field) {
            $no++;
			$row = array();

            $row[] = $no;
            $row[] = $field->nama_lengkap."<br><b>".$field->nik."</b>";
			$row[] = $field->jabatan;
			$row[] = periode($field->tahun, $field->bulan);
            $row[] = indo_date($field->tgl_pengajuan);
            $row[] = $this->status($field->status);
            $row[] = $this->aksi($field);

			$data[] = $row;
		}

		$output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->home_m->count_all(),
            "recordsFiltered" => $this->home_m->count_filtered(),
            "data"            => $data,
            "validasiPeriode" => validasiPeriodeApv(null, null)
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    public function view_data($jenis)
    {
        $data['jenis'] = $jenis;
        $this->load->view('kpi/user/approval/view_data', $data);
    }

    private function status($idStatus) {
        if($idStatus == '1') {
            return "<span class='badge badge-custom-secondary' style='font-size: 100%; font-family: Poppins SemiBold;'>Baru</span>";
        } elseif($idStatus == '4') {
            return "<span class='badge badge-custom-success' style='font-size: 100%; font-family: Poppins SemiBold;'>Approved</span>";
        } elseif($idStatus == '8') {
            return "<span class='badge badge-custom-warning' style='font-size: 100%; font-family: Poppins SemiBold;'>Draft</span>";
        } elseif($idStatus == '9') {
            return "<span class='badge badge-custom-ungu' style='font-size: 100%; font-family: Poppins SemiBold;'>Diterima</span>";
        }
    }

    private function aksi($data) {
        $id = md5($data->id_karyawan.$data->tahun.$data->bulan);
        $url = route('kpi.approval.detail', ['id' => $id]);
        if(isPeriodeApv()) {
            if($data->status == '1') {
                return '<a id="'.$id.'" class="btn_detail_apv set_planning"><i class="fa fa-check-square-o"></i> approve</a>';
            } elseif($data->status == '8') {
                return '<a id="'.$id.'" class="btn_detail_apv"><i class="fa fa-pencil-square-o"></i> approve</a>';
            } else {
                return '<a id="'.$id.'" class="btn_detail_apv"><i class="fa fa-info-circle"></i></a>';
            }
        } else {
            return '<a id="'.$id.'" class="btn_detail_apv"><i class="fa fa-info-circle"></i></a>';
        }
    }
}