<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengaturan_umum extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Pengaturan_umum_m');
    }

    public function index()
    {
        $data['judul']                        = $this->lang->line('menu_umum');
        $data['aktif']                        = 'pengaturan_umum';
        $data['menu']                         = $this->load->view('main_menu', $data, true);
        $data['tooltip_reset_cuti']           = $this->lang->line('pengaturan_tooltip_reset_cuti');
        $data['tooltip_update_cuti']          = $this->lang->line('pengaturan_tooltip_update_cuti');
        $data['tooltip_lock_lokasi']          = $this->lang->line('pengaturan_tooltip_lock_lokasi');
        $data['tooltip_lock_device']          = $this->lang->line('pengaturan_tooltip_lock_device');
        $data['tooltip_lock_facerecognition'] = $this->lang->line('pengaturan_tooltip_lock_facerecognition');
        $data['data']                         = $this->Pengaturan_umum_m->getData();
        $data['pengaturan_shift']             = $this->Pengaturan_umum_m->getDataPengaturanShift();
        $data['pengaturan_cuti']              = $this->Pengaturan_umum_m->getDataPengaturanCuti();
        $data['pengaturan_notif_absensi']     = $this->Pengaturan_umum_m->getDataPengaturanNotifAbsensi();
        $data['id_company']                   = md5($this->session->userdata('id_company'));
        $data['content']                      = $this->load->view('pengaturan/umum/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function save()
    {
        $jenis_form = $this->input->post("jenis_form");
        $status = $this->input->post("status");

        $master_company = null;
        $data_karyawan  = null;
        $data_users     = null;
        $pengaturan     = null;

        if ($jenis_form == "#form_locklokasi") {
            $master_company = array("lock_lokasi" => $status);
            $data_karyawan  = array("lock_lokasi" => $status);
        } else if ($jenis_form == "#form_lockdevice") {
            $master_company = array("lock_device" => $status);
            $data_users     = array("lock_device" => $status);
        } else if ($jenis_form == "#form_facerecognition") {
            $master_company = array("lock_facerecognition" => $status);
            $data_users     = array("lock_facerecognition" => $status);
        } else if ($jenis_form == "#form_tukarshift") {
            $master_company = array("aktif" => $status);
            $pengaturan     = 'shift_p';
        }

        $this->Pengaturan_umum_m->save($master_company, $data_karyawan, $data_users, $pengaturan);
    }

    public function form_cuti()
    {
        $data['pengaturan_cuti'] = $this->Pengaturan_umum_m->getDataPengaturanCuti();
        $this->load->view('pengaturan/umum/form_cuti', $data, false);
    }

    public function reset_cuti()
    {
        $id                       = $this->input->post('cuti_p');
        $for_data                 = $this->input->post('for_data');
        $reset_cuti               = $this->input->post('reset_cuti');
        $periode_cuti             = $this->input->post('periode_cuti');
        $reset_saldo              = $this->input->post('reset_saldo');
        $jenis_karyawan_tetap     = $this->input->post('jenis_karyawan_tetap');
        $jenis_karyawan_kontrak   = $this->input->post('jenis_karyawan_kontrak');
        $join_date_bulan          = $this->input->post('join_date_bulan');
        $carry_forward_maks_saldo = $this->input->post('carry_forward_maks_saldo');
        $carry_forward_maks_bulan = $this->input->post('carry_forward_maks_bulan');

        if ($jenis_karyawan_tetap) {
            if ($jenis_karyawan_kontrak) {
                $jenis_karyawan = $jenis_karyawan_tetap . ',' . $jenis_karyawan_kontrak;
            } else {
                $jenis_karyawan = $jenis_karyawan_tetap;
            }
        } else {
            $jenis_karyawan = $jenis_karyawan_kontrak;
        }

        $data = array(
            'reset_jenis'              => $reset_cuti,
            'periode_cuti'             => $periode_cuti,
            'reset_saldo'              => $reset_saldo,
            'jenis_karyawan'           => $jenis_karyawan,
            'join_date_bulan'          => $join_date_bulan,
            'carry_forward_maks_saldo' => $carry_forward_maks_saldo,
            'carry_forward_maks_bulan' => $carry_forward_maks_bulan,
        );

        $this->Pengaturan_umum_m->reset_cuti($data, $for_data, $id);
    }

    public function notif_absensi_save(){
        $absensi_masuk_sebelum_flag   = $this->input->post('absensi_masuk_sebelum_flag');
        $absensi_masuk_setelah_flag   = $this->input->post('absensi_masuk_setelah_flag');
        $absensi_pulang_setelah_flag  = $this->input->post('absensi_pulang_setelah_flag');
        $absensi_masuk_sebelum_menit  = $this->input->post('absensi_masuk_sebelum_menit');
        $absensi_masuk_setelah_menit  = $this->input->post('absensi_masuk_setelah_menit');
        $absensi_pulang_setelah_menit = $this->input->post('absensi_pulang_setelah_menit');

        $absensi_masuk_sebelum_menit  = empty($absensi_masuk_sebelum_flag) ? 0 : $absensi_masuk_sebelum_menit;
        $absensi_masuk_setelah_menit  = empty($absensi_masuk_setelah_flag) ? 0 : $absensi_masuk_setelah_menit;
        $absensi_pulang_setelah_menit = empty($absensi_pulang_setelah_flag) ? 0 : $absensi_pulang_setelah_menit;

        $data  = array(
            'absensi_masuk_sebelum_flag'   => $absensi_masuk_sebelum_flag,
            'absensi_masuk_setelah_flag'   => $absensi_masuk_setelah_flag,
            'absensi_pulang_setelah_flag'  => $absensi_pulang_setelah_flag,
            'absensi_masuk_sebelum_menit'  => $absensi_masuk_sebelum_menit,
            'absensi_masuk_setelah_menit'  => $absensi_masuk_setelah_menit,
            'absensi_pulang_setelah_menit' => $absensi_pulang_setelah_menit,
            'id_company'                   => $this->id_company,
        );

        $this->Pengaturan_umum_m->notif_absensi_save($data);
    }
}
