<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengalaman_kerja extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Pengalaman_kerja_m');
        $this->load->library('Uploadfile');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'pengalaman_verifikasi';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan_md5 = null)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['tab_aktif']       = 'verifikasi';
        $data['tab']             = $this->load->view('karyawan/pengalaman_kerja/tab', $data, true);
        $this->load->view('karyawan/pengalaman_kerja/home', $data);
    }

    public function data($id_karyawan = null)
    {
        $data['id_karyawan'] = $id_karyawan;
        $this->load->view('karyawan/pengalaman_kerja/home', $data);
    }

    public function list_data($id_karyawan = null)
    {
        $data['id_karyawan'] = $id_karyawan;
        $this->load->view('karyawan/pengalaman_kerja/list_data', $data);
    }

    public function list_datatables($id_karyawan = null)
    {
        $list = $this->Pengalaman_kerja_m->get_datatables($id_karyawan);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->nama_perusahaan;
            $row[] = $field->jenis_perusahaan;
            $row[] = $field->jabatan;

            $btn_detail = '<a href="#" class="btn_detail_pengalaman text-primary" onclick="modal_detail(`' . md5($field->id_riwayat_pekerjaan) . '`)" title="DETAIL">
                                <i class="fa fa-info-circle"></i>
                            </a>';
            $btn_edit   = '<a href="#" class="btn_edit_pengalaman text-warning" onclick="modal_edit(\'' . $id_karyawan . '\',\'' . md5($field->id_riwayat_pekerjaan) . '\')" title="EDIT">
                                <i class="fa fa-edit"></i>
                            </a>';
            $btn_delete = '<a href="#" class="btn_delete_pengalaman text-danger" onclick="modal_delete(`' . md5($field->id_riwayat_pekerjaan) . '`)"title="' . strtoupper($this->lang->line('hapus')) . '">
                                <i class="fa fa-trash"></i>
                            </a>';
            if (in_array($this->session->userdata('level_user'), array("1")) || in_array($this->session->userdata('level_khusus'), ["1"])) {
                $row[] = $btn_detail . " " . $btn_edit . " " . $btn_delete;
            } else {
                $row[] = $btn_detail;
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_POST['draw'],
            "recordsTotal"    => $this->Pengalaman_kerja_m->count_all($id_karyawan),
            "recordsFiltered" => $this->Pengalaman_kerja_m->count_filtered($id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id_karyawan = null, $id_riwayat_pekerjaan = null)
    {
        $data['id_karyawan'] = $id_karyawan;

        if ($id_riwayat_pekerjaan != null) {
            $data['data'] = $this->Pengalaman_kerja_m->getDataById($id_riwayat_pekerjaan);
        }

        $this->load->view('karyawan/pengalaman_kerja/form', $data);
    }

    public function detail($id_riwayat_pekerjaan = null)
    {
        $data['data'] = $this->Pengalaman_kerja_m->getDataById($id_riwayat_pekerjaan);
        $this->load->view('karyawan/pengalaman_kerja/detail', $data);
    }

    public function save()
    {
        $id_company = $this->session->userdata('id_company');
        $id_riwayat_pekerjaan = $this->input->post('id_riwayat_pekerjaan');
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($this->input->post('id_karyawan'));

        $file_lama = $this->input->post('file_lama');

        $file1 = $_FILES['file'];
        if ($file1['name'] == "") {
            $file = $file_lama;
        } else {

            $fileUpload['fname']    = 'file';
            $fileUpload['location'] = 'karyawan/' . $id_karyawan . '/pengalaman-pekerjaan';
            $fileUpload['allowed']  = 'jpg|png|jpeg';
            $fileUpload['compress_image']  = true;

            $upload = $this->uploadfile->doUpload($fileUpload);
            if ($upload["success"] == true) {
                $file = $upload['url'];
                if (!empty($file_lama)) {
                    if ($file != $file_lama) {
                        $this->fungsi->delete_fileupload($file_lama);
                    }
                }
            } else {
                $message = ["message" => $upload["message"]];
                return __response_save(false, ["params" => $message]);
            }
        }

        $data = array(
            'nama_perusahaan'   => $this->input->post('nama_perusahaan'),
            'jenis_perusahaan'  => $this->input->post('jenis_perusahaan'),
            'jabatan'           => $this->input->post('jabatan_terakhir'),
            'alamat_perusahaan' => $this->input->post('alamat_perusahaan'),
            'provinsi'          => $this->input->post('provinsi'),
            'kota'              => $this->input->post('kota'),
            'tgl_masuk'         => date('Y-m-d', strtotime($this->input->post('tgl_masuk'))),
            'tgl_keluar'        => date('Y-m-d', strtotime($this->input->post('tgl_keluar'))),
            'file'              => $file,
            'alasan_berhenti'   => $this->input->post('alasan_berhenti'),
            'id_company'        => $id_company,
            'id_karyawan'       => $id_karyawan
        );

        $this->Pengalaman_kerja_m->save($data, $id_riwayat_pekerjaan);
    }

    public function delete()
    {
        $id = $this->input->post("id_riwayat_pekerjaan");
        $this->Pengalaman_kerja_m->delete($id);
    }
}
