<style type="text/css">
    .alert-warning {
        color: #856404 !important;
        background-color: #fff3cd !important;
        border-color: #ffeeba !important;
    }

    .thick {
        font-weight: bold;
    }
</style>


<script type="text/javascript">
    $(document).ready(function() {
        $('#form_input #id_cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_shift" class="form-control" value="<?= ((isset($data)) ? md5($data->id_master_shift) : '') ?>">
    <?php
    if (in_array($this->level_user, array("1")) || $this->multi_cabang == true) {
    ?>
        <div class="form-group">
            <label><?= $this->lang->line('cabang') ?> <i class="text-danger">*</i></label>
            <select id="id_cabang" class="form-control select2" style="width:100%">
                <option value="0"><?= $this->lang->line('pilih_cabang') ?></option>
                <?php
                if (isset($data)) {
                    echo '<option value="' . $data->id_cabang . '" selected>' . $data->kode_cabang . ' - ' . $data->nama_cabang . '</option>';
                }
                ?>
            </select>
        </div>
    <?php
    }
    ?>
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= ucwords(strtolower($this->lang->line('kode_shift'))) ?> <i class="text-danger">*</i></label>
                <input type="text" id="kd_shift" class="form-control" value="<?= ((isset($data)) ? $data->kode_shift : '') ?>">
            </div>

            <div class="col-md-6">
                <label><?= ucwords(strtolower($this->lang->line('nama_shift'))) ?> <i class="text-danger">*</i></label>
                <input type="text" id="nm_shift" class="form-control" value="<?= ((isset($data)) ? $data->nama_shift : '') ?>">
            </div>
        </div>
    </div>

    <?php
        if ($this->paket_arr['flexible_jam_kerja'] == false) { ?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label><?= ucwords(strtolower($this->lang->line('libur'))) ?> <i class="text-danger">*</i></label>
                        <div class="row custom-radio-blue">
                            <div class="col-md-6">
                                <section class="light">
                                    <label id="label">
                                        <input type="radio" name="libur" value="0" checked <?= ((isset($data) && $data->libur == "0") ? "checked" : "") ?>>
                                        <span class="design"></span>
                                        <span class="text"><?= $this->lang->line('tidak') ?></span>
                                    </label>
                                </section>
                            </div>
                            <div class="col-md-6">
                                <section class="light">
                                    <label id="label">
                                        <input type="radio" name="libur" value="1" <?= ((isset($data) && $data->libur == "1") ? "checked" : "") ?>>
                                        <span class="design"></span>
                                        <span class="text"><?= $this->lang->line('ya') ?></span>
                                    </label>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    <?php } ?>

    <?php
    if (isset($data) && $data->libur == '1') {
        $hidden = 'd-none';
    } else {
        $hidden = '';
    }
    ?>

    <div id="div_jam_masuk" class="form-group <?= $hidden ?>">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('jam_masuk_shift') ?> <i class="text-danger">*</i></label>
                <input id="jam_masuk" type="text" class="form-control" data-inputmask="'alias': 'datetime','inputFormat': 'HH:MM'" placeholder="HH:MM" value="<?= ((isset($data)) ? $data->jam_masuk : '') ?>">
            </div>
            <div class="col-md-6">
                <label><?= $this->lang->line('jam_pulang_shift') ?> <i class="text-danger">*</i></label>
                <input id="jam_pulang" type="text" class="form-control" data-inputmask="'alias': 'datetime','inputFormat': 'HH:MM'" placeholder="HH:MM" value="<?= ((isset($data)) ? $data->jam_pulang : '') ?>">
            </div>
        </div>
    </div>

    <div id="div_jam_pulang" class="form-group <?= $hidden ?>">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('min_jam_masuk_shift') ?> <i class="text-danger">*</i></label>
                <input id="minimal_jam_masuk" type="text" class="form-control" data-inputmask="'alias': 'datetime','inputFormat': 'HH:MM'" placeholder="HH:MM" value="<?= ((isset($data)) ? $data->start_absen_masuk : '') ?>">
            </div>
            <div class="col-md-6">
                <label><?= $this->lang->line('max_jam_pulang_shift') ?> <i class="text-danger">*</i></label>
                <input id="maksimal_jam_pulang" type="text" class="form-control" data-inputmask="'alias': 'datetime','inputFormat': 'HH:MM'" placeholder="HH:MM" value="<?= ((isset($data)) ? $data->batas_absen_pulang : '') ?>">
            </div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <?php
        if ($cek_jadwal_shift > 0) { ?>
            <div class="col-md-12">
                <div class="alert alert-warning" role="alert">
                    <i class="fa fa-exclamation-triangle" aria-hidden="true"></i>
                    <?= $this->lang->line('error_form_hapus_shift') ?>
                </div>
            </div>

            <div class="col-md-12 text-right">
                <button class="btn btn-danger btn_hapus_ya ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> <?= $this->lang->line('button_form_hapus') ?></button>
                <button class="btn btn-default" data-dismiss="modal" aria-label="Close"> <i class="fa fa-close"></i><?= $this->lang->line('button_form_batal') ?></button>
            </div>
        <?php } else { ?>
            <div class="col-md-7 text-left">
                <div id="message"></div>
            </div>
            <div class="col-md-5 text-right">
                <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
                <button class="btn_save ladda-button" data-style="expand-left"></button>
            </div>
        <?php } ?>
    </div>
</div>
