<style>
    .datepicker-months .datepicker-switch {
        visibility: hidden;
    }

    .datepicker-title {
        transform: translateY(10px);
        position: relative;
        top: 5px;
    }

    .datepicker-months .prev,
    .datepicker-months .next {
        visibility: hidden;
    }
</style>

<script>
    $(function() {
        dropdown_tahun_all();
        dropdown_bulan_all();
        dropdown_filter_group_area_all();

        // Tombol Aksi Download Semua
        $("#action_download_semua").click(function() {
            var tahun      = $("#form_input #tahun").val() ? $("#form_input #tahun").val() : '0000';
            var bulan      = $("#form_input #bulan").data("bulan") ? $("#form_input #bulan").data("bulan") : '00';
            var id_group_m = $("#form_input #id_group_m").val() ? $("#form_input #id_group_m").val() : 'all';
            var nama_group = $("#form_input #id_group_m").val() ? $("#form_input #id_group_m").select2('data')[0]['nama_group'] : 'all';

            urlExcel = "<?= route('sales_activity.demografi.pelanggan.download.semua.action') ?>" + '?tahun=' + tahun + '&bulan=' + bulan + '&id_group_m=' + id_group_m + '&nama_group=' + nama_group;
            downloadFile(urlExcel, this);
        });

        // Toggle visibility of close button
        $('.input-close-btn').on('click', function() {
            $("#form_input #bulan").val("");
            $("#form_input #bulan").data("bulan", "")
            toggleCloseButton($("#form_input #bulan"));
            onchange_tahun_bulan();
        });

        // Initialize visibility based on initial input value
        toggleCloseButton($("#form_input #bulan"));
    });

    function dropdown_tahun_all() {
        $("#form_input #tahun").inputmask({
            'alias': 'datetime',
            'inputFormat': 'yyyy'
        });

        $("#form_input #tahun").datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
        });
    }

    function dropdown_bulan_all() {
        $("#form_input #bulan").datepicker({
            title: "Pilih Bulan",
            format: "MM",
            viewMode: "months",
            minViewMode: "months",
            orientation: 'bottom',
            autoclose: true,
            language: '<?= $this->code_lang ?>'
        }).change(function(e) {
            const months = <?= $this->lang->line('array_bulan') ?>;
            $(e.currentTarget).data("bulan", (months.indexOf(e.currentTarget.value) + 1));
            toggleCloseButton($(e.currentTarget));
        });

        $('#form_input #bulan').datepicker('setDate', new Date());
    }

    function dropdown_filter_group_area_all(){
        var tahun      = $("#form_input #tahun").val() ? $("#form_input #tahun").val() : '0000';
        var bulan      = $("#form_input #bulan").data("bulan") ? $("#form_input #bulan").data("bulan") : '00';

        $("#form_input #id_group_m").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.demografi.dropdown.group.area") ?>' + '?tahun=' + tahun + '&bulan=' + bulan,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_tahun_bulan_all() {
        $("#form_input #id_group_m").val('').trigger('change');
        dropdown_filter_group_area_all();
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input" class="card-body" disabled>
    <div class="row">
        <div class="col-md-3 align-self-center">
            <label class="font-weight-bold"><?= $this->lang->line('tahun'); ?></label>
        </div>
        <div class="col-md-6">
            <input type="text" id="tahun" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('Y') ?>" onchange="onchange_tahun_bulan_all()">
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-md-3 align-self-center">
            <label class="font-weight-bold">Bulan</label>
        </div>
        <div class="col-md-6 position-relative">
            <input type="text" id="bulan" data-bulan="" class="form-control bg-white" style="cursor: pointer;" autocomplete="off" spellcheck="false" placeholder="Semua Bulan" onchange="onchange_tahun_bulan_all()" readonly>
            <span class="input-close-btn">&times;</span>
        </div>
    </div>

    <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
        <div class="row mt-2">
            <div class="col-md-3 align-self-center">
                <label class="font-weight-bold"><?=$this->lang->line('group_area'); ?></label>
            </div>
            <div class="col-md-6 position-relative">
                <select class="form-control" id="id_group_m" style="width: 100%"></select>
            </div>
        </div>
    <?php endif; ?>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="action_download_semua" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
            </button>
        </div>
    </div><!-- ./row -->
</div>
