<script type="text/javascript">
    $(document).on('click', '#btn_baru', function() {
        $('#form_input input[type=text]').prop("disabled", false);
        $("#form_input input[type=text]").val('');
        $('#form_input input[type=date]').prop("disabled", false);
        $("#form_input input[type=date]").val('');
        $("#judul, #content, #foto").prop("disabled", false);

        $("#judul").val('').trigger('change');
        $("#content").val('').trigger('change');

        $('#btn_simpan').show();
        $('#btn_baru').hide();
        $('#view_data').hide();
        $('#message').hide();
    });

    $(document).on("click", "#btn_simpan", function(e) {
        e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(this);

        var html_content = CKEDITOR.instances.content.getData();
        var content = html_content.replace(/\&nbsp;/g, ' ');
        var content = encodeURIComponent(content);

        if ($("#judul").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_judul') ?></font>");
            $("#judul").focus();
            return false;
        }

        loading.start();

        var param = new FormData();
        param.append('judul', $("#judul").val());
        param.append('content', content);
        param.append('gambar_lama', $("#gambar_lama").val());
        param.append('gambar', $('#gambar').prop('files')[0]);
        param.append('id_berita', $("#id_berita").val());

        $.ajax({
            type: 'POST',
            url: "<?= site_url('informasi/berita/save') ?>",
            data: param,
            dataType: 'JSON',
            contentType: false,
            processData: false,
            cache: false,
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'save') {
                        // $("#form_input :input").prop("disabled", true);
                        // $("#judul, #content, #foto").prop("disabled", true);
                        // $('#btn_simpan').hide();
                        // $('#btn_baru').show();
                        // $("#btn_baru").prop("disabled", false);
                        window.location.href = '<?= site_url('informasi/berita') ?>';
                    } else if (result.type == 'update') {
                        // $("#form_input :input").prop("disabled", true);
                        // $("#judul, #content, #foto").prop("disabled", true);
                        // $('#btn_simpan').hide();
                        // $('#btn_baru').show();
                        // $("#btn_baru").prop("disabled", false);
                        window.location.href = '<?= site_url('informasi/berita') ?>';
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    });
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_informasi') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div id="form_input" class="card-body">
            <div class="row">
                <div class="col-md-3">
                    <label><?= $this->lang->line('upload_gambar') ?></label>
                    <?php 
                        if ($data->gambar == "") {
                            $foto = base_url()."assets/images/no-image.png";
                        }else{
                            $foto = $this->config->item('base_image').'imagebiodata?_t=logo&_d='.$data->gambar;
                        }
                    ?>
                    <input type="hidden" name="gambar_lama" id="gambar_lama" value="<?= $data->gambar ?>">

                    <input type="file" name="gambar" id="gambar" id="input-file-now-custom-1" class="dropify" data-default-file="<?= $foto ?>"/>
                </div>
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-12">
                            <label><?= $this->lang->line('judul') ?></label>
                            <input type="text" name="judul" class="form-control" id="judul" value="<?= ((isset($data)) ? $data->judul : '') ?>">
                        </div>
                    </div>
                    <div class="row mt-1">
                        <div class="col-md-12">
                            <label><?= $this->lang->line('isi') ?></label>
                            <textarea id="content" class="form-control"><?= ((isset($data)) ? $data->content : '') ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-12 text-right">
                    <label id="message"></label>
                    <input type="hidden" name="id_berita" id="id_berita" value="<?= ((isset($data)) ? md5($data->id_berita) : '') ?>">
                    <a href="<?= site_url('informasi/berita') ?>" class="btn btn-secondary"><i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?></a>
                    <button type="button" id="btn_baru" class="btn btn-light" style="display: none;"><?= $this->lang->line('button_form_tambah_baru') ?></button>
                    <?php
                    if ($form == "tambah") {
                        echo '<button type="button" id="btn_simpan" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> ' . $this->lang->line('button_form_simpan') . '</button>';
                    } else {
                        echo '<button type="button" id="btn_simpan" class="btn btn-warning ladda-button" data-style="expand-left"><i class="fa fa-edit"></i> ' . $this->lang->line('button_form_perbarui') . '</button>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        // Basic
        $('.dropify').dropify(
            <?php if ($this->code_lang == 'id') { ?> {
                    messages: {
                        'default': 'Seret dan lepas atau klik disini',
                        'replace': 'Seret dan lepas atau klik disini',
                        'remove': 'Hapus',
                        'error': 'Ooops, terjadi kesalahan.',
                    },
                    error: {
                        'fileSize': 'The file size is too big ({{ value }} max).',
                        'minWidth': 'The image width is too small ({{ value }}}px min).',
                        'maxWidth': 'The image width is too big ({{ value }}}px max).',
                        'minHeight': 'The image height is too small ({{ value }}}px min).',
                        'maxHeight': 'The image height is too big ({{ value }}px max).',
                        'imageFormat': 'Format file tidak diperbolehkan ({{ value }} only).'
                    }
                }
            <?php } ?>
        );

        gambar = $('#form_input #gambar').dropify();

        gambar.on('dropify.afterClear', function(event, element) {
            $("#form_input #gambar_lama").val("");
        });
    });

    //CKEDITOR.replace('content');
    CKEDITOR.replace('content', {
        height: 300,
    });

    CKEDITOR.config.toolbar = [
        ['Bold', 'Italic', 'Underline', 'StrikeThrough', '-', 'Undo', 'Redo', '-', 'Cut', 'Copy', 'Paste', 'Find', 'Replace', '-', 'Outdent', 'Indent', '-', 'Print'],
        '/',
        ['NumberedList', 'BulletedList', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
        ['Styles', 'Format', 'Font', 'FontSize']
    ];
</script>
