<?php

include('AspekKedisiplinanBelumDisetujui.php');

class Aspek_kedisiplinan_m extends CI_Model {

    var $table = 'kpi_aspek_kedisiplinan_trx';
    function get_datatables($status){
        if(belumDisetujui($status)) {
            return $this->belumDisetujui();
        } else {
            $this->_get_datatables_query($status);
            if($_GET['length'] != -1){
                $this->db->limit($_GET['length'], $_GET['start']);
            }
            $query = $this->db->get();
            return $query->result();
        }
    }

    function count_filtered($status){
        if(belumDisetujui($status)) {
            return count($this->belumDisetujui());
        } else {
            $this->_get_datatables_query($status);
            $query = $this->db->get();
            return $query->num_rows();
        }
    }

    public function count_all( $status, $id_karyawan = null, $tahun = null, $bulan = null){
        if(belumDisetujui($status)) {
            return count($this->belumDisetujui());
        } else {
            $this->db->select("id_karyawan")->from($this->table);
            $this->db->where("id_company",$this->id_company);
            if($id_karyawan == null) {
                $this->db->where("id_karyawan", htmlentities($this->input->get('karyawan')));
                $this->db->where("tahun", htmlentities($this->input->get('tahun')));
                $this->db->where("bulan", htmlentities($this->input->get('bulan')));
            } else {
                $this->db->where("id_karyawan", $id_karyawan);
                $this->db->where("tahun", $tahun);
                $this->db->where("bulan", $bulan);
            }
            return $this->db->count_all_results();
        }
    }

    private function _get_datatables_query($status){
        if(belumDisetujui($status)) {
            $this->table = 'skor_data';
        }
        $this->db->select("jenis, jumlah, poin, bobot, skor")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", htmlentities($this->input->get('karyawan')));
        $this->db->where("tahun", htmlentities($this->input->get('tahun')));
        $this->db->where("bulan", htmlentities($this->input->get('bulan')));
        $this->db->order_by("FIELD(jenis, 'T', 'PC', 'IT', 'IPC', 'TAP', 'A')", '', true);
    }

    private function belumDisetujui() {
        $this->db->select('COUNT(IF(kode_absensi = "A", 1, NULL)) as A');
        $this->db->select('SUM(IF(kode_absensi LIKE "%(T)%", terlambat, 0)) as T');
        $this->db->select('SUM(IF(kode_absensi LIKE "%(PC)", pulang_cepat, 0)) as PC');
        $this->db->select('COUNT(IF(kode_absensi LIKE "%(TAP)", 1, NULL)) as TAP');
        $this->db->from('r_absensi');
        if($this->input->server('REQUEST_METHOD') == 'POST') {
            $this->db->where("id_karyawan", htmlentities($this->input->post('karyawan')));
            $this->db->where("MONTH(tgl_absen)", (int)htmlentities($this->input->post('bulan')));
            $this->db->where("YEAR(tgl_absen)", (int)htmlentities($this->input->post('tahun')));
        } else {
            $this->db->where("id_karyawan", htmlentities($this->input->get('karyawan')));
            $this->db->where("MONTH(tgl_absen)", (int)htmlentities($this->input->get('bulan')));
            $this->db->where("YEAR(tgl_absen)", (int)htmlentities($this->input->get('tahun')));
        }
        $this->db->group_by('id_karyawan');

        $data            = $this->db->get()->row();
        $bobot           = $this->getBobot();
        $bobotJenis      = array_column($bobot, 'jenis');
        $poinMaster      = $this->getPoinMaster();
        $poinMasterJenis = array_column($poinMaster, 'jenis');
        
        $jenis  = ['A', 'T', 'PC', 'TAP'];
        $result = [];
        foreach($jenis as $val) {
            $bobotVal = array_search($val, $bobotJenis) === FALSE ? 0 : $bobot[array_search($val, $bobotJenis)]['bobot'];
            $temp     = array_slice($poinMaster, array_search($val, $poinMasterJenis), 5);
            $poin     = $this->getBobotPoin($temp, $data->{$val});
            $result[] = new AspekKedisiplinanBelumDisetujui($val, $data->{$val}, $bobotVal, $poin, ($bobotVal * $poin) / 100);
        }
        return $result;
    }

    private function getBobotPoin($master, $bobot) {
        foreach($master as $index => $row) {
            if($bobot >= $row['batas_bawah'] && $bobot <= $row['batas_atas']) {
                return $row['poin'];
            }

            if($index == 4) {
                return $row['poin'];
            }
        }
    }

    private function getPoinMaster() {
        $this->db->select('jenis, batas_bawah, batas_atas, poin');
        $this->db->from('kpi_kedisiplinan_poin_m');
        $this->db->where('id_company', $this->id_company);
        $this->db->order_by('jenis', 'asc');
        $this->db->order_by('poin', 'desc');
        return $this->db->get()->result_array();
    }

    private function getBobot() {
        $this->db->select('jenis, bobot');
        $this->db->from('kpi_kedisiplinan_bobot_m');
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->result_array();
    }

    public function insertKedisiplinan($status, $id_karyawan, $tahun, $bulan) {
        $total = $this->count_all($status, $id_karyawan, $tahun, $bulan);
        if($total > 0) {
            $data = $this->belumDisetujui();
            $batch = [];
            foreach($data as $row) {
                $row->id_company  = $this->id_company;
                $row->user_input  = $this->nik_karyawan." - ".$this->nm_karyawan;
                $row->id_karyawan = $id_karyawan;
                $row->tahun       = $tahun;
                $row->bulan       = $bulan;
                $batch[] = (array) $row;
            }
            $this->db->insert_batch('kpi_aspek_kedisiplinan_trx', $batch);
        }
    }
    
    public function totalSkorBelumDisetujui() {
        return array_sum(array_column($this->belumDisetujui(), 'skor'));
    }

}