<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Jadwal extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('patroli/Jadwal_m');
    }

	public function index(){
		$data['judul'] = $this->lang->line('jadwal');
		$data['content'] = $this->load->view('patroli/jadwal/home', $data);
	}

	public function list_data(){
		$id_cabang = $this->input->get('id_cabang');
		$list = $this->Jadwal_m->get_datatables($id_cabang);
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			$row[] = $field->nm_jadwal;
			$row[] = date_format(date_create($field->min_absen),'H:i');
			$row[] = date_format(date_create($field->max_absen),'H:i');

            if(in_array($this->level_user, array("1"))) {

				$row[] = '<a href="javascript:void(0)" class="text-warning" title="EDIT">
						<i id   = "' . md5($field->id) . '" class = "btn_edit fa fa-edit (alias) " onclick="edit_jadwal(this)"> </i>
                    </a>&nbsp;
                    <a href="javascript:void(0)" class = "text-danger" title = "HAPUS">
						<i id   = "' . md5($field->id) . '" class = "btn_delete fa fa-trash" onclick="delete_jadwal(this)"></i>
                    </a>';
			}
	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Jadwal_m->count_all($id_cabang),
							"recordsFiltered" => $this->Jadwal_m->count_filtered($id_cabang),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('patroli/jadwal/form');
		}else{
			$data['data'] = $this->Jadwal_m->getDataById($id);
			$this->load->view('patroli/jadwal/form',$data);
		}
		
	}

	public function save(){
		$id = $this->input->post('id_jadwal');

		$min_absen = $this->input->post('min_absen');
		$max_absen = $this->input->post('max_absen');
		
		$date_now         = date("Y-m-d");
		$min_absen_ymdhis = date_format(date_create($date_now." ".$min_absen.":00"),"Y-m-d H:i:s");
		$max_absen_ymdhis = date_format(date_create($date_now." ".$max_absen.":00"),"Y-m-d H:i:s");

		if($min_absen_ymdhis >= $max_absen_ymdhis){
			$message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jam Mulai harus lebih kecil dari Jam Selesai</font>');
			return __response_save(false,$message);
		}
	
		$data = array(
						'id_cabang'  =>$this->input->post('id_cabang'),
						'nm_jadwal'  =>$this->input->post('nm_jadwal'),
						'min_absen'  =>$min_absen,
						'max_absen'  =>$max_absen,
						'id_company' =>$this->id_company
				);
	
		$this->Jadwal_m->save($data,$id); 
	}

	public function delete(){
		$id = $this->input->post("id_jadwal");
		$this->Jadwal_m->delete($id);
	}
}
