<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Detail extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('kpi/kpi');
    }

    public function index($id)
    {
        $this->load->model('kpi/notif_m');

        $data['data']            = detailData($id);
        $data['validasiPeriode'] = validasiPeriodeApv($data['data']['tahun'], $data['data']['bulan']);
        $this->notif_m->updateNotifAjukanActual($data['data']);
        $this->notif_m->updateNotifTerima($data['data']);
        $this->load->view('kpi/user/approval/detail/home', $data);
    }

    private function validasiPeriode($tahun, $bulan) {
        $this->load->model('kpi/user/approval/home_m');

        $periode     = $this->home_m->periodeApv($tahun, $bulan);
        $tglSekarang = date('Y-m-d');
        if($periode->num_rows() == 0) {
            return "<h3><span class='badge badge-danger text-dark'>Periode approval KPI belum diset</span></h3>";
        } else {
            return "<h3><span class='badge badge-danger text-dark'>Periode approval KPI : ".indo_date($periode->row()->periode_mulai)." s/d ".indo_date($periode->row()->periode_selesai)."</span></h3>";
        }
    }

    public function form() {
        $this->load->view('kpi/user/approval/detail/form');
    }

    public function button($tahun, $bulan, $karyawan, $jenis) {
        $this->load->model('kpi/user/team/detail_m');

        $data['isPeriodeApv'] = isPeriodeApv($tahun, $bulan);
        $data['status']        = $this->detail_m->getDataTrx($tahun, $bulan, $karyawan)->row()->status;
        $this->load->view('kpi/user/approval/detail/button_'.$jenis, $data);
    }

    public function setujui() {
        $this->load->model([
            'kpi/user/approval/aspek_kinerja_m',
            'kpi/user/approval/aspek_kepribadian_m',
            'kpi/user/approval/aspek_kedisiplinan_m',
            'kpi/user/approval/nilai_individu_m',
            'kpi/user/approval/home_m',
            'karyawan_m',
            'kpi/notif_m'
        ]);
        $this->load->helper(['generateid', 'kpi/notif']);

        $tab = htmlentities($this->input->post('tab'));
        if($tab == "aspek_kinerja") {
            $data = $this->aspek_kinerja_m->data();
            $this->db->update_batch('kpi_aspek_kinerja_trx', $data, 'id_pi_trx');
        }

        if($this->invalid($this->aspek_kinerja_m->validasi())) {
            __response_approve(false, [
                'message'    => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Aspek kinerja belum dilengkapi</font>',
                'new_params' => ['tab' => 'aspek_kinerja']
            ]);
            exit;
        } elseif($this->aspek_kepribadian_m->count() == 0 || $this->invalid($this->aspek_kepribadian_m->validasi())) {
            __response_approve(false, [
                'message'    => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Aspek kepribadian belum dilengkapi</font>',
                'new_params' => ['tab' => 'aspek_kepribadian']
            ]);
            exit;
        }

        $id_karyawan = htmlentities($this->input->post('karyawan'));
        $tahun       = htmlentities($this->input->post('tahun'));
        $bulan       = htmlentities($this->input->post('bulan'));

        $data_karyawan = $this->karyawan_m->getDataById(md5($id_karyawan));
        $nama_lengkap  = $data_karyawan->nama_lengkap;
        $id_jabatan    = $data_karyawan->id_jabatan;
        $detail        = detailData(md5($id_karyawan.$tahun.$bulan));
        
        $this->db->trans_start();
        $this->home_m->setujui($id_karyawan, $tahun, $bulan);
        $this->aspek_kedisiplinan_m->insertKedisiplinan($detail->status, $id_karyawan, $tahun, $bulan);
        $this->nilai_individu_m->updateSkor($id_karyawan, $tahun, $bulan, $id_jabatan);
        $this->notif_m->insertNotifApproval($nama_lengkap);
        $this->db->trans_complete();
        $status = $this->db->trans_status();
        if($status) {
            approveKpi();
        }
        __response_approve($status);
    }

    private function invalid($value) {
        return $value > 0;
    }
}