<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Kedisiplinan extends MY_Controller {
    public function __construct(){
		parent::__construct();
		$this->load->model('kpi/admin/master/Kedisiplinan_m', 'model');
	}

    public function index(){
        $data['data'] = $this->model->getData();
        $data['poin'] = $this->model->getPoin();
        
        if(empty($data['data'])){
            $this->_insert_bobot();
            $data['data'] = $this->model->getData();
        }

        if(empty($data['poin'])){
            $this->_insert_poin();
            $data['poin'] = $this->model->getPoin();
        }

        $this->load->view('kpi/admin/master/kedisiplinan/home', $data);
    }

    public function update(){
        $data_bobot1 = $this->input->post('bobot1');
        $data_bobot2 = $this->input->post('bobot2');
        $data_bobot3 = $this->input->post('bobot3');
        $data_bobot4 = $this->input->post('bobot4');

        $data[] = $data_bobot1;
        $data[] = $data_bobot2;
        $data[] = $data_bobot3;
        $data[] = $data_bobot4;

        $id_bobot1 = $this->input->post('id_bobot1');
        $id_bobot2 = $this->input->post('id_bobot2');
        $id_bobot3 = $this->input->post('id_bobot3');
        $id_bobot4 = $this->input->post('id_bobot4');

        $a = array($data_bobot1,$data_bobot2,$data_bobot3,$data_bobot4);
		$jumlah_bobot = array_sum($a);

        if ($jumlah_bobot > 100) {
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, Jumlah Bobot lebih dari 100 %</font>'];
            return __response_update(false, $message);

        }elseif($jumlah_bobot < 100){
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, Jumlah Bobot kurang dari 100 %</font>'];
            return __response_update(false, $message);

        }else if($jumlah_bobot == 100){
            $this->db->trans_start();
            $update[] = $this->db->query("UPDATE kpi_kedisiplinan_bobot_m SET bobot = $data_bobot1 WHERE id_company = '$this->id_company' AND id = $id_bobot1 ");
            $update[] = $this->db->query("UPDATE kpi_kedisiplinan_bobot_m SET bobot = $data_bobot2 WHERE id_company = '$this->id_company' AND id = $id_bobot2 ");
            $update[] = $this->db->query("UPDATE kpi_kedisiplinan_bobot_m SET bobot = $data_bobot3 WHERE id_company = '$this->id_company' AND id = $id_bobot3 ");
            $update[] = $this->db->query("UPDATE kpi_kedisiplinan_bobot_m SET bobot = $data_bobot4 WHERE id_company = '$this->id_company' AND id = $id_bobot4 ");
            $this->db->trans_complete();

            $status = $this->db->trans_status();
            if($status) {
                // $get_data = $this->Master_skor_m->getData();
                // foreach($get_data as $row){
                //     $temp[] = $row->bobot;
                // }
        
                // $this->hitung_ulang_skor_data($temp, $data, $update);
            }
            return  __response_update($status);
        }
    }

    public function update_poin(){
        $array_poin = $this->input->post('array_poin');

        $this->db->trans_start();

        foreach($array_poin as $poin){
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_kedisiplinan_poin_m', $poin['id_poin']);
            $this->db->set($poin['name'], $poin['nilai']);
            $this->db->update('kpi_kedisiplinan_poin_m');
        }

        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_save(false);
        } else {
            $this->db->trans_commit();
            return __response_save(true);
        }
    }


    private function _insert_bobot(){
        $data = array();

        $data[] = array(
            'id'         => $this->id_company. date('Ym'). '0001',
            'jenis'      => 'T',
            'bobot'      => '30',
            'id_company' => $this->id_company,
            'tgl_input'  => date("Y-m-d H:i:s"),
            'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
        );
        $data[] = array(
            'id'         => $this->id_company. date('Ym'). '0002',
            'jenis'      => 'A',
            'bobot'      => '30',
            'id_company' => $this->id_company,
            'tgl_input'  => date("Y-m-d H:i:s"),
            'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
        );
        $data[] = array(
            'id'         => $this->id_company. date('Ym'). '0003',
            'jenis'      => 'PC',
            'bobot'      => '20',
            'id_company' => $this->id_company,
            'tgl_input'  => date("Y-m-d H:i:s"),
            'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
        );
        $data[] = array(
            'id'         => $this->id_company. date('Ym'). '0004',
            'jenis'      => 'TAP',
            'bobot'      => '20',
            'id_company' => $this->id_company,
            'tgl_input'  => date("Y-m-d H:i:s"),
            'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
        );

        $this->db->trans_start();
        $this->db->insert_batch('kpi_kedisiplinan_bobot_m', $data);
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
    }

    private function _insert_poin(){
        $arr_jenis     = ["T", "PC", "TAP", "A"];
        $arr_bts_bawah = [0, 2, 4, 6, 9];
        $arr_bts_atas  = [1, 3, 5, 7, 15];
        $arr_bts_bawah = array_reverse($arr_bts_bawah);
        $arr_bts_atas  = array_reverse($arr_bts_atas);

        $no = 1;
        $data_insert = array();
        foreach($arr_jenis AS $jenis){
            for ($i = 5; $i >= 1; $i--) {
                $data = array(
                    "id_kedisiplinan_poin_m" => $this->id_company. date('Ym'). sprintf("%04d", $no),
                    "jenis"                  => $jenis,
                    "batas_bawah"            => $arr_bts_bawah[($i-1)],
                    "batas_atas"             => $arr_bts_atas[($i-1)],
                    "poin"                   => $i,
                    'id_company'             => $this->id_company,
                    'tgl_input'              => date("Y-m-d H:i:s"),
                    'user_input'             => $this->nik_karyawan. " - ". $this->nm_karyawan
                );
    
                $no++;
                $data_insert[] = $data;
            }
        }

        $this->db->trans_start();
        $this->db->insert_batch('kpi_kedisiplinan_poin_m', $data_insert);
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
    }
}