<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Informasi_lembur extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan_detail/Informasi_lembur_m', 'model');
    }

    public function index($id_karyawan = null)
    {
        $master_lembur         = $this->model->get_master_lembur();
        $data['master_lembur'] = $master_lembur;
        $data['aturan_lembur'] = $this->model->get_aturan_lembur($id_karyawan);
        $data['id_karyawan']   = $id_karyawan;
        $this->load->view('karyawan/payroll/informasi_lembur/index', $data);
    }

    public function form($column, $id_karyawan)
    {
        $master_lembur         = $this->model->get_master_lembur();
        $data['master_lembur'] = $master_lembur;
        $data['aturan_lembur'] = $this->model->get_aturan_lembur($id_karyawan);
        $data['id_karyawan']   = $id_karyawan;
        $data['column']        = $column;

        $this->load->view('karyawan/payroll/informasi_lembur/form', $data);
    }

    public function save()
    {
        // def
        $id_karyawan = $this->input->post('id_karyawan');
        $column      = $this->input->post('column');
        $value       = $this->input->post('value');
        $value_old   = $this->input->post('value_old');

        // decrypt karyawan
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($id_karyawan);

        // validasi
        if ($value === $value_old) return __response_update(true);
        if (!$id_karyawan) return __response_update(false, ['message' => '<i class="fa fa-close"></i> Karyawan tidak ditemukan']);
        if (!$column) return __response_update(false, ['message' => '<i class="fa fa-close"></i> Gagal simpan data, silakan muat ulang halaman']);

        // update data
        $this->model->save($column, $value, $id_karyawan);
    }
}
