<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Support extends MY_Controller {
	/*
	 * Modul untuk bantuan support
	 * Email 	= support@ptdes.net
	 * Password = >v[x@}}=h8UV}Tj8
	 * 
	 * Fitur : 
	 * - Create dan cek user admin berdasarkan nama company/id company/nama customer/email/telp
	 * */
	
	
	public function __construct(){
        parent::__construct();
        $this->load->model('Support_m');
        $this->load->helper('form');
        $this->load->library('session');
    }
    
    function index() {
		$email = $this->session->userdata('email');
		if($email) {
			$this->dashboard();
		} else {
			$this->load->view('support/login');
		}
	}
    
    function login() {
		$status = false;
		
		$email 		= $this->input->get('email');
		$password	= $this->input->get('password');
		if($email == 'support@ptdes.net' and $password == '>v[x@}}=h8UV}Tj8') {
			$this->session->set_userdata('email', $email);
			$status = true;
		}
		echo $status;
	}
	
	function logout() {
		$this->session->sess_destroy();
		redirect(site_url('support'));
	}
	
	function dashboard() {
		$this->load->view('support/dashboard');
	}
	
	function save() {
		$email = $this->session->userdata('email');
		if(!$email) {
			redirect(site_url('support'));
		}
		
		$id_company = $this->input->get("id_company");
		$result = $this->create_admin($id_company);
		echo json_encode($result);
	}

    function create_admin($id_company) {
		$id_jabatan_admin = $id_cabang = $message = $status = "";
		
		$cek_karyawan_admin = $this->Support_m->cek_karyawan_admin($id_company);
		if($cek_karyawan_admin->num_rows() > 0) {
			$username = $cek_karyawan_admin->row()->username;
			$message = "Admin sudah ada, username = ".$username;
			$status = false;
		} else {
			$cek_jabatan_admin = $this->Support_m->cek_jabatan_admin($id_company);
			if($cek_jabatan_admin->num_rows() > 0) {
				$id_jabatan_admin = $cek_jabatan_admin->row()->id_jabatan;
			} else {
				$this->Support_m->create_jabatan_admin($id_company);
				$id_jabatan_admin = $id_company.date('Ym').'001';
			}
			
			$cek_cabang = $this->Support_m->cek_cabang($id_company);
			if($cek_cabang->num_rows() > 0) {
				$id_cabang = $cek_cabang->row()->id_cabang;
			} else {
				$this->Support_m->create_cabang($id_company);
				$id_cabang = $id_company.date('Ym').'001';
			}
			
			$this->Support_m->create_karyawan($id_company, $id_cabang, $id_jabatan_admin);
			$username = "ADM".$id_company;
			$password = "Absenku123**";
			// hash = 44a2d9d4d48403091918a78d66d27ffd0378b0ce
			$password_hash = sha1(sha1(md5($password)));
			$this->Support_m->create_user($id_company, $username, $password_hash);
			$message = "Berhasil create admin, username = ".$username.", password = ".$password;
			$status = true;
		}
		
		$result = array(
			'message' 	=> $message,
			'status'	=> $status
		);
		return $result;
	}
	
	function select2_company(){
		$email = $this->session->userdata('email');
		if(!$email) {
			echo "belum login";exit;
		}
		
        $search = $this->input->get("q");

        $this->db->select('master_company.id_company, master_company.nama');
		$this->db->join('master_customer', 'master_customer.id_customer = master_company.id_customer');
        $this->db->like('master_company.nama', $search);
        $this->db->or_like('master_company.id_company', $search);
        $this->db->or_like('master_customer.nama', $search);
        $this->db->or_like('master_customer.telp', $search);
        $this->db->or_like('master_customer.email', $search);
        $this->db->limit(10);
        $this->db->order_by('master_company.id_company', 'ASC');

        $result = $this->db->get('master_company')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_company, 'text'=>$rows->nama];
        }
        echo json_encode($json);
    }
    
    function detail_company() {
		$email = $this->session->userdata('email');
		if(!$email) {
			echo "belum login";exit;
		}
		
		$id_company = $this->input->get('id_company');
		
		$query = $this->Support_m->detail_company($id_company);
		$data = array(
			'id_company'	=> $query->id_company,
			'nama_company'	=> $query->nama_company,
			'desc_company'	=> $query->deskripsi,
			'alamat_company'	=> $query->alamat_company,
			'paket'			=> $query->nama_paket,
			'nama_customer'	=> $query->nama_customer,
			'no_telp'		=> $query->telp,
			'email'			=> $query->email,
			'alamat_customer'	=> $query->alamat_customer,
			'provinsi'		=> $query->propinsi,
			'kota'			=> $query->kota
		);
		echo json_encode($data);
	}
}
