<div class="position-relative pull-right" style="top: -2.5em;">
    <button id="view-table" type="button" class="ml-1 btn btn-biru ladda-button" data-style="expand-left">
        <i class="fa fa-table"></i> View Table
    </button>
</div>

<div class="py-2">
    <div class="position-absolute pt-1 w-100 text-right" style="right: 15px;">
        <button id="download-diagram" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <div class="w-100 mt-1" style="overflow-x: auto;">
        <div style="height: 60vh;">
            <canvas id="list_data_diagram"></canvas>
        </div>
    </div>
</div>

<script>
    $(function() {
        $("#view-table").click(function() {
            list_datatable("table", this);
        });

        $("#download-diagram").click(function() {
            downloadChartImage("Report Nominal", ctxListDataDiagram, this);
        });

        let tahun       = $(".filter #tahun").val();
        let id_group    = !$(".filter #id_group").val()?'all':$(".filter #id_group").val();
        let nm_group    = !$(".filter #id_group").val()?'Semua Group':$(".filter #id_group").select2('data')[0]['nm-group'];
        let id_karyawan = !$(".filter #id_karyawan").val()?'all':$(".filter #id_karyawan").val();
        let nm_karyawan = !$(".filter #id_karyawan").val()?'Semua Sales':$(".filter #id_karyawan").select2('data')[0]['nm-karyawan'];
        view_diagram(tahun, id_group, nm_group, id_karyawan, nm_karyawan);
    });

    var ctxListDataDiagram = document.getElementById('list_data_diagram').getContext('2d');
    if (!$(".filter #id_karyawan").val()) {
        var listDatasets = [{
                label: "Total Realisasi",
                data: [],
                backgroundColor: "rgba(34, 193, 195, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(34, 193, 195, 1)",
                yAxisID: 'yAxis'
            },
            {
                label: "Total Target Personal",
                data: [],
                backgroundColor: "rgba(253, 187, 45, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(253, 187, 45, 1)",
                yAxisID: 'yAxis'
            },
            {
                label: "Total Target Tahunan",
                data: [],
                backgroundColor: "rgba(0, 123, 255, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(0, 123, 255, 1)",
                yAxisID: 'yAxis'
            },
            {
                label: "Total Target Kuartal",
                data: [],
                backgroundColor: "rgba(154, 205, 50, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(154, 205, 50, 1)",
                yAxisID: 'yAxis'
            },
            {
                label: "Total Target Bulanan",
                data: [],
                backgroundColor: "rgba(255, 99, 132, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(255, 99, 132, 1)",
                yAxisID: 'yAxis'
            }
        ];
    } else {
        var listDatasets = [{
                label: "Total Realisasi",
                data: [],
                backgroundColor: "rgba(34, 193, 195, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(34, 193, 195, 1)",
                yAxisID: 'yAxis'
            },
            {
                label: "Total Target Personal",
                data: [],
                backgroundColor: "rgba(253, 187, 45, 0.03)",
                borderWidth: 2,
                fill: true,
                tension: 0.1,
                borderColor: "rgba(253, 187, 45, 1)",
                yAxisID: 'yAxis'
            }
        ];
    }
    var listDataDiagram = new Chart(ctxListDataDiagram, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agt', 'Sep', 'Okt', 'Nov', 'Des'],
            datasets: listDatasets,
        },
        options: {
            maintainAspectRatio: false,
            responsive: true,
            layout: {
                padding: {
                    left: 20,
                    right: 20,
                    top: 20,
                    bottom: 10
                }
            },
            scales: {
                yAxis: {
                    beginAtZero: true,
                    position: 'right',
                    ticks: {
                        display: true
                    },
                    grid: {
                        display: true
                    },
                    border: {
                        display: false,
                    }
                },
            },
            plugins: {
                title: {
                    display: true,
                    align: 'start',
                    text: '',
                    color: '#1c77d4',
                    font: {
                        size: 16,
                        weight: 'bold'
                    },
                    padding: {
                        bottom: 10
                    }
                },
                subtitle: {
                    display: true,
                    align: 'start',
                    text: '',
                    font: {
                        size: 14,
                        weight: 'bold'
                    },
                    padding: {
                        bottom: 10
                    }
                },
                legend: {
                    labels: {
                        boxWidth: 40,
                    },
                    display: true,
                    position: 'bottom',
                },
            }
        },
    });

    function view_diagram(tahun = "", id_group="all", nm_group="", id_karyawan = "all", nm_karyawan="") {
        return $.get("<?= route('sales_activity.report.realisasi.nominal.list.data.diagram') ?>"+'?tahun='+tahun+'&id_group='+id_group+'&nm_group='+nm_group+'&id_karyawan='+id_karyawan+'&nm_karyawan='+nm_karyawan, function(data) {
            var result = JSON.parse(data);

            listDataDiagram.data.datasets[0].data = result.total_realisasi;
            listDataDiagram.data.datasets[1].data = result.total_target_personal;
            if (result.total_target_tahunan) listDataDiagram.data.datasets[2].data = result.total_target_tahunan;
            if (result.total_target_kuartal) listDataDiagram.data.datasets[3].data = result.total_target_kuartal;
            if (result.total_target_bulanan) listDataDiagram.data.datasets[4].data = result.total_target_bulanan;

            listDataDiagram.options.plugins.title.text = result.title;
            listDataDiagram.options.plugins.subtitle.text = 'Sales Monitoring - Tahun '+tahun;

            // Adjust Scale
            var maxNominal = result.max;
            var normalizationFactor = 1000000;
            var normalizedMaxNominal = Math.round((maxNominal * 1.2) / normalizationFactor) * normalizationFactor;
            if (maxNominal >= 10) {
                listDataDiagram.options.scales.yAxis.steps = 0;
                listDataDiagram.options.scales.yAxis.max = normalizedMaxNominal;
                listDataDiagram.options.scales.yAxis.ticks.stepSize = normalizedMaxNominal / 10;
            } else {
                listDataDiagram.options.scales.yAxis.steps = 0;
                listDataDiagram.options.scales.yAxis.max = 10;
                listDataDiagram.options.scales.yAxis.ticks.stepSize = 1;
            }

            // UPDATE DIAGRAM
            listDataDiagram.update();
        });
    }
</script>
