<div class="position-relative pull-right" style="top: -2.6em;">
    <button id="view-diagram" type="button" class="ml-1 btn btn-warning ladda-button" data-style="expand-left">
        <i class="fa fa-bar-chart"></i> View Diagram
    </button>
</div>
<div class="table-responsive mt-4">
    <div class="pull-right ml-1">
        <button id="download" type="button" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center align-middle" width="20">NO</th>
                <th rowspan="2" class="text-center align-middle">NAMA</th>
                <?php
                if (COUNT($tahapan_trx) > 0) {
                    foreach ($tahapan_trx as $tahapan) {
                        echo '<th colspan="2" class="text-center text-uppercase">' . $tahapan->nama . '</th>';
                    }
                } else {
                    echo '<th colspan="2" class="text-center text-uppercase">-</th>';
                }
                ?>
            </tr>
            <tr>
                <?php
                if (COUNT($tahapan_trx) > 0) {
                    for ($x = 1; $x <= COUNT($tahapan_trx); $x++) {
                        echo '<th class="text-center">JUMLAH</th>';
                        echo '<th class="text-center">NOMINAL</th>';
                    }
                } else {
                    echo '<th class="text-center">JUMLAH</th>';
                    echo '<th class="text-center">NOMINAL</th>';
                }
                ?>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function() {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan'
                <?php else : ?> 'searchPlaceholder': 'Employees Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.report.data.sales.list.data') . "/" . $bulan . "/" . $nama_group ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    $("#download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                render: function(data, type, full, meta) {
                    return "<div style='text-wrap:wrap !important; width:200px'>" + data + "</div>";
                },
                targets: 1
            }],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                <?php
                if (COUNT($tahapan_trx) > 0) {
                    $i_eq = 2;
                    for ($x = 1; $x <= COUNT($tahapan_trx); $x++) {
                        echo "$('td:eq(" . $i_eq . ")', nRow).css({'text-align': 'center'});";
                        $i_eq++;
                        echo "$('td:eq(" . $i_eq . ")', nRow).css({'text-align': 'right'});";
                        $i_eq++;
                    }
                } else {
                    echo "$('td:eq(2)', nRow).css({'text-align': 'center'});";
                    echo "$('td:eq(3)', nRow).css({'text-align': 'right'});";
                    $i_eq = 4;
                }
                ?>

                <?php $kolom_terakhir = ($i_eq - 1); ?> // karena $i_eq++; paling bawah & loop terakhir
                if (aData[<?= $i_eq ?>] == "colspan") {
                    $("td:eq(1)", nRow).css({
                        'display': 'none'
                    });
                    $('td:eq(0)', nRow)
                        .css({
                            'text-align': 'center',
                            'background-color': '#1c77d4',
                            'color': '#fff',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });

                    $(nRow).children('td:eq(0)').attr('colspan', 2);

                    for (var i = 2; i <= <?= $kolom_terakhir ?>; i++) {
                        $('td:eq(' + i + ')', nRow).css({
                            'background-color': '#ccedff',
                            'color': '#000',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });
                    }
                }
            }
        });

        $("#download").click(function() {
            urlExcel = "<?= route('sales_activity.report.data.sales.download', ['bulan' => $bulan, 'nama_group' => $nama_group]) ?>";
            downloadFile(urlExcel, this);
        });

        $("#view-diagram").click(function() {
            list_datatable("diagram", this);
        });
    });
</script>
