<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'lengthMenu'  : [1, 10],
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language': {
                        <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                            'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                            'searchPlaceholder': 'Nama Cabang/Nama Lokasi'
                        <?php else : ?> 'searchPlaceholder': 'Branch Name/Location Name'
                        <?php endif; ?>
                    },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                        "url": "<?= route('patroli.master.qrcode.list.data') ?>",
                                        "type": "GET",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false }
                                        <?php
                                            if (in_array($this->level_user, array("1"))) {
                                        ?>
                                        , { "aTargets": [3], "bSortable": false }
                                        , { "aTargets": [4], "bSortable": false }

                                        <?php }?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(3)', nRow).css({'text-align':'center','width':'100px'});

                            <?php
                                if (in_array($this->level_user, array("1"))) {
                            ?>

                            $('td:eq(4)', nRow).css({'text-align':'center','width':'10px'});

                            <?php }?>
                    }
        
        });


    });

    function tambah_masterqr(e){
        $('#modal_form #tampil_form').load("<?= route('patroli.master.qrcode.form.tambah') ?>",function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    };

    function delete_masterqr(e){
        $('#modal_form #tampil_form').load("<?= route('patroli.master.qrcode.form.hapus') ?>"+"/"+$(e).attr('id'),function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
            $('#form_input input[type=text]').prop("disabled",true);
            $('#form_input :input').prop("disabled",true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    };

    function new_input(e){
        $("#form_input :input").prop("disabled", false);
        $("#form_input input[type=text]").val('');

        $("#form_input #id_cabang").select2("val","0");
        
        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').hide();
    };

    function simpan(e){
        $('#message').html("");
        var loading = Ladda.create(e);
    
        if($("#id_cabang").val()=="0"){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
            $("#id_cabang").focus();
            return false;
        }else if($("#nm_lokasi").val() ==""){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_lokasi') ?></font>");
            $('#nm_lokasi').focus();
            return false;
        }
        
        loading.start();
    
        var param = 'id_master_cp='+$("#id_master_cp").val()+
                    '&id_cabang='+$("#id_cabang").val()+
                    '&nm_lokasi='+$("#nm_lokasi").val();
    
        $.ajax({
            type: 'POST',
            url: "<?= route('patroli.master.qrcode.save') ?>",
            data: param,
            dataType:'JSON',
            success: function(result) {
                if(result.success == true){
                    if(result.type == 'save'){
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error:function(){
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : <?= $this->lang->line('error') ?></strong></font>');
            }
        });
    };

    // PROSES DELETE
    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();
        var param = {};
        param.id_master_cp=$("#id_master_cp").val();
        $.ajax({
            type: 'POST',
            url: "<?= route('patroli.master.qrcode.delete') ?>",
            data: param,
            dataType:'JSON',
            success: function(result){
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message);
                $('#modal_form font').attr('color', 'white');
            },
            error:function(){
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    };
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('patroli') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
             <?php
                if (in_array($this->level_user, array("1"))) {
            ?>
            <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru" onclick="tambah_masterqr(this)">
                    <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
                </button>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left text-uppercase"><?= $this->lang->line('cabang') ?></th>
                            <th class="text-left text-uppercase"><?= $this->lang->line('nama_lokasi')?></th>
                            <th class="text-center">QRCODE</th>
                            <?php
                                if(in_array($this->level_user, array("1"))) {
                            ?>
                            <th class="text-center text-uppercase"><?= $this->lang->line('aksi') ?></th>
                            <?php
                                }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<!-- <div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div> -->
<!-- END TAMPIL MODAL -->

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <img id="imgcont" width="100%" src="#" alt="">
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        $('#exampleModal').on('shown.bs.modal', function(event) {
            $('#imgcont').attr('src', event.relatedTarget.dataset.urlimg);
        });

        $('#exampleModal').on('hide.bs.modal', function(event) {
            $('#imgcont').attr('src', '');
        });
    });
</script>