<div class="row align-items-center">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Detail Kompetensi</h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn-secondary pull-right ml-1 js-menu__close" onclick="list_datatable('home', this);unset_detail('master');">
            <i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?>
        </button>

        <button 
            type="button" 
            class="btn btn_tambah btn-success pull-right" 
            onclick="tambah(this)"
            data-id_jabatan = "<?= $bobot->id_jabatan ?>"
            data-nama_jabatan = "<?= $bobot->nama_jabatan ?>"
        >
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div>

<hr>

<div id="div_jumlah_bobot mt-3">
    <div class="row" style="font-size: 14px !important;">
        <div class="col-md-4">
            Untuk Jabatan : 
            <span class="font-weight-bold">
                <?= $bobot->nama_jabatan ?>
            </span>
        </div>
        <div class="col-md-4">
            Total Bobot : 
            <span class="font-weight-bold">
                <span id="bobot_data"><?= $bobot->bobot_data ?></span> %
            </span>
        </div>
    </div>
</div>


<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-text-middle text-uppercase" rowspan="2" width="10px">No</th>
                <th class="text-center align-text-middle text-uppercase" rowspan="2" width="150px">Personal Aspek</th>
                <th class="text-center align-text-middle text-uppercase" rowspan="2">Description</th>
                <th class="text-center align-text-middle text-uppercase" rowspan="2" width="50px">Bobot</th>
                <th class="text-center align-text-middle text-uppercase" colspan="5">Target</th>
                <?php
                    if (in_array($this->level_user, array("1"))) {
                ?>
                    <th class="text-center text-uppercase" rowspan="2" width="10px">Aksi</th>
                <?php } ?>
            </tr>
            <tr>
                <th class="text-center" width="100px">1</th>
                <th class="text-center" width="100px">2</th>
                <th class="text-center" width="100px">3</th>
                <th class="text-center" width="100px">4</th>
                <th class="text-center" width="100px">5</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script type="text/javascript">
    $(function() {
        // List Datatable Detail
        list_data = $('#list_data').DataTable({
            'searching': false,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('kpi.master.kepribadian.detail.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                    d.id_jabatan = '<?= $bobot->id_jabatan ?>';
                },
                "complete": function(data) {
                    // reconfigure(data);
                    var outerHeight = $('#drawer #list_data').outerHeight();
                    outerHeight = outerHeight * 80 / 100;
                    $(".div_pembungkus_js_menu_context").css('height', outerHeight);
                }
            },

            "aoColumnDefs": [
                {
                    "aTargets" : [1,2,4,5,6,7,8],
                    "className" : 'align-text-top text-justify',
                },
                {
                    "aTargets" : [-1,0,3],
                    "className" : 'align-text-top text-center'
                },
                {
                    "aTargets" : [-1],
                    "width" : '50px'
                }
            ],
        });
    });

    function tambah(e){
        var id_jabatan = $(e).attr('data-id_jabatan');
        var nama_jabatan = $(e).attr('data-nama_jabatan');
        $('#tampil_form_aspek').load("<?= route('kpi.master.kepribadian.form.tambah') ?>", function() {
            $('#modal_form_aspek').modal('show');
            $('#form_input_id_jabatan').val(id_jabatan);
            $('#nama_jabatan_form').html(nama_jabatan);
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('Simpan');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function edit(e){
        var id_jabatan = $(e).attr('data-id_jabatan');
        var nama_jabatan = $(e).attr('data-nama_jabatan');
        $('#tampil_form_aspek').load("<?= route('kpi.master.kepribadian.form.edit') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form_aspek').modal('show');
            $('#form_input_id_jabatan').val(id_jabatan);
            $('#nama_jabatan_form').html(nama_jabatan);
            $(".title").text("Form Edit Data");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('Perbarui');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function hapus_form(e){
        var id_jabatan = $(e).attr('data-id_jabatan');
        var nama_jabatan = $(e).attr('data-nama_jabatan');
        $('#tampil_form_aspek').load("<?= route('kpi.master.kepribadian.form.hapus') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form_aspek').modal('show');
            $('#form_input_id_jabatan').val(id_jabatan);
            $('#nama_jabatan_form').html(nama_jabatan);
            $(".title").text("Form Hapus data");
            $('#form_input input[type=text]').prop("disabled", true);
            $('#form_input input[type=number]').prop("disabled",true);
            $('#form_input textarea').prop("disabled",true);
            $("#jenis").prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('Hapus');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    }

    function new_input(e){
        $('#form_input input[type=text]').prop("disabled",false);
        $("#form_input input[type=text]").val('');
        $('#form_input input[type=number]').prop("disabled",false);
        $("#form_input input[type=number]").val('');
        $('#form_input textarea').prop("disabled",false);
        $("#form_input textarea").val('');

        $('#tampil_form_aspek .btn_save').show();
        $('#tampil_form_aspek #btn_new_input').hide();
        $('#tampil_form_aspek #message').hide();
    };

    function simpan(e){
        $('#tampil_form_aspek #message').html("");
        var loading = Ladda.create(e);

        if ($("#form_input_personal_aspek").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Personal Aspek belum diisi</font>");
            $("#form_input_personal_aspek").focus();
            return false;
        } else if ($("#form_input_keterangan").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Keterangan belum diisi</font>");
            $('#form_input_keterangan').focus();
            return false;
        }else if ($("#form_input_bobot").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Bobot belum disi</font>");
            $('#form_input_bobot').focus();
            return false;
        }else if ($("#form_input_poin_1").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Target 1 belum disi</font>");
            $('#form_input_poin_1').focus();
            return false;
        }else if ($("#form_input_poin_2").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Target 2 belum disi</font>");
            $('#form_input_poin_2').focus();
            return false;
        }else if ($("#form_input_poin_3").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Target 3 belum disi</font>");
            $('#form_input_poin_3').focus();
            return false;
        }else if ($("#form_input_poin_4").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Target 4 belum disi</font>");
            $('#form_input_poin_4').focus();
            return false;
        }else if ($("#form_input_poin_5").val() == "") {
            $('#tampil_form_aspek #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Target 5 belum disi</font>");
            $('#form_input_poin_5').focus();
            return false;
        }

        loading.start();
        var param = {};

        param.id_kepribadian = $("#form_input_id_kepribadian").val();
        param.personal_aspek = $("#form_input_personal_aspek").val();
        param.keterangan     = $("#form_input_keterangan").val();
        param.bobot          = $("#form_input_bobot").val();
        param.poin_1         = $("#form_input_poin_1").val();
        param.poin_2         = $("#form_input_poin_2").val();
        param.poin_3         = $("#form_input_poin_3").val();
        param.poin_4         = $("#form_input_poin_4").val();
        param.poin_5         = $("#form_input_poin_5").val();
        param.id_jabatan     = $("#form_input_id_jabatan").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.master.kepribadian.save') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'save') {
                        $('#form_input input[type=text]').prop("disabled", true);
                        $('#form_input input[type=number]').prop("disabled",true);
                        $('#form_input textarea').prop("disabled",true);
                        $('#tampil_form_aspek .btn_save').hide();
                        $('#tampil_form_aspek #btn_new_input').show();

                        list_data_home.ajax.reload();
                    }
                }

                loading.stop();
                $('#tampil_form_aspek #message').show();
                $('#tampil_form_aspek #message').html(result.message);
                // $('#bobot_pengaturan').html(result.bobot_pengaturan)
                $('#bobot_data').html(result.bobot_data)
            },
            error: function() {
                loading.stop();
                $('#tampil_form_aspek #message').show();
                $('#tampil_form_aspek #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();

        var param                = {};
            param.id_kepribadian = $("#form_input_id_kepribadian").val();
            param.id_jabatan     = $("#form_input_id_jabatan").val();
        
        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.master.kepribadian.delete') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                $('#bobot_data').html(result.message.bobot_data)

                $("#modal_form_aspek .card-body").hide();
                $("#modal_form_aspek .card-footer").hide();
                $("#modal_form_aspek .title").html(result.message.message.replace("009900", "FFFFFF"));
            },
            error: function() {
                loading.stop();
                $("#modal_form_aspek .card-body").hide();
                $("#modal_form_aspek .card-footer").hide();
                $("#modal_form_aspek .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }
</script>

