<?php

/**
 * Welcome to Luthier-CI!
 *
 * This is your main route file. Put all your HTTP-Based routes here using the static
 * Route class methods
 *
 * Examples:
 *
 *    Route::get('foo', 'bar@baz');
 *      -> Route::['foo']['GET','bar/baz';
 *
 *    Route::post('bar', 'baz@fobie', [ 'namespace' => 'cats' ]);
 *      -> Route::['bar']['POST','cats/baz/foobie';
 *
 *    Route::get('blog/{slug}', 'blog@post');
 *      -> Route::['blog/{id}','blog/post'
 */

Route::get('/', function () {
    redirect(route('login'));
})->name('homepage');

Route::set('404_override', function () {
    show_404();
    // redirect(route('page.not.found'));
});

Route::set('translate_uri_dashes', FALSE);

Route::get('image', 'Image@index');
Route::get('imagebiodata','Image@image_bodata');
Route::get('syarat-dan-ketentuan', 'Syarat_ketentuan@index');

Route::get('auto_login/{username?}/{token?}', 'Auto_login@index');
Route::group('login', function () {
    Route::get('', 'Auth@index')->name('login');
    Route::post('proses', 'Auth@login');
    Route::get('captcha', 'Auth@captcha');
});
Route::get('logout', 'Auth@logout');

//Route::get('menu','Akses_menu@index');

Route::group('api', function () {
    Route::post('registrasi/cabang', 'Cabang@registrasi');
    Route::group('notif', function () {
        Route::get('receive/{par}', 'Socket_send@receive_notification');
        Route::get('send/{target?}/{id_room?}', 'Socket_send@notif_izin');
    });

    Route::group('data_absensi', function () {
        Route::get('mulialand', 'apis/Mulialand@data_absensi');
        Route::get('jalantol', 'Api@jalan_tol');
        Route::get('mulia_industri_group', 'Api@mulia_industri');
    });

    Route::group('mulialand', function () {
        Route::get('jadwalshift/test', 'apis/Mulialand@test');
        Route::post('jadwalshift/add', 'apis/Mulialand@add_jadwal_shift');
        Route::get('jadwalshift/get', 'apis/Mulialand@jadwal_shift');
        Route::get('data_karyawan/edit_nik/{nik_baru?}/{nik_lama?}', 'apis/Mulialand@update_nik');
    });

    Route::group('pdam-tirta-perwitasari', function () {
        Route::get('data-absensi', 'apis/PDAM_tirta_perwitasari@data_absensi');
    });
});

Route::get('halaman-tidak-ditemukan', 'Page_not_found@index')->name('page.not.found');
Route::get('hubungi-kami', 'Page_not_found@contact_us')->name('contact.us');

Route::group('support', function () {
    Route::get('', 'Support@index');
    Route::get('login', 'Support@login');
    Route::get('logout', 'Support@logout');
    Route::get('select2_company', 'Support@select2_company');
    Route::get('detail_company', 'Support@detail_company');
    Route::get('save', 'Support@save');
});

$args = ['foo' => 'bar'];
// $this->middleware->run('AuthMiddleware', $args);
Route::get('test/{id?}', function () {
    echo "routing";
}, ['namespace' => 'foo', 'middleware' => 'Staff:1,2,3']);

Route::get('test2', function () {
    echo "routing";
}, ['namespace' => 'foo', 'middleware' => 'Staff']);

Route::group('wizard', ['middleware' => ['Otentikasi_wizard']], function () {
    Route::get('', 'Wizard@index');
    Route::group('notifikasi', function () {
        Route::get('email', 'Wizard_notifikasi@kirim_email')->name('wizard.notifikasi.email');
        Route::get('whatsapp', 'Wizard_notifikasi@kirim_whatsapp')->name('wizard.notifikasi.whatsapp');
    });
    Route::get('select2_departemen', 'Wizard_kepala_departemen@select2_departemen');
    Route::get('select2_departemen_staff', 'Wizard_staff@select2_departemen');
    Route::get('cek_username', 'Wizard_kepala_departemen@cek_username');
    Route::group('kepala_departemen', function () {
        Route::get('insert', 'Wizard_kepala_departemen@insert');
    });
    Route::group('lokasi', function () {
        Route::get('', 'Wizard_lokasi@index');
        Route::post('insert', 'Wizard_lokasi@insert');
        Route::post('update', 'Wizard_lokasi@update');
    });
    Route::group('akun', function () {
        Route::group('kepala-departemen', function () {
            Route::get('', 'Wizard_kepala_departemen@index')->name('wizard.akun.kepala_departemen.home');
            Route::get('tambah', 'Wizard_kepala_departemen@tambah_akun')->name('wizard.akun.kepala_departemen.tambah');
            Route::post('insert', 'Wizard_kepala_departemen@insert')->name('wizard.akun.kepala_departemen.insert');
            Route::post('update', 'Wizard_kepala_departemen@update')->name('wizard.akun.kepala_departemen.update');
        });
        Route::group('staff', function () {
            Route::get('', 'Wizard_staff@index')->name('wizard.akun.staff.home');
            Route::get('tambah', 'Wizard_staff@tambah_akun')->name('wizard.akun.staff.tambah');
            Route::post('insert', 'Wizard_staff@insert')->name('wizard.akun.staff.insert');
            Route::post('update', 'Wizard_staff@update')->name('wizard.akun.staff.update');
        });
    });
    Route::group('akun', function () {
        Route::get('tambah', 'Wizard_tambah_akun@tambah')->name('wizard.akun.tambah');
        Route::get('pilih', 'Wizard_tambah_akun@pilih')->name('wizard.akun.pilih');
    });
    Route::get('selesai', 'Wizard_tambah_akun@index')->name('wizard.selesai');
    Route::get('berhasil', 'Wizard@berhasil')->name('wizard.berhasil');
    Route::get('dashboard', 'Wizard@dashboard')->name('wizard.dashboard');
});

Route::group('mobile',function(){
    Route::get('pkwt/view/{id_pkwt?}','pkwt/baru/home@view_html');
    Route::get('pkwt/download/{id_pkwt?}','pkwt/baru/home@download_pdf');
});

Route::group('', ['middleware' => ['Otentikasi_login']], function () {

    Route::get('new-token-req', 'Auth@token_req_new')->name('new.token.req');

    Route::group('', ['middleware' => ['Auth_conn:absensi']], function () {
        Route::get('ganti-password', 'Auth@ganti_password')->name("ganti.password");
        Route::post('gantipassword/proses', 'Auth@ganti_password_save')->name("ganti.password.proses");

        // multilingual dropdown
        Route::get('lang/{lang}', 'LanguageSwitcher@switchLang')->name('multilingual');

        Route::group('dropdown', function () {
            Route::get('jabatan', 'Dropdown_menu@jabatan')->name('dropdown.jabatan');
            Route::get('jabatan/by/{cabang?}/{departemen?}', 'Dropdown_menu@jabatan_by_departemen')->name('dropdown.jabatan.by.departemen');
            Route::get('cabang', 'Dropdown_menu@cabang')->name('dropdown.cabang');
            Route::get('departemen', 'Dropdown_menu@departemen')->name('dropdown.departemen');
            Route::get('departemen/by/cabang/{cabang?}', 'Dropdown_menu@departemen_by_cabang')->name('dropdown.departemen.by.cabang');
            Route::get('supervisi/{id_cabang?}/{id_departemen?}', 'Dropdown_menu@supervisi')->name('dropdown.supervisi');
            Route::get('karyawan', 'Dropdown_menu@karyawan')->name('dropdown.karyawan');
            Route::get('karyawan/enc', 'Dropdown_menu@karyawan_encrypt')->name('dropdown.karyawan.encrypt');
            Route::get('karyawan/aktif/{id_cabang?}', 'Dropdown_menu@karyawanAktif')->name('dropdown.karyawan.aktif');
            Route::get('lokasi-absensi', 'Dropdown_menu@lokasi_absensi')->name('dropdown.lokasiabsensi');
            Route::get('provinsi', 'Dropdown_menu@provinsi')->name('dropdown.provinsi');
            Route::get('kota/{id_prov?}', 'Dropdown_menu@kota')->name('dropdown.kota');
            Route::get('kecamatan/{id_kota?}', 'Dropdown_menu@kecamatan')->name('dropdown.kecamatan');
            Route::get('kelurahan/{id_kecamatan?}', 'Dropdown_menu@kelurahan')->name('dropdown.kelurahan');
            Route::get('jam-kerja/{id_cabang?}', 'Dropdown_menu@getJamKerja')->name('dropdown.jamkerja');
            Route::get('jam-kerja-karyawan', 'Dropdown_menu@getJamKerjaKaryawan')->name('dropdown.jamkerjakaryawan');
            Route::get('jam-shift', 'Dropdown_menu@getJamShift')->name('dropdown.jamshift');
            Route::get('nama-shift/{id_cabang?}', 'Dropdown_menu@getNamaShift')->name('dropdown.shift.nama');
            Route::get('jenis-izin', 'Dropdown_menu@getJenisIzin')->name('dropdown.jenisizin');
            Route::get('akun-reimbursement', 'Dropdown_menu@get_akun')->name('dropdown.akun.reimbursement');
            Route::get('karyawan/list/izin', 'Dropdown_menu@list_karyawan_izin')->name('dropdown.karyawan.list.izin');
            Route::get('karyawan/sales/aktif', 'Dropdown_menu@karyawanAktifInSalesActivity')->name('dropdown.karyawan.aktif.sales.activity');

            // KPI
            Route::get('karyawan/aktif2', 'Dropdown_menu@karyawanAktif2')->name('dropdown.karyawan.aktif.skor');
            Route::get('karyawan/approver/kpi', 'Dropdown_menu@karyawanApproverkpi')->name('dropdown.karyawan.approver.kpi');

            // Dropdown PPH
            Route::get('karyawan-pph/{periode?}', 'Dropdown_menu@karyawan_pph')->name('dropdown.karyawan.pph');
            Route::get('cabang-pph/{periode?}', 'Dropdown_menu@cabang_pph')->name('dropdown.cabang.pph');
            Route::get('departemen-pph/{periode?}/{cabang?}', 'Dropdown_menu@departemen_pph')->name('dropdown.departemen.pph');

            Route::group('preselect', function () {
                Route::get('karyawan/{id}', 'dropdown_menu_preselect@karyawan')->name('dropdown.preselect.karyawan');
                Route::get('jabatan/{id}', 'dropdown_menu_preselect@jabatan')->name('dropdown.preselect.jabatan');
                Route::get('cabang/{id}', 'dropdown_menu_preselect@cabang')->name('dropdown.preselect.cabang');
                Route::get('departemen/{id}', 'dropdown_menu_preselect@departemen')->name('dropdown.preselect.departemen');
            });
            Route::group('kpi', ['middleware' => 'Auth_menu:1,2,3,4,5,6,7', 'namespace' => 'kpi'], function () {
                Route::get('obyektives', 'Dropdown@obyektives')->name('dropdown.kpi.obyektives');
                Route::get('bawahan/{input?}', 'Dropdown@kpiBawahan')->name('dropdown.kpi.bawahan');
            });
            Route::group('pkwt', ['middleware' => 'Auth_menu:1', 'namespace' => 'pkwt'], function() 
            {
                Route::get('pkwt-komp-tunj','Dropdown@pkwt_komp_tunj')->name('dropdown.pkwt.komp.tunj');
                Route::get('tunjangan','Dropdown@tunjangan')->name('dropdown.pkwt.tunjangan');
                Route::get('template','Dropdown@template')->name('dropdown.pkwt.template');
                Route::get('direktur','Dropdown@direktur')->name('dropdown.pkwt.direktur');
            });
        });

        Route::group('notification', function () {
            Route::get('notif-izin/{param?}', 'Dashboard@notif_izin');
            Route::get('notif-lembur/{param?}', 'Dashboard@notif_lembur');
            Route::get('notif-reimbursement/{param?}', 'Dashboard@notif_reimbursement');
        });

        Route::group('dashboard',  function () {
            Route::group('absensi', ['middleware' => 'Auth_menu:1,2,4,5,7'], function () {

                Route::get('layanan', 'Dashboard@dataLayanan')->name('dashboard.layanan');

                Route::group('ttl-karyawan', function () {
                    Route::get('genre/{id_cabang?}/{id_departemen?}', 'dashboards/Total_karyawan@ttlkaryawanByGenre')->name('dashboard.absensi.ttl.karyawan.genre');
                    Route::group('dropdown', function () {
                        Route::get('cabang', 'dashboards/Total_karyawan@dropdown_cabang')->name('dashboard.absensi.ttl.karyawan.dropdown.cabang');
                        Route::get('departemen/{id_cabang?}', 'dashboards/Total_karyawan@dropdown_departemen')->name('dashboard.absensi.ttl.karyawan.dropdown.departemen');
                    });
                });

                Route::group('grafik', function () {
                    Route::group('data-karyawan', function () {
                        Route::get('data/{id_cabang?}/{id_departemen?}', 'dashboards/Data_karyawan@dataKaryawan')->name('dashboard.absensi.grafik.data.karyawan.data');
                        Route::get('form/{tahun?}/{id_cabang?}/{id_departemen?}', 'dashboards/Data_karyawan@form')->name('dashboard.absensi.grafik.data.karyawan.form');
                        Route::post('data-tabel/{tahun?}/{id_cabang?}/{id_departemen?}', 'dashboards/Data_karyawan@dataTable')->name('dashboard.absensi.grafik.data.karyawan.data.tabel');
                        Route::group('dropdown', function () {
                            Route::get('cabang', 'dashboards/Data_karyawan@dropdown_cabang')->name('dashboard.absensi.grafik.data.karyawan.dropdown.cabang');
                            Route::get('departemen/{id_cabang?}', 'dashboards/Data_karyawan@dropdown_departemen')->name('dashboard.absensi.grafik.data.karyawan.dropdown.departemen');
                        });
                    });
                    Route::group('joint_vs_termination', function () {
                        Route::get('data/{tahun?}/{id_cabang?}/{id_departemen?}', 'dashboards/Joint_vs_termination@JoinVsTermination')->name('dashboard.absensi.grafik.joint.termination.data');
                        Route::get('form/{jenis?}/{tahun?}/{bulan?}/{id_cabang?}/{id_departemen?}', 'dashboards/Joint_vs_termination@form')->name('dashboard.absensi.grafik.joint.termination.form');
                        Route::post('data-tabel/{jenis?}/{tahun?}/{bulan?}/{id_cabang?}/{id_departemen?}', 'dashboards/Joint_vs_termination@dataTable')->name('dashboard.absensi.grafik.joint.termination.data.tabel');
                        Route::group('dropdown', function () {
                            Route::get('tahun', 'dashboards/Joint_vs_termination@dropdown_tahun')->name('dashboard.absensi.grafik.joint.termination.dropdown.tahun');
                            Route::get('cabang', 'dashboards/Joint_vs_termination@dropdown_cabang')->name('dashboard.absensi.grafik.joint.termination.dropdown.cabang');
                            Route::get('departemen/{id_cabang?}', 'dashboards/Joint_vs_termination@dropdown_departemen')->name('dashboard.absensi.grafik.joint.termination.dropdown.departemen');
                        });
                    });

                    Route::group('keterlambatan', function () {
                        Route::get('data/{id_cabang?}/{tgl_mulai?}/{tgl_selesai?}', 'dashboards/Keterlambatan@data')->name('dashboard.absensi.grafik.keterlambatan.data');
                        Route::group('dropdown', function () {
                            Route::get('cabang', 'dashboards/Keterlambatan@dropdown_cabang')->name('dashboard.absensi.grafik.keterlambatan.dropdown.cabang');
                        });
                    });
                });

                Route::get('', 'dashboard@index')->name('dashboard.absensi');
                Route::get('lst/data/{jenis?}', 'dashboard@dashboard_list')->name('dashboard.list.data');

                Route::get('list_cabang_selected', 'dashboard@list_cabang_selected');
                Route::get('data/diagram/pie/{id_cabang?}/{id_shift?}', 'Dashboard@data_pie')->name('dashboard.absensi.data.diagram.pie');
                Route::get('data/diagram/pie/detail/{jenis?}/{id_cabang?}/{id_shift?}', 'Dashboard@data_pie_detail')->name('dashboard.absensi.data.diagram.pie.detail');

                Route::group('detail', function () {
                    Route::get('data/{id_cabang?}/{id_shift?}', 'Dashboard_absensi@index')->name('dashboard.absensi.detail.data');
                    Route::get('list', 'Dashboard_absensi@list_data');
                    Route::get('list_absensi', 'Dashboard_absensi@list_absensi');
                    Route::get('list_absensi_selected', 'Dashboard_absensi@list_absensi_selected');
                    Route::get('excel', 'Dashboard_absensi@excel');
                    Route::get('view-data/{cabang?}/{departemen?}/{jadwal?}/{status?}', 'Dashboard_absensi@view_data');
                    Route::get('list-data/{cabang?}/{departemen?}/{jadwal?}/{status?}', 'Dashboard_absensi@list_data')->name('dashboard.absensi.detail.list.data');
                    Route::get('list-data-absen/{cabang?}/{departemen?}/{jadwal?}/{status?}', 'Dashboard_absensi@list_data_absen')->name('dashboard.absensi.detail.list.data.absen');
                    Route::get('lokasi/{jenis?}/{id?}', 'Dashboard_absensi@lokasi');
                    Route::get('data_dashboard/{id_cabang?}/{id_departemen?}/{id_shift?}/{status?}', 'Dashboard_absensi@data_dashboard');
                    // Route::get('get-departemen/{id}','Dashboard_absensi@get_departemen');
                });
            });

            Route::group('kepegawaian', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,2,4,5,7'], function () {
                    Route::get('', 'Kepegawaian@index')->name('dashboard.kepegawaian');
                    Route::get('diagram/status-karyawan/{id?}', 'Kepegawaian@data_kepegawaian')->name("dashboard.kepegawaian.diagram.status");
                    Route::get('diagram/pendidikan/{id_cabang?}', 'Kepegawaian@data_pendidikan')->name("dashboard.kepegawaian.diagram.pendidikan");
                    Route::get('data/kontrak-berakhir', 'Kepegawaian@daftar_kontrak')->name("dashboard.kepegawaian.data.kontrak.berakhir");
                    Route::get('data/kontrak-berakhir/list', 'Kepegawaian@list_data')->name("dashboard.kepegawaian.data.kontrak.list");;
                    Route::get('data/kontrak-berakhir/download', 'Kepegawaian@download')->name('dashboard.kepegawaian.kontrak.berakhir.download');
                    Route::get('count', 'Kepegawaian@kepegawaian_count')->name('dashboard.kepegawaian.count');
                    Route::get('main-data-status-pegawai/{jenis?}/{cabang?}', 'Kepegawaian@main_data_status_pegawai')->name('dashboard.kepegawaian.detail.main.status.pegawai');
                    Route::get('list-data-status-pegawai/{jenis?}/{cabang?}', 'Kepegawaian@list_data_status_pegawai')->name('dashboard.kepegawaian.detail.list.data.status.pegawai');
                    Route::get('main-data-pendidikan/{jenis?}/{cabang?}', 'Kepegawaian@main_data_pendidikan')->name('dashboard.kepegawaian.detail.main.pendidikan');
                    Route::get('list-data-pendidikan/{jenis?}/{cabang?}', 'Kepegawaian@list_data_pendidikan')->name('dashboard.kepegawaian.detail.list.data.pendidikan');

                });

                Route::group('notif', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('', 'notif_kepegawaian@index')->name('dashboard.kepegawaian.notif');
                    Route::get('list_data/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{status?}/{jenis_kelamin?}/{id_karyawan?}', 'Notif_kepegawaian@list_data')->name('dashboard.kepegawaian.notif.list-data');
                });
            });
        });

        Route::group('master', function () {

            Route::group('cabang', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('', 'Cabang@index');
                    Route::get('list_data', 'Cabang@list_data');
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/tambah', 'Cabang@form');
                    Route::get('form/edit/{id}', 'Cabang@form');
                    Route::get('form/hapus/{id}', 'Cabang@form');
                    Route::post('save', 'Cabang@save');
                    Route::post('delete', 'Cabang@delete');
                    Route::get('getCabang', 'Cabang@getCabangByName');
                });
            });

            Route::group('lokasi', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4,5'], function () {
                    Route::get('', 'Lokasi@index')->name('master.lokasi.home');
                    Route::get('list_data', 'Lokasi@ajax_list');
                    Route::get('maps/json/{id_cabang?}', 'Lokasi@maps')->name('master.lokasi.maps.json');
                });
                Route::group('', ['middleware' => 'Auth_menu:1,5'], function () {
                    Route::get('tambah', 'Lokasi@tambah')->name('master.lokasi.tambah');
                    Route::get('edit/{id}', 'Lokasi@edit');
                    Route::post('delete', 'Lokasi@delete');
                    Route::post('save', 'Lokasi@insert');
                    Route::post('update', 'Lokasi@update');
                });
            });

            Route::group('departemen', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4,5'], function () {
                    Route::get('', 'Departemen@index');
                    Route::get('list_data', 'Departemen@list_data');
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/tambah', 'Departemen@form');
                    Route::get('form/edit/{id}', 'Departemen@form');
                    Route::get('form/hapus/{id}', 'Departemen@form');
                    Route::post('save', 'Departemen@save');
                    Route::post('delete', 'Departemen@delete');
                });
            });

            Route::group('jabatan', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4,5'], function () {
                    Route::get('', 'Jabatan@index');
                    Route::get('list_data', 'Jabatan@list_data');
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/tambah', 'Jabatan@form');
                    Route::get('form/edit/{id}', 'Jabatan@form');
                    Route::get('form/hapus/{id}', 'Jabatan@form');
                    Route::post('save', 'Jabatan@save');
                    Route::post('delete', 'Jabatan@delete');
                });
            });

            Route::group('shift', ['middleware' => 'Auth_paket:shift'], function () {
                Route::group('', ['middleware' => 'Auth_menu:1,2,4,5,7'], function () {
                    Route::get('', 'Shift@index');
                    Route::get('list_data', 'Shift@list_data')->name('master.shift.listdata');
                });
                Route::group('', ['middleware' => 'Auth_menu:1,5'], function () {
                    Route::get('form/tambah', 'Shift@form')->name('master.shift.form.tambah');
                    Route::get('form/hapus/{id?}/{jenis?}', 'Shift@form')->name('master.shift.form.hapus');
                    Route::get('form/edit/{id?}/{jenis?}', 'Shift@form')->name('master.shift.form.edit');
                    Route::post('save', 'Shift@save')->name('master.shift.save');
                    Route::post('delete', 'Shift@delete')->name('master.shift.delete');
                    Route::post('hapus/jadwal/shift', 'Shift@hapus_jadwal_shift')->name('master.shift.hapus.jadwal');
                });
            });

            Route::group('karyawan', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4,2,5,7'], function () {
                    Route::get('', 'Karyawan@index');
                    Route::get('tabs/{tabs?}', 'Karyawan@tabs')->name('master.karyawan.tabs');
                    Route::get('data/tabs/content/jabatan/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{status?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_jabatan')->name('master.karyawan.tabs.content.jabatan');
                    Route::get('data/tabs/content/pengguna-aktif/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_pengguna_aktif')->name('master.karyawan.tabs.content.pengguna.aktif');
                    Route::get('data/tabs/content/pendidikan/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{pendidikan?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_pendidikan')->name('master.karyawan.tabs.content.pendidikan');
                    Route::get('data/tabs/content/lokasi/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lock_lokasi?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_lokasi')->name('master.karyawan.tabs.content.lokasi');
                    Route::get('data/tabs/content/device/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lock_device?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_device')->name('master.karyawan.tabs.content.device');
                    Route::get('data/tabs/content/facerecognition/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lock_facerecognition?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_facerecognition')->name('master.karyawan.tabs.content.facerecognition');
                    Route::get('data/tabs/content/camera/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{camera?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@data_tabs_camera')->name('master.karyawan.tabs.content.camera');
                    Route::get('detail/{id?}', 'Karyawan@detail')->name('master.karyawan.detail');
                    Route::get('export-pdf/{id}', 'Karyawan@export_pdf');
                    Route::get('view-pdf/{id}', 'Karyawan@view_pdf');
                    Route::get('download/excel/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{status?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download')->name('master.karyawan.download.excel');
                    Route::get('download/pengguna/aktif/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download_pengguna_aktif')->name('master.karyawan.download.pengguna.aktif');
                    Route::get('download/tab/pendidikan/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{pendidikan?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download_tab_pendidikan')->name('master.karyawan.download.tab.pendidikan');
                    Route::get('download/tab/lokasi/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{lokasi?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download_tab_lokasi')->name('master.karyawan.download.tab.lokasi');
                    Route::get('download/tab/device/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{device?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download_tab_device')->name('master.karyawan.download.tab.device');
                    Route::get('download/tab/facerecognition/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{facerecognition?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download_tab_facerecognition')->name('master.karyawan.download.tab.facerecognition');
                    Route::get('download/tab/camera/{jenis?}/{id_cabang?}/{id_departemen?}/{id_jabatan?}/{camera?}/{jenis_kelamin?}/{id_karyawan?}', 'Karyawan@download_tab_camera')->name('master.karyawan.download.tab.camera');
                    Route::group('bagan-organisasi', function () {
                        Route::get('home', 'Bagan_organisasi@index')->name('master.karyawan.bagan.organisasi.home');
                        Route::get('data', 'Bagan_organisasi@data')->name('master.karyawan.bagan.organisasi.data');
                    });
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::post('delete', 'Karyawan@delete')->name('master.karyawan.delete');
                    Route::get('form/tambah', 'Karyawan@form')->name('master.karyawan.tambah');
                    Route::get('home/import', 'Karyawan_import@index')->name("karyawan.import.home");
                    Route::get('unduh/template', 'Karyawan_import@download_template')->name('karyawan.import.download.template');
                    Route::post('excel', 'Karyawan_import@import_data_excel')->name('karyawan.import.excel');
                    Route::get('view-data', 'Karyawan_import@view_data')->name('karyawan.import.viewdata');
                    Route::post('list-data', 'Karyawan_import@list_data')->name('karyawan.import.listdata');
                    Route::delete('delete/all', 'Karyawan_import@delete_all_temp')->name('karyawan.import.deleteall');
                    Route::get('form/temp/edit/{id?}', 'Karyawan_import@form_edit')->name("karyawan.import.form.edit");
                    Route::post('delete/karyawan/import', 'Karyawan_import@delete')->name('karyawan.import.delete');
                    Route::post('save', 'Karyawan_import@save')->name('karyawan.import.save');
                    Route::post('publish/all', 'Karyawan_import@publish_all')->name('karyawan.import.publishall');
                });


                Route::group('data-diri', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4,2,5,7'], function () {
                        Route::get('form', 'Data_diri@index')->name('master.karyawan.datadiri.form');
                        Route::get('detail/{id_karyawan?}', 'Data_diri@detail_datadiri')->name('master.karyawan.datadiri.detail');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/edit/{id?}', 'Data_diri@edit')->name('master.karyawan.datadiri.form.edit');
                        Route::get('edit/{id}', 'Karyawan@data_diri_edit')->name('master.karyawan.datadiri.edit');
                        Route::post('save', 'Data_diri@save')->name('master.karyawan.datadiri.save');
                    });
                    Route::group('pengajuan', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_diri_pengajuan@index')->name('master.karyawan.datadiri.pengajuan.home');
                        Route::get('data/{id_karyawan_md5?}', 'Data_diri_pengajuan@data')->name('master.karyawan.datadiri.pengajuan.data');
                        Route::get('form/{jenis?}', 'Data_diri_pengajuan@form')->name('master.karyawan.datadiri.pengajuan.form');
                        Route::get('approve', 'Data_diri_pengajuan@approve')->name('master.karyawan.datadiri.pengajuan.approve');
                        Route::get('revisi', 'Data_diri_pengajuan@revisi')->name('master.karyawan.datadiri.pengajuan.revisi');
                    });
                    Route::group('histori', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_diri_histori@index')->name('master.karyawan.datadiri.histori.home');
                        Route::get('data/{id_karyawan_md5?}', 'Data_diri_histori@data')->name('master.karyawan.datadiri.histori.data');
                        Route::get('table', 'Data_diri_histori@table')->name('master.karyawan.datadiri.histori.table');
                        Route::get('detail/{id_md5?}', 'Data_diri_histori@detail')->name('master.karyawan.datadiri.histori.detail');
                    });
                });

                Route::group('keluarga', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_keluarga@home')->name('master.karyawan.keluarga.home');
                        Route::get('main/{id_karyawan?}', 'Data_keluarga@main')->name('master.karyawan.keluarga.main');
                        Route::get('data/{id_karyawan?}', 'Data_keluarga@list_data')->name('master.karyawan.keluarga.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah/{id_karyawan?}', 'Data_keluarga@form')->name('master.karyawan.keluarga.form.tambah');
                        Route::get('form/edit/{id_karyawan?}/{id_keluarga?}', 'Data_keluarga@form')->name('master.karyawan.keluarga.form.edit');
                        Route::get('form/delete/{id_karyawan?}/{id_keluarga?}', 'Data_keluarga@form')->name('master.karyawan.keluarga.form.delete');
                        Route::post('save/', 'Data_keluarga@save')->name('master.karyawan.keluarga.save');
                        Route::post('delete/', 'Data_keluarga@delete')->name('master.karyawan.keluarga.delete');
                    });
                    Route::group('pengajuan', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_keluarga_pengajuan@home')->name('master.karyawan.keluarga.pengajuan.home');
                        Route::get('main/{id_karyawan_md5?}', 'Data_keluarga_pengajuan@main')->name('master.karyawan.keluarga.pengajuan.main');
                        Route::get('list_data/{id_karyawan_md5?}', 'Data_keluarga_pengajuan@list_data')->name('master.karyawan.keluarga.pengajuan.list-data');
                        Route::get('form/{jenis?}/{id?}', 'Data_keluarga_pengajuan@form')->name('master.karyawan.keluarga.pengajuan.form');
                        Route::get('approve', 'Data_keluarga_pengajuan@approve')->name('master.karyawan.keluarga.pengajuan.approve');
                        Route::get('revisi', 'Data_keluarga_pengajuan@revisi')->name('master.karyawan.keluarga.pengajuan.revisi');
                        Route::get('hapus', 'Data_keluarga_pengajuan@hapus')->name('master.karyawan.keluarga.pengajuan.hapus');
                    });
                    Route::group('histori', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_keluarga_histori@home')->name('master.karyawan.keluarga.histori.home');
                        Route::get('data/{id_karyawan_md5?}', 'Data_keluarga_histori@data')->name('master.karyawan.keluarga.histori.data');
                        Route::get('table', 'Data_keluarga_histori@table')->name('master.karyawan.keluarga.histori.table');
                        Route::get('detail/{id_md5?}', 'Data_keluarga_histori@detail')->name('master.karyawan.keluarga.histori.detail');
                    });
                });

                Route::group('riwayat-pendidikan', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan?}', 'Riwayat_pendidikan@home')->name('master.karyawan.riwayatpendidikan.home');
                        Route::get('main/{id_karyawan_md5?}', 'Riwayat_pendidikan@main')->name('master.karyawan.riwayatpendidikan.main');
                        Route::get('data/{id_karyawan?}', 'Riwayat_pendidikan@list_data')->name('master.karyawan.riwayatpendidikan.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah/{id_karyawan?}', 'Riwayat_pendidikan@form')->name('master.karyawan.riwayatpendidikan.form.tambah');
                        Route::get('form/edit/{id_karyawan?}/{id_pendidikan?}', 'Riwayat_pendidikan@form')->name('master.karyawan.riwayatpendidikan.form.edit');
                        Route::get('form/delete/{id_karyawan?}/{id_pendidikan?}', 'Riwayat_pendidikan@form')->name('master.karyawan.riwayatpendidikan.form.delete');
                        Route::post('save', 'Riwayat_pendidikan@save')->name('master.karyawan.riwayatpendidikan.save');
                        Route::post('delete', 'Riwayat_pendidikan@delete')->name('master.karyawan.riwayatpendidikan.delete');
                    });
                    Route::group('pengajuan', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Riwayat_pendidikan_pengajuan@home')->name('master.karyawan.pendidikan.pengajuan.home');
                        Route::get('main/{id_karyawan_md5?}', 'Riwayat_pendidikan_pengajuan@main')->name('master.karyawan.pendidikan.pengajuan.main');
                        Route::get('list_data/{id_karyawan_md5?}', 'Riwayat_pendidikan_pengajuan@list_data')->name('master.karyawan.pendidikan.pengajuan.list-data');
                        Route::get('form/{jenis?}/{id?}', 'Riwayat_pendidikan_pengajuan@form')->name('master.karyawan.pendidikan.pengajuan.form');
                        Route::get('approve', 'Riwayat_pendidikan_pengajuan@approve')->name('master.karyawan.pendidikan.pengajuan.approve');
                        Route::get('hapus', 'Riwayat_pendidikan_pengajuan@hapus')->name('master.karyawan.pendidikan.pengajuan.hapus');
                        Route::get('revisi', 'Riwayat_pendidikan_pengajuan@revisi')->name('master.karyawan.pendidikan.pengajuan.revisi');
                    });
                    Route::group('histori', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Riwayat_pendidikan_histori@home')->name('master.karyawan.pendidikan.histori.home');
                        Route::get('data/{id_karyawan_md5?}', 'Riwayat_pendidikan_histori@data')->name('master.karyawan.pendidikan.histori.data');
                        Route::get('table', 'Riwayat_pendidikan_histori@table')->name('master.karyawan.pendidikan.histori.table');
                        Route::get('detail/{id_md5?}', 'Riwayat_pendidikan_histori@detail')->name('master.karyawan.pendidikan.histori.detail');
                    });
                });

                Route::group('pengalaman-kerja', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan?}', 'Pengalaman_kerja@home')->name('master.karyawan.pengalamankerja.home');
                        Route::get('main/{id_karyawan?}', 'Pengalaman_kerja@main')->name('master.karyawan.pengalamankerja.main');
                        Route::get('list-data/{id_karyawan?}', 'Pengalaman_kerja@list_data')->name('master.karyawan.pengalamankerja.listdata');
                        Route::post('list-datatables/{id_karyawan?}', 'Pengalaman_kerja@list_datatables')->name('master.karyawan.pengalamankerja.listdatatables');
                        Route::get('form/detail/{id_riwayat_pekerjaan?}', 'Pengalaman_kerja@detail')->name('master.karyawan.pengalamankerja.form.detail');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah/{id_karyawan?}', 'Pengalaman_kerja@form')->name('master.karyawan.pengalamankerja.form.tambah');
                        Route::get('form/edit/{id_karyawan?}/{id_riwayat_pekerjaan?}', 'Pengalaman_kerja@form')->name('master.karyawan.pengalamankerja.form.edit');;
                        Route::post('save', 'Pengalaman_kerja@save')->name('master.karyawan.pengalamankerja.save');
                        Route::post('delete', 'Pengalaman_kerja@delete')->name('master.karyawan.pengalamankerja.delete');
                    });
                    Route::group('pengajuan', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Pengalaman_kerja_pengajuan@home')->name('master.karyawan.pengalamankerja.pengajuan.home');
                        Route::get('main/{id_karyawan_md5?}', 'Pengalaman_kerja_pengajuan@main')->name('master.karyawan.pengalamankerja.pengajuan.main');
                        Route::get('list_data/{id_karyawan_md5?}', 'Pengalaman_kerja_pengajuan@list_data')->name('master.karyawan.pengalamankerja.pengajuan.list-data');
                        Route::get('form/{jenis?}/{id?}', 'Pengalaman_kerja_pengajuan@form')->name('master.karyawan.pengalamankerja.pengajuan.form');
                        Route::get('revisi', 'Pengalaman_kerja_pengajuan@revisi')->name('master.karyawan.pengalamankerja.pengajuan.revisi');
                        Route::get('approve', 'Pengalaman_kerja_pengajuan@approve')->name('master.karyawan.pengalamankerja.pengajuan.approve');
                        Route::get('hapus', 'Pengalaman_kerja_pengajuan@hapus')->name('master.karyawan.pengalamankerja.pengajuan.hapus');
                    });
                    Route::group('histori', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Pengalaman_kerja_histori@home')->name('master.karyawan.pengalamankerja.histori.home');
                        Route::get('data/{id_karyawan_md5?}', 'Pengalaman_kerja_histori@data')->name('master.karyawan.pengalamankerja.histori.data');
                        Route::get('table', 'Pengalaman_kerja_histori@table')->name('master.karyawan.pengalamankerja.histori.table');
                        Route::get('detail/{id_md5?}', 'Pengalaman_kerja_histori@detail')->name('master.karyawan.pengalamankerja.histori.detail');
                    });
                });

                Route::group('karir-pekerjaan', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan?}', 'Karir_pekerjaan@home')->name('master.karyawan.karirpekerjaan.home');
                        Route::get('main/{id_karyawan?}', 'Karir_pekerjaan@main')->name('master.karyawan.karirpekerjaan.main');
                        Route::get('data/{id_karyawan?}', 'Karir_pekerjaan@list_data')->name('master.karyawan.karirpekerjaan.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah/{id_karyawan?}', 'Karir_pekerjaan@form')->name('master.karyawan.karirpekerjaan.form.tambah');
                        Route::get('form/edit/{id_karyawan?}/{id_karir_pekerjaan?}', 'Karir_pekerjaan@form')->name('master.karyawan.karirpekerjaan.form.edit');
                        Route::get('form/delete/{id_karyawan?}/{id_karir_pekerjaan?}', 'Karir_pekerjaan@form')->name('master.karyawan.karirpekerjaan.form.delete');
                        Route::post('save', 'Karir_pekerjaan@save')->name('master.karyawan.karirpekerjaan.save');
                        Route::post('delete', 'Karir_pekerjaan@delete')->name('master.karyawan.karirpekerjaan.delete');
                    });
                });

                Route::group('sertifikat', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan?}', 'Data_sertifikat@home')->name('master.karyawan.sertifikat.home');
                        Route::get('main/{id_karyawan?}', 'Data_sertifikat@main')->name('master.karyawan.sertifikat.main');
                        Route::get('data/{id_karyawan?}', 'Data_sertifikat@list_data')->name('master.karyawan.sertifikat.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah/{id_karyawan?}', 'Data_sertifikat@form')->name('master.karyawan.sertifikat.form.tambah');
                        Route::get('form/edit/{id_karyawan?}/{id_sertifikat?}', 'Data_sertifikat@form')->name('master.karyawan.sertifikat.form.edit');
                        Route::get('form/delete/{id_karyawan?}/{id_sertifikat?}', 'Data_sertifikat@form')->name('master.karyawan.sertifikat.form.delete');
                        Route::post('save', 'Data_sertifikat@save')->name('master.karyawan.sertifikat.save');
                        Route::post('delete', 'Data_sertifikat@delete')->name('master.karyawan.sertifikat.delete');
                    });
                    Route::group('pengajuan', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_sertifikat_pengajuan@home')->name('master.karyawan.sertifikat.pengajuan.home');
                        Route::get('main/{id_karyawan_md5?}', 'Data_sertifikat_pengajuan@main')->name('master.karyawan.sertifikat.pengajuan.main');
                        Route::get('list_data/{id_karyawan_md5?}', 'Data_sertifikat_pengajuan@list_data')->name('master.karyawan.sertifikat.pengajuan.list-data');
                        Route::get('form/{jenis?}/{id?}', 'Data_sertifikat_pengajuan@form')->name('master.karyawan.sertifikat.pengajuan.form');
                        Route::get('approve', 'Data_sertifikat_pengajuan@approve')->name('master.karyawan.sertifikat.pengajuan.approve');
                        Route::get('hapus', 'Data_sertifikat_pengajuan@hapus')->name('master.karyawan.sertifikat.pengajuan.hapus');
                        Route::get('revisi', 'Data_sertifikat_pengajuan@revisi')->name('master.karyawan.sertifikat.pengajuan.revisi');
                    });
                    Route::group('histori', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_sertifikat_histori@home')->name('master.karyawan.sertifikat.histori.home');
                        Route::get('data/{id_karyawan_md5?}', 'Data_sertifikat_histori@data')->name('master.karyawan.sertifikat.histori.data');
                        Route::get('table', 'Data_sertifikat_histori@table')->name('master.karyawan.sertifikat.histori.table');
                        Route::get('detail/{id_md5?}', 'Data_sertifikat_histori@detail')->name('master.karyawan.sertifikat.histori.detail');
                    });
                });

                Route::group('akun', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan?}', 'Data_akun@index')->name('master.karyawan.akun.home');
                        Route::get('data/{id_karyawan?}', 'Data_akun@list_data')->name('master.karyawan.akun.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::group('form', function () {
                            Route::get('kamera', 'Data_akun@form_kamera')->name('master.karyawan.akun.form.kamera');
                            Route::get('reset', 'Data_akun@form_reset')->name('master.karyawan.akun.form.reset');
                            Route::get('edit/{id_karyawan?}/{id_akun?}', 'Data_akun@form')->name('master.karyawan.akun.form.edit');
                        });
                        Route::post('save', 'Data_akun@save')->name('master.karyawan.akun.save');
                        Route::post('deviceid/reset', 'Data_akun@reset_deviceid')->name('master.karyawan.akun.reset.deviceid');
                        Route::post('facerecognition/reset', 'Data_akun@reset_facerecognition')->name('master.karyawan.akun.reset.facerecognition');
                        Route::post('kamera/save', 'Data_akun@save_camera')->name('master.karyawan.akun.kamera.save');
                    });
                });

                Route::group('kelengkapan-file', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('home/{id_karyawan?}', 'Data_kelengkapan_file@home')->name('master.karyawan.kelengkapanfile.home');
                        Route::get('main/{id_karyawan?}', 'Data_kelengkapan_file@main')->name('master.karyawan.kelengkapanfile.main');
                        Route::get('data/{id_karyawan?}', 'Data_kelengkapan_file@list_data')->name('master.karyawan.kelengkapanfile.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah/{id_karyawan?}', 'Data_kelengkapan_file@form')->name('master.karyawan.kelengkapanfile.form.tambah');
                        Route::get('form/edit/{id_karyawan?}/{id_file?}', 'Data_kelengkapan_file@form')->name('master.karyawan.kelengkapanfile.form.edit');
                        Route::get('form/delete/{id_karyawan?}/{id_file?}', 'Data_kelengkapan_file@form')->name('master.karyawan.kelengkapanfile.form.delete');
                        Route::post('save', 'Data_kelengkapan_file@save')->name('master.karyawan.kelengkapanfile.save');
                        Route::post('delete', 'Data_kelengkapan_file@delete')->name('master.karyawan.kelengkapanfile.delete');
                    });
                    Route::group('pengajuan', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_kelengkapan_file_pengajuan@home')->name('master.karyawan.kelengkapanfile.pengajuan.home');
                        Route::get('main/{id_karyawan_md5?}', 'Data_kelengkapan_file_pengajuan@main')->name('master.karyawan.kelengkapanfile.pengajuan.main');
                        Route::get('list_data/{id_karyawan_md5?}', 'Data_kelengkapan_file_pengajuan@list_data')->name('master.karyawan.kelengkapanfile.pengajuan.list-data');
                        Route::get('form/{jenis?}/{id?}', 'Data_kelengkapan_file_pengajuan@form')->name('master.karyawan.kelengkapanfile.pengajuan.form');
                        Route::get('approve', 'Data_kelengkapan_file_pengajuan@approve')->name('master.karyawan.kelengkapanfile.pengajuan.approve');
                        Route::get('hapus', 'Data_kelengkapan_file_pengajuan@hapus')->name('master.karyawan.kelengkapanfile.pengajuan.hapus');
                        Route::get('revisi', 'Data_kelengkapan_file_pengajuan@revisi')->name('master.karyawan.kelengkapanfile.pengajuan.revisi');
                    });
                    Route::group('histori', ['middleware' => 'Auth_menu:1', 'namespace' => 'karyawan_approval'], function () {
                        Route::get('home/{id_karyawan_md5?}', 'Data_kelengkapan_file_histori@home')->name('master.karyawan.kelengkapanfile.histori.home');
                        Route::get('data/{id_karyawan_md5?}', 'Data_kelengkapan_file_histori@data')->name('master.karyawan.kelengkapanfile.histori.data');
                        Route::get('table', 'Data_kelengkapan_file_histori@table')->name('master.karyawan.kelengkapanfile.histori.table');
                        Route::get('detail/{id_md5?}', 'Data_kelengkapan_file_histori@detail')->name('master.karyawan.kelengkapanfile.histori.detail');
                    });
                });

                Route::group('payroll', ['namespace' => 'karyawan_detail'], function () {
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('home/{id_karyawan?}', 'Payroll@index')->name('master.karyawan.payroll.home');

                        // informasi karyawan
                        Route::get('informasi-karyawan/{id_karyawan}', 'Informasi_karyawan@index')->name('master.karyawan.payroll.informasi_karyawan');
                        Route::get('informasi-karyawan/form/{column}/{id_karyawan}', 'Informasi_karyawan@form')->name('master.karyawan.payroll.informasi_karyawan.form');
                        Route::post('informasi-karyawan/save', 'Informasi_karyawan@save')->name('master.karyawan.payroll.informasi_karyawan.save');

                        // informasi bank
                        Route::get('informasi-bank/{id_karyawan}', 'Informasi_bank@index')->name('master.karyawan.payroll.informasi_bank');
                        Route::get('informasi-bank/form/{column}/{id_karyawan}', 'Informasi_bank@form')->name('master.karyawan.payroll.informasi_bank.form');
                        Route::post('informasi-bank/save', 'Informasi_bank@save')->name('master.karyawan.payroll.informasi_bank.save');

                        // informasi lembur
                        Route::get('informasi-lembur/{id_karyawan}', 'Informasi_lembur@index')->name('master.karyawan.payroll.informasi_lembur');
                        Route::get('informasi-lembur/form/{column}/{id_karyawan}', 'Informasi_lembur@form')->name('master.karyawan.payroll.informasi_lembur.form');
                        Route::post('informasi-lembur/save', 'Informasi_lembur@save')->name('master.karyawan.payroll.informasi_lembur.save');

                        // informasi gaji
                        Route::get('informasi-gaji/{id_karyawan}', 'Informasi_gaji@index')->name('master.karyawan.payroll.informasi_gaji');
                        Route::get('informasi-gaji/form/{column}/{id_karyawan}', 'Informasi_gaji@form')->name('master.karyawan.payroll.informasi_gaji.form');
                        Route::get('informasi-gaji/form/komponen', 'Informasi_gaji@form_komponen')->name('master.karyawan.payroll.informasi_gaji.form_komponen');
                        Route::post('informasi-gaji/save', 'Informasi_gaji@save')->name('master.karyawan.payroll.informasi_gaji.save');
                        Route::post('informasi-gaji/save-komponen', 'Informasi_gaji@save_komponen')->name('master.karyawan.payroll.informasi_gaji.save_komponen');

                        // informasi gaji
                        Route::get('informasi-tunj-perusahaan/{id_karyawan}', 'Informasi_tunj_perusahaan@index')->name('master.karyawan.payroll.informasi_tunj_perusahaan');
                    });
                });
            });

            Route::group('jenis-izin', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('home', 'Jenis_izin@index')->name('master.jenisizin.home');
                    Route::get('list_data', 'Jenis_izin@list_data')->name('master.jenisizin.listdata');
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/tambah', 'Jenis_izin@form')->name('master.jenisizin.form.tambah');
                    Route::get('form/edit/{id_izin?}', 'Jenis_izin@form')->name('master.jenisizin.form.edit');
                    Route::get('form/hapus/{id_izin?}', 'Jenis_izin@form')->name('master.jenisizin.form.hapus');
                    Route::post('save', 'Jenis_izin@save')->name('master.jenisizin.save');
                    Route::post('delete', 'Jenis_izin@delete')->name('master.jenisizin.delete');
                });
            });

            Route::group('saldo-cuti', function () {
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('', 'Saldo_cuti@index')->name('master.saldocuti.index');
                    Route::get('list_data/{cabang}/{departemen}', 'Saldo_cuti@list_data')->name('master.saldocuti.listdata');
                    Route::get('form/tambah', 'Saldo_cuti@form')->name('master.saldocuti.form.tambah');
                    Route::get('form/edit/{id_izin?}', 'Saldo_cuti@form')->name('master.saldocuti.form.edit');
                    Route::get('form/hapus/{id_izin?}', 'Saldo_cuti@form')->name('master.saldocuti.form.hapus');
                    Route::post('save', 'Saldo_cuti@save')->name('master.saldocuti.save');
                    Route::post('delete', 'Saldo_cuti@delete')->name('master.saldocuti.delete');
                    Route::get('download/{cabang}/{departemen}', 'Saldo_cuti@download')->name('master.saldocuti.download');
                });
                Route::group('detail', function () {
                    Route::get('/{id_karyawan}', 'History_cuti@index')->name('history.cuti.index');
                    Route::get('list-data/{jenis}/{id_karyawan}', 'History_cuti@list_data')->name('history.cuti.listdata');
                    Route::get('terpakai-list-data/{jenis}/{id_karyawan}', 'History_cuti@list_data_terpakai')->name('history.cuti.listdata.terpakai');
                    Route::get('form/tambah', 'History_cuti@form')->name('history.cuti.form.tambah');
                    Route::post('save', 'History_cuti@save')->name('history.cuti.save');
                });
            });
        });

        //PENGATURAN
        Route::group('pengaturan', function () {
            Route::group('perusahaan', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4,6'], function () {
                    Route::get('', 'Pengaturan_perusahaan@index');
                    Route::get('invoice-pdf/{id}', 'Pengaturan_perusahaan@invoice_pdf');
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('logo/form/edit/{id_company?}', 'Pengaturan_perusahaan@form')->name('pengaturan.perusahaan.logo.form.edit');
                    Route::post('logo/save', 'Pengaturan_perusahaan@save_profil')->name('pengaturan.perusahaan.logo.save');
                });
            });
            Route::group('umum', function () {
                Route::get('', 'Pengaturan_umum@index', ['middleware' => 'Auth_menu:1,4'])->name('pengaturan.umum.home');
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::post('save', 'Pengaturan_umum@save')->name('pengaturan.umum.save');
                    Route::get('form/cuti/{id_cuti_p?}', 'Pengaturan_umum@form_cuti')->name('pengaturan.umum.form.cuti');
                    Route::post('save/cuti', 'Pengaturan_umum@reset_cuti')->name('pengaturan.umum.save.cuti');
                    Route::post('notif-absensi/save', 'Pengaturan_umum@notif_absensi_save')->name('pengaturan.umum.notif.absensi.save');
                });
            });

            Route::group('jam-kerja', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4,5'], function () {
                    Route::get('', 'Jadwal_kerja@index')->name('pengaturan.jamkerja.home');
                    Route::get('data', 'Jadwal_kerja@list_data')->name('pengaturan.jamkerja.listdata');
                    Route::get('detail/{id_cabang?}', 'Jadwal_kerja@detail')->name('pengaturan.jamkerja.detail');
                    Route::post('jadwal', 'Jadwal_kerja@jam_kerja')->name('pengaturan.jamkerja.jadwal');
                });
                Route::post('update', 'Jadwal_kerja@update', ['middleware' => 'Auth_menu:1'])->name('pengaturan.jamkerja.update');
            });

            Route::group('shift', ['middleware' => 'Auth_paket:shift'], function () {
                Route::group('', ['middleware' => 'Auth_menu:1,2,4,5,7'], function () {
                    Route::get('', 'Pengaturan_shift@index')->name("pengaturan.shift.home");
                    Route::get('form/{jenis?}/{id?}', 'Pengaturan_shift@form')->name('pengaturan.shift.form');
                    Route::post('edit', 'Pengaturan_shift@edit')->name('pengaturan.shift.edit');
                    Route::post('delete', 'Pengaturan_shift@delete')->name('pengaturan.shift.delete');
                    Route::post('save', 'Pengaturan_shift@save');

                    Route::get('tambah', 'Pengaturan_shift@form');
                    Route::get('edit/{id}', 'Pengaturan_shift@edit');

                    Route::post('update', 'Pengaturan_shift@save_lawas');
                    Route::post('import', 'Pengaturan_shift@import');
                    Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengaturan_shift@view_data')->name('pengaturan.shift.data.view');
                    Route::get('data/list/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengaturan_shift@list_data')->name('pengaturan.shift.data.list');
                });

                Route::group('import', ['middleware' => 'Auth_menu:1,2,4,5,7'], function () {
                    Route::get('home', 'Pengaturan_shift_import@index')->name("pengaturan.shift.import.home");
                    Route::get('view-data', 'Pengaturan_shift_import@view_data')->name('pengaturan.shift.import.viewdata');
                    Route::post('list-data', 'Pengaturan_shift_import@list_data')->name('pengaturan.shift.import.listdata');
                    Route::get('unduh/template/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}', 'Pengaturan_shift_import@download_template')->name('pengaturan.shift.import.unduh.tempate');
                    Route::post('excel', 'Pengaturan_shift_import@import_data_excel')->name('pengaturan.shift.import.excel');
                    Route::get('form/edit/{id?}', 'Pengaturan_shift_import@form_edit')->name('pengaturan.shift.import.form.edit');
                    Route::get('form/template-import', 'Pengaturan_shift_import@form_template_import')->name('pengaturan.shift.import.form.templateimport');
                    Route::post('update', 'Pengaturan_shift_import@update')->name('pengaturan.shift.import.update');
                    Route::post('delete', 'Pengaturan_shift_import@delete_temp')->name('pengaturan.shift.import.delete');
                    Route::post('publish/all', 'Pengaturan_shift_import@publish_all')->name('pengaturan.shift.import.publishall');
                    Route::delete('delete/all', 'Pengaturan_shift_import@delete_all_temp')->name('pengaturan.shift.import.deleteall');
                });
            });

            Route::group('kepala-cabang', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('', 'Kepala_cabang@index')->name("pengaturan.kepalacabang.home");
                    Route::get('data', 'Kepala_cabang@list_data')->name("pengaturan.kepalacabang.data");
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/edit/{id?}', 'Kepala_cabang@form')->name("pengaturan.kepalacabang.form.edit");
                    Route::post('update', 'Kepala_cabang@update')->name("pengaturan.kepalacabang.update");
                });
            });

            Route::group('kepala-departemen', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('', 'Kepala_departemen@index')->name("pengaturan.kepaladepartemen.home");
                    Route::get('data', 'Kepala_departemen@list_data')->name("pengaturan.kepaladepartemen.data");
                });
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/edit/{id_karyawan?}', 'Kepala_departemen@form')->name("pengaturan.kepaladepartemen.form.edit");
                    Route::post('update', 'Kepala_departemen@update')->name("pengaturan.kepaladepartemen.update");
                });
            });

            # Pengaturan Admin
            Route::group('admin', ['namespace' => 'pengaturan/admin',  'middleware' => ['Auth_menu:1:4', 'Auth_is_not_adm_absensi']], function () {
                Route::get('home', 'Home@index')->name('pengaturan.admin.home');
                
                // 1. Admin Absensi
                Route::group('absensi', function () {
                    Route::get('home', 'Adm_absensi@index')->name('pengaturan.admin.absensi.home');
                    Route::get('list-data', 'Adm_absensi@list_data')->name('pengaturan.admin.absensi.list.data');
                    Route::get('form/tambah', 'Adm_absensi@form')->name('pengaturan.admin.absensi.form.tambah');
                    Route::get('form/hapus/{id?}', 'Adm_absensi@form')->name('pengaturan.admin.absensi.form.hapus');
                    Route::post('save', 'Adm_absensi@save')->name('pengaturan.admin.absensi.save');
                    Route::post('delete', 'Adm_absensi@delete')->name('pengaturan.admin.absensi.delete');
                });

                // 2. Admin Reimbursement
                Route::group('reimburse', ['middleware' => 'Auth_paket:reimburse', 'Auth_reimbursement'], function () {
                    Route::get('home', 'Adm_reimburse@index')->name('pengaturan.admin.reimburse.home');
                    Route::get('data', 'Adm_reimburse@list_data')->name("pengaturan.admin.reimburse.data");
                    Route::get('form/tambah', 'Adm_reimburse@form')->name("pengaturan.admin.reimburse.form.tambah");
                    Route::get('form/edit/{id?}', 'Adm_reimburse@form')->name("pengaturan.admin.reimburse.form.edit");
                    Route::get('form/hapus/{id?}', 'Adm_reimburse@form_delete')->name("pengaturan.admin.reimburse.form.hapus");
                    Route::post('save', 'Adm_reimburse@save')->name("pengaturan.admin.reimburse.save");
                    Route::post('delete', 'Adm_reimburse@delete')->name("pengaturan.admin.reimburse.delete");
                });

                // 3. Admin Payroll
                Route::group('payroll', ['middleware' => 'Auth_paket:payroll'], function () {
                    Route::get('home', 'Adm_payroll@index')->name('pengaturan.admin.payroll.home');
                    Route::get('list-data', 'Adm_payroll@list_data')->name('pengaturan.admin.payroll.list.data');
                    Route::get('form/tambah', 'Adm_payroll@form')->name('pengaturan.admin.payroll.form.tambah');
                    Route::get('form/hapus/{id?}', 'Adm_payroll@form')->name('pengaturan.admin.payroll.form.hapus');
                    Route::post('save', 'Adm_payroll@save')->name('pengaturan.admin.payroll.save');
                    Route::post('delete', 'Adm_payroll@delete')->name('pengaturan.admin.payroll.delete');
                });
            });

            # Pengaturan Approval
            Route::group('approval', ['namespace' => 'pengaturan/approval'], function () {
                Route::get('home', 'Home@index')->name('pengaturan.approval.home');

                Route::group('izin', function () {
                    // 1. Approval Izin
                    Route::group('', ['middleware' => ['Auth_menu:1,4', 'Auth_paket:cuti']], function () {
                        Route::get('', 'Pengaturan_izin@index')->name('pengaturan.izin.home');
                        Route::get('data', 'Pengaturan_izin@list_data')->name('pengaturan.izin.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::post('save', 'Pengaturan_izin@save')->name('pengaturan.izin.save');
                        Route::get('get-atasan/{id}', 'Pengaturan_izin@get_atasan');
                    });
                });

                // 2. Approval Lembur
                Route::group('lembur', ['middleware' => ['Auth_paket:lembur']], function () {
                    Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                        Route::get('', 'Pengaturan_lembur@index')->name('pengaturan.lembur.home');
                        Route::get('data', 'Pengaturan_lembur@list_data')->name('pengaturan.lembur.data');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::post('save', 'Pengaturan_lembur@save')->name('pengaturan.lembur.save');
                        Route::get('get-atasan/{id}', 'Pengaturan_lembur@get_atasan');
                    });
                });

                // 3. Approval Reimbursement
                Route::group('reimbursement', ['middleware' => ['Auth_menu:1,4,6', 'Auth_paket:reimburse', 'Auth_reimbursement']], function () {
                    Route::get('', 'Pengaturan_reimbursement@index')->name('pengaturan.reimbursement.home');
                    Route::get('data', 'Pengaturan_reimbursement@list_data')->name('pengaturan.reimbursement.data');
                    Route::get('get-atasan/{id}', 'Pengaturan_reimbursement@get_atasan');
                    Route::post('save', 'Pengaturan_reimbursement@save')->name('pengaturan.reimbursement.save');
                });
            });

            Route::group('atasan-khusus', function () {
                Route::get('', 'Atasan_khusus@index');
                Route::post('list-data', 'Atasan_khusus@list_data');
                Route::get('form/tambah', 'Atasan_khusus@form');
                Route::get('form/edit/{id}', 'Atasan_khusus@form');
                Route::get('form/hapus/{id}', 'Atasan_khusus@form');
                Route::post('save', 'Atasan_khusus@save');
                Route::post('delete', 'Atasan_khusus@delete');
                Route::get('get-atasan/{id}', 'Atasan_khusus@get_atasan');
            });

            Route::group('hari-libur', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('', 'Kalender@index');
                    Route::get('list_data', 'Kalender@list_data');
                    Route::get('view/thumbnail', 'Kalender@kalender_data')->name("pengaturan.harilibur.view.thumbnail");
                    Route::get('view/list', 'Kalender@view_data')->name('pengaturan.harilibur.view.list');
                });
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('export/{id}', 'Kalender@export')->name('pengaturan.harilibur.export');
                    Route::get('form/tambah', 'Kalender@form')->name('pengaturan.harilibur.form.tambah');
                    Route::get('form/edit/{id}', 'Kalender@form')->name('pengaturan.harilibur.form.edit');
                    Route::get('form/hapus/{id}', 'Kalender@form')->name('pengaturan.harilibur.form.hapus');
                    Route::post('save', 'Kalender@save')->name('pengaturan.harilibur.save');
                    Route::post('update', 'Kalender@update')->name('pengaturan.harilibur.update');
                    Route::post('delete', 'Kalender@delete')->name('pengaturan.harilibur.delete');
                    Route::post('delete-holiday', 'Kalender@delete_holiday')->name('pengaturan.harilibur.delete_holiday');
                    Route::get('cek-tanggal', 'Kalender@cek_tanggal')->name('pengaturan.harilibur.cek_tanggal');
                    Route::post('import', 'Kalender@import')->name('pengaturan.harilibur.import');
                });
            });
        });
        //END PENGATURAN

        // START KELOLA ABSENSI
        Route::group('absensi', function () {
            Route::get('home', 'Data_absensi@index')->name('laporan.absensi.home');
            Route::get('dropdown/cabang', 'Data_absensi@list_cabang')->name('laporan.absensi.dropdown.cabang');
            Route::get('dropdown/departemen/{id?}', 'Data_absensi@list_departemen')->name('laporan.absensi.dropdown.departemen');
            Route::get('dropdown/karyawan', 'Data_absensi@list_karyawan')->name('laporan.absensi.dropdown.karyawan');
            Route::get('data/download', 'Data_absensi@download')->name('laporan.absensi.download');
            Route::get('data/view', 'Data_absensi@view_data')->name('laporan.absensi.data.view');
            Route::get('data/list', 'Data_absensi@list_data')->name('laporan.absensi.data.list');
            Route::get('lokasi/{jenis?}/{tanggal?}/{karyawan?}', 'Data_absensi@lokasi');
            Route::get('form', 'Data_absensi@form');
            Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                Route::get('form/edit/{id_karyawan?}/{tanggal?}', 'Data_absensi@form');
                Route::post('save', 'Data_absensi@save');
                Route::post('update', 'Data_absensi@update');
                Route::post('delete/{id_karyawan?}/{tanggal?}', 'Data_absensi@delete');
                Route::post('delete_pulang/{id_karyawan?}/{tanggal?}', 'Data_absensi@delete_pulang');
            });
            Route::get('absensi/list/cabang_selected', 'Data_absensi@list_cabang_selected');
        });

        Route::group('rekap', function () {
            Route::group('absensi', function () {
                Route::get('data', 'Rekap_absensi@index');
                Route::get('list/cabang', 'Rekap_absensi@list_cabang');
                Route::get('list/departemen/{id?}', 'Rekap_absensi@list_departemen');
                Route::get('data/download/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}/{jenis?}', 'Rekap_absensi@download');
                Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}', 'Rekap_absensi@view_data')->name('rekap.absensi.data.view');
                Route::post('list/data/{tgl_mulai?}/{tgl_selesai?}/{id_cabang?}/{id_departemen?}', 'Rekap_absensi@list_data');
            });
        });

        Route::group('pengajuan', function () {
            Route::group('lembur', ['middleware' => ['Auth_paket:lembur']], function () {
                Route::get('', 'Pengajuan_lembur@index');
                Route::get('approve_data', 'Pengajuan_lembur@approve_data');

                Route::get('detail_lembur/{id}', 'Pengajuan_lembur@detail_lembur');
                Route::get('detail-lembur-mulai/{id}', 'Pengajuan_lembur@detail_lembur_mulai');
                Route::get('detail-lembur-selesai/{id}', 'Pengajuan_lembur@detail_lembur_selesai');

                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('tambah', 'Pengajuan_lembur@form');
                    Route::get('edit/{id}', 'Pengajuan_lembur@edit');
                    Route::get('save', 'Pengajuan_lembur@save');
                    Route::get('update', 'Pengajuan_lembur@update');
                    Route::post('delete/{id_lemmulai?}/{status?}/{id_karyawan?}/{tgl_absen?}/{jam_lembur_mulai?}', 'Pengajuan_lembur@delete');
                    Route::get('import', 'Pengajuan_lembur@import');
                });

                Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengajuan_lembur@view_data')->name('pengajuan.lembur.data.view');
                Route::get('data/list/{tgl_mulai?}/{tgl_selesai?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengajuan_lembur@list_data')->name('pengajuan.lembur.data.list');
                Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengajuan_lembur@download')->name('pengajuan.lembur.data.download.excel');

                Route::get('verifikasi/{id}', 'Pengajuan_lembur@modal');
                Route::get('verifikasi/spv/{id}', 'Pengajuan_lembur@modal');
                Route::get('verifikasi/kedep/{id}', 'Pengajuan_lembur@modal');
                Route::get('verifikasi/kacab/{id}', 'Pengajuan_lembur@modal');
                Route::get('verifikasi/hrd/{id}', 'Pengajuan_lembur@modal');
                Route::get('verifikasi/direksi/{id}', 'Pengajuan_lembur@modal');

                Route::post('approve', 'Pengajuan_lembur@approve');
                Route::post('approve-spv', 'Pengajuan_lembur@approve_spv');
                Route::post('approve-kedep', 'Pengajuan_lembur@approve_kedep');
                Route::post('approve-kacab', 'Pengajuan_lembur@approve_kacab');
                Route::post('approve-hrd', 'Pengajuan_lembur@approve_hrd');
                Route::post('approve-direksi', 'Pengajuan_lembur@approve_direksi');

                Route::get('get-jenis', 'Pengajuan_lembur@get_jenis');
                Route::get('get-jenis-form', 'Pengajuan_lembur@get_jenis_form');
                Route::get('get-cabang', 'Pengajuan_lembur@get_cabang');
                Route::get('get-departemen/{id_cabang}', 'Pengajuan_lembur@get_departemen');
                Route::get('get-karyawan/{id_cabang}/{id_departemen}', 'Pengajuan_lembur@get_karyawan');
                Route::get('dropdown/karyawan', 'Pengajuan_lembur@list_karyawan')->name('pengajuan.lembur.dropdown.karyawan');

                Route::get('data-lembur/{id}', 'Pengajuan_lembur@data_lembur');
            });

            Route::group('izin', function () {
                Route::get('home', 'Pengajuan_izin@index')->name('pengajuan.izin.home');
                Route::get('approve_data', 'Pengajuan_izin@approve_data');
                Route::get('get_holidays', 'Pengajuan_izin@get_holidays');
                Route::get('flag-cuti', 'Pengajuan_izin@get_flag_cuti')->name('pengajuan.izin.flag.cuti');
                Route::get('get-absensi', 'Pengajuan_izin@is_absensi_masuk')->name('pengajuan.izin.cek.absensi');
                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('tambah', 'Pengajuan_izin@form');
                    Route::get('edit/{id}', 'Pengajuan_izin@edit');
                    Route::post('save', 'Pengajuan_izin@save');
                    Route::post('update', 'Pengajuan_izin@update');
                    Route::post('delete', 'Pengajuan_izin@delete');
                    Route::get('import', 'Pengajuan_izin@import');
                });
                Route::get('detail/{id}', 'Pengajuan_izin@detail');

                Route::get('detail_izin/{id}', 'Pengajuan_izin@detail_izin');

                Route::get('data/view/{tgl_mulai?}/{tgl_selesai?}/{jenis?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengajuan_izin@view_data')->name('pengajuan.izin.data.view');
                Route::get('data/list/{tgl_mulai?}/{tgl_selesai?}/{jenis?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengajuan_izin@list_data')->name('pengajuan.izin.data.list');

                Route::get('modal/verifikasi/{level_verifikasi?}/{id_izin?}', 'Pengajuan_izin@modal_verifikasi')->name('pengajuan.izin.modal.verifikasi');
                Route::get('verifikasi/spv/{id}', 'Pengajuan_izin@modal_spv');

                Route::post('approve', 'Pengajuan_izin@approve_izin')->name('pengajuan.izin.approve');

                Route::get('get-jenis', 'Pengajuan_izin@get_jenis');
                Route::get('get-jenis-form', 'Pengajuan_izin@get_jenis_form');
                Route::get('get-cabang', 'Pengajuan_izin@get_cabang');
                Route::get('get-departemen/{id_cabang}', 'Pengajuan_izin@get_departemen');
                Route::get('get-karyawan/{id_cabang}/{id_departemen}', 'Pengajuan_izin@get_karyawan');

                Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{jenis?}/{status?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Pengajuan_izin@download')->name('pengajuan.izin.data.download.excel');

            });
        });

        Route::group('laporan', function () {
            Route::group('aktivitas', ['middleware' => ['Auth_paket:aktivitas']], function () {
                Route::get('', 'Laporan_aktivitas@index');
                Route::get('detail/{id?}', 'Laporan_aktivitas@detail')->name('laporan.aktivitas.detail');
                Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Laporan_aktivitas@download_excel')->name('laporan.aktivitas.download.excel');
                Route::get('data/tabel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/', 'Laporan_aktivitas@data_tabel')->name('laporan.aktivitas.data.tabel');
                Route::get('data/maps/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/', 'Laporan_aktivitas@data_maps')->name('laporan.aktivitas.data.maps');
                Route::get('data/maps/lokasi/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/', 'Laporan_aktivitas@lokasi_aktivitas')->name('laporan.aktivitas.data.maps.lokasi');

                Route::get('list-data/ajax', 'Laporan_aktivitas@list_data')->name('laporan.aktivitas.listdata');
                Route::get('list-data/ajax/rekap', 'Laporan_aktivitas@rekap_aktifitas')->name('laporan.aktivitas.listrekap');
                Route::post('delete', 'Laporan_aktivitas@delete')->name('laporan.aktivitas.delete');
            });
        });
        // //LAPORAN

        // //INFORMASI
        Route::group('informasi', function () {

            Route::group('berita', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('', 'Berita@index')->name('informasi.berita.home');
                    Route::get('list-data', 'Berita@list_data')->name('informasi.berita.listdata');
                    Route::get('detail/{id?}', 'Berita@detail')->name('informasi.berita.detail');
                });

                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::post('save', 'Berita@save')->name('informasi.berita.save');
                    Route::post('delete', 'Berita@delete')->name('informasi.berita.delete');
                    Route::get('form/tambah', 'Berita@form')->name('informasi.berita.form.tambah');
                    Route::get('form/edit/{id?}', 'Berita@form')->name('informasi.berita.form.edit');
                });
            });

            Route::group('pengumuman', function () {
                Route::group('', ['middleware' => 'Auth_menu:1,4'], function () {
                    Route::get('', 'Pengumuman@index')->name('informasi.pengumuman.home');
                    Route::get('data', 'Pengumuman@list_data')->name('informasi.pengumuman.data');
                    Route::get('detail/{id?}', 'Pengumuman@detail')->name('informasi.pengumuman.detail');
                });

                Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                    Route::get('form/tambah', 'Pengumuman@form')->name('informasi.pengumuman.form.tambah');
                    Route::get('form/edit/{id?}', 'Pengumuman@form')->name('informasi.pengumuman.form.edit');
                    Route::post('save', 'Pengumuman@save')->name('informasi.pengumuman.save');
                    Route::post('delete', 'Pengumuman@delete')->name('informasi.pengumuman.delete');
                });
            });

            // //GAJI
            Route::group('gaji', function () {
                Route::group('', ['middleware' => 'Auth_menu:4,6'], function () {
                    Route::get('', 'Informasi_gaji@index')->name('informasi.gaji.home');
                    Route::get('list-data/{periode?}/{id_karyawan?}/{kode_cabang?}/{kode_departemen?}', 'Informasi_gaji@list_data')->name('informasi.gaji.listdata');
                    Route::get('download/{periode}/{cabang}/{departemen}', 'Informasi_gaji@download');
                    Route::get('detail/{id?}', 'Informasi_gaji@detail')->name("informasi.gaji.detail");
                });

                Route::group('', ['middleware' => 'Auth_menu:6'], function () {
                    Route::get('edit/{id?}', 'Informasi_gaji@edit')->name("informasi.gaji.edit");
                    Route::post('update', 'Informasi_gaji@update')->name("informasi.gaji.update");
                    Route::post('delete', 'Informasi_gaji@delete')->name("informasi.gaji.delete");
                    Route::get('form/publish/{id?}', 'Informasi_gaji@form_publish')->name("informasi.gaji.form.publish");
                    Route::post('publish-unpublish', 'Informasi_gaji@publish_unpublish')->name("informasi.gaji.publishunpublish");
                    Route::post('unpublish', 'Informasi_gaji@unpublish')->name("informasi.gaji.unpublish");
                    Route::post('publis-all', 'Informasi_gaji@publish_all')->name("informasi.gaji.publishall");
                    Route::post('unpublish-all', 'Informasi_gaji@unpublish_all')->name("informasi.gaji.unpublishall");

                    Route::group('import', function () {
                        Route::get('home', 'Informasi_gaji_temp@index')->name('informasi.gaji.import.home');
                        Route::get('list-data', 'Informasi_gaji_temp@list_data')->name('informasi.gaji.import.listdata');
                        Route::get('unduh/template-gaji/{periode?}/{cabang?}/{departemen?}', 'Template_informasi_gaji@download')->name('informasi.gaji.unduh.templateimport');
                        Route::post('excel', 'Informasi_gaji_temp@import_data_excel')->name('informasi.gaji.import.excel');
                        Route::get('form/edit/{id?}', 'Informasi_gaji_temp@form_edit')->name('informasi.gaji.import.form.edit');
                        Route::get('form/template-import', 'Informasi_gaji_temp@form_template_import')->name('informasi.gaji.form.templateimport');
                        Route::post('update', 'Informasi_gaji_temp@update')->name('informasi.gaji.import.update');
                        Route::post('delete', 'Informasi_gaji_temp@delete_temp')->name('informasi.gaji.import.delete');
                        Route::post('save-all', 'Informasi_gaji_temp@save_all')->name('informasi.gaji.import.saveall');
                        Route::post('delete-all', 'Informasi_gaji_temp@delete_all')->name('informasi.gaji.import.deleteall');
                    });
                });

                Route::group('dropdown', function () {
                    Route::get('cabang', 'Informasi_gaji@dropdown_cabang')->name("informasi.gaji.dropdown.cabang");
                    Route::get('departemen/{kode_cabang?}', 'Informasi_gaji@dropdown_departemen')->name("informasi.gaji.dropdown.departemen");
                    Route::get('karyawan', 'Informasi_gaji@dropdown_karyawan')->name("informasi.gaji.dropdown.karyawan");
                });

                // //GAJI
            });
        });
        // //INFORMASi

        // //REIMBURSEMENT
        Route::group('reimburse', ['middleware' => 'Auth_paket:reimburse'], function () {
            Route::group('', ['middleware' => 'Auth_reimbursement'], function () {

                Route::group('plafon', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('home', 'Jenis_plafon@index')->name('master.jenisplafon.home');
                        Route::get('list-data', 'Jenis_plafon@list_data')->name('master.jenisplafon.listdata');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah', 'Jenis_plafon@form')->name('master.jenisplafon.form.tambah');
                        Route::get('form/edit/{id?}', 'Jenis_plafon@form')->name('master.jenisplafon.form.edit');
                        Route::get('form/hapus/{id?}', 'Jenis_plafon@form')->name('master.jenisplafon.form.hapus');
                        Route::post('save', 'Jenis_plafon@save')->name('master.jenisplafon.save');
                        Route::post('delete', 'Jenis_plafon@delete')->name('master.jenisplafon.delete');
                    });
                });

                Route::group('akun', function () {
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('home', 'Akun_reimburse@index')->name('master.akun.home');
                        Route::get('list-data', 'Akun_reimburse@list_data')->name('master.akun.listdata');
                    });
                    Route::group('', ['middleware' => 'Auth_menu:1'], function () {
                        Route::get('form/tambah', 'Akun_reimburse@form')->name('master.akun.form.tambah');
                        Route::get('form/edit/{id?}', 'Akun_reimburse@form')->name('master.akun.form.edit');
                        Route::get('form/hapus/{id?}', 'Akun_reimburse@form')->name('master.akun.form.hapus');
                        Route::post('save', 'Akun_reimburse@save')->name('master.akun.save');
                        Route::post('delete', 'Akun_reimburse@delete')->name('master.akun.delete');
                    });
                });
            });

            Route::group('pengajuan', function () {
                Route::get('', 'Data_reimburse@index')->name('reimburse.pengajuan.home');
                Route::get('/{pengajuan?}', 'Data_reimburse@index')->name('reimburse.pengajuan.saya');
                Route::get('data/{tipe?}', 'Data_reimburse@data')->name('reimburse.data');
                Route::post('list-data', 'Data_reimburse@list_data')->name('reimburse.list.data');
                Route::get('detail/{saya?}/{no_pengajuan?}', 'Data_reimburse@detail')->name('reimburse.detail');
                Route::get('simpan', 'Data_reimburse@simpan');

                Route::get('approve_data', 'Data_reimburse@approve_data');
                Route::get('tambah', 'Data_reimburse@form');
                Route::get('edit/{id?}', 'Data_reimburse@edit');
                Route::get('detail/{id?}', 'Data_reimburse@detail');
                Route::get('detail-lembur-selesai/{id?}', 'Data_reimburse@detail_lembur_selesai');
                Route::post('save', 'Data_reimburse@save')->name('reimburse.save');
                Route::post('update', 'Data_reimburse@update');
                Route::post('delete', 'Data_reimburse@delete');
                Route::get('import', 'Data_reimburse@import');
                Route::get('export/{id?}', 'Data_reimburse@export');
            });

            // //REKAP_REIMBURSEMENT
            // Route::group('rekap',function(){
            //     Route::get('departemen','Rekap_reimburse@index');
            //     Route::get('list-data/{id_cabang?}/{id_departemen?}/{tgl_awal?}/{tgl_akhir?}','Rekap_reimburse@rekap_departemen')->name('reimburse.rekap.listdata');
            //     Route::get('karyawan','Rekap_reimburse@main_karyawan');
            //     Route::get('data/{id_karyawan?}/{tgl_awal?}/{tgl_akhir?}','Rekap_reimburse@rekap_karyawan')->name('reimburse.rekap.data');
            //     Route::get('dropdown-karyawan','Rekap_reimburse@dropdown_karyawan')->name('reimburse.rekap.dropdown.karyawan');

            //     Route::get('dwonload/pdf/{id_cabang?}/{id_departemen?}/{id_karyawan?}/{tgl_awal?}/{tgl_akhir?}','Rekap_reimburse@download_pdf')->name('reimburse.rekap.download.pdf');
            // });

            Route::group('dropdown', function () {
                Route::get('cabang', 'Data_reimburse@dropdown_cabang')->name("reimburse.dropdown.cabang");
                Route::get('departemen/{id_cabang?}', 'Data_reimburse@dropdown_departemen')->name("reimburse.dropdown.departemen");
                Route::get('karyawan', 'Data_reimburse@dropdown_karyawan')->name('reimburse.dropdown.karyawan');
            });

            Route::group('laporan', function () {
                Route::get('data', 'Laporan_reimburse@index')->name('reimburse.laporan.home');
                Route::get('data/download/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/{jenis?}', 'Laporan_reimburse@download');
                Route::get('data/view-data/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Laporan_reimburse@view_data');
                Route::get('list/data/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Laporan_reimburse@list_data');
                Route::get('dropdown/cabang', 'Laporan_reimburse@dropdown_cabang')->name("reimbursement.laporan.dropdown.cabang");
                Route::get('dropdown/departement/{id_cabang?}', 'Laporan_reimburse@dropdown_departemen')->name("reimbursement.laporan.dropdown.departement");
                Route::get('dropdown/karyawan', 'Laporan_reimburse@dropdown_karyawan')->name("reimbursement.laporan.dropdown.karyawan");
            });
        });
        // //REIMBURSEMENT
    });

    # BEGIN PAYROLL
    Route::group('payroll', ['middleware' => ['Auth_adm_payroll', 'Auth_paket:payroll', 'Auth_conn:payroll']], function () {
        Route::group('pengaturan', function () {
            Route::group('umum', ['namespace' => 'payroll/pengaturan'], function () {
                Route::get('', 'Pot_absensi@index')->name("payroll.pengaturan.potongan.absensi.home");
                Route::post('list_data', 'Pot_absensi@list_data')->name("payroll.pengaturan.potongan.absensi.data");

                Route::get('form/edit', 'Pot_absensi@form')->name("payroll.pengaturan.potongan.absensi.form.update");
                Route::post('save', 'Pot_absensi@save')->name("payroll.pengaturan.potongan.absensi.save");
                Route::post('update-flag', 'Pot_absensi@update_flag')->name("payroll.pengaturan.potongan.absensi.update_flag");
                // Route::post('update-pph', 'Pot_absensi@update_pot_pph')->name("payroll.pengaturan.potongan.absensi.update.pph");
                Route::get('form/pph21/{id?}', 'Pot_absensi@form_pph21')->name("payroll.pengaturan.form.pph");
                Route::post('form/pph21/save', 'Pot_absensi@save_pph21')->name("payroll.pengaturan.form.pph.save");
            });
        });

        Route::group('master', function () {
            Route::group('gapok', ['namespace' => 'payroll/gapok'], function () {
                Route::get('', 'Master_gapok@index')->name("payroll.master.gapok.home");
                Route::get('list_data', 'Master_gapok@list_data')->name("payroll.master.gapok.data");
                Route::get('form/tambah', 'Master_gapok@form')->name("payroll.master.gapok.form.tambah");
                Route::get('form/edit/{id?}', 'Master_gapok@form')->name("payroll.master.gapok.form.edit");
                Route::get('form/hapus/{id?}', 'Master_gapok@form')->name("payroll.master.gapok.form.hapus");
                Route::post('save', 'Master_gapok@save')->name("payroll.master.gapok.save");
                Route::post('update', 'Master_gapok@update')->name("payroll.master.gapok.update");
                Route::post('delete', 'Master_gapok@delete')->name("payroll.master.gapok.delete");

                Route::group('import', function () {
                    Route::get('', 'Import@index')->name('payroll.master.gapok.import');
                    Route::get('form/template-import', 'Import@form_template_import')->name('payroll.master.gapok.import.form.templateimport');
                    Route::get('unduh/excel/{id_cabang?}/{id_departemen?}', 'Import@download_template')->name('payroll.master.gapok.import.unduh.templateimport');
                    Route::post('excel', 'Import@import_data_excel')->name('payroll.master.gapok.import.excel');
                    Route::get('list-data', 'Import@list_data')->name('payroll.master.gapok.import.listdata');
                    Route::delete('delete/all', 'Import@delete_all_temp')->name('payroll.master.gapok.import.deleteall');
                    Route::post('publish/all', 'Import@publish_all')->name('payroll.master.gapok.import.publishall');
                    Route::get('form/{id}', 'Import@form')->name('payroll.master.gapok.import.form');
                    Route::get('form-hapus/{id}', 'Import@form_hapus')->name('payroll.master.gapok.import.form.hapus');
                    Route::post('delete', 'Import@delete')->name('payroll.master.gapok.import.delete');
                    Route::post('save', 'Import@save')->name('payroll.master.gapok.import.save');
                });
            });

            Route::group('komponen', ['namespace' => 'payroll'], function () {
                Route::get('', fn() => redirect(route('payroll.master.komponen.pendapatan')));

                Route::get('pendapatan', 'Master_komponen@index_pendapatan')->name("payroll.master.komponen.pendapatan");
                Route::get('potongan', 'Master_komponen@index_potongan')->name("payroll.master.komponen.potongan");
                Route::get('kehadiran', 'Master_komponen@index_kehadiran')->name("payroll.master.komponen.kehadiran");
                Route::get('list_data/{master}', 'Master_komponen@list_data')->name("payroll.master.komponen.data");

                Route::get('form/tambah/{master}', 'Master_komponen@form')->name("payroll.master.komponen.form.tambah");
                Route::get('form/edit/{master}/{id?}', 'Master_komponen@form')->name("payroll.master.komponen.form.edit");
                Route::get('form/hapus/{master}/{id?}', 'Master_komponen@form')->name("payroll.master.komponen.form.hapus");
                Route::post('save/{master}', 'Master_komponen@save')->name("payroll.master.komponen.save");
                Route::post('update/{master}', 'Master_komponen@update')->name("payroll.master.komponen.update");
                Route::post('delete/{master}/{bulan?}', 'Master_komponen@delete')->name("payroll.master.komponen.delete");
                Route::post('order', 'Master_komponen@update_order')->name("payroll.master.komponen.order");
            });

            Route::group('lembur', ['namespace' => 'payroll/master_lembur'], function () {
                Route::get('', 'Master_lembur@index')->name('payroll.master.lembur.home');
                Route::get('list_data/{tab}/{params?}', 'Master_lembur@list_data')->name('payroll.master.lembur.data');

                Route::group('pengaturan', function () {
                    Route::get('', 'Master_lembur_pengaturan@view_data')->name('payroll.master.lembur.pengaturan');
                    Route::get('form/{for}/{id?}', 'Master_lembur_pengaturan@form')->name('payroll.master.lembur.pengaturan.form');
                    Route::post('save', 'Master_lembur_pengaturan@save')->name('payroll.master.lembur.pengaturan.save');
                    Route::post('update/{id}', 'Master_lembur_pengaturan@update')->name('payroll.master.lembur.pengaturan.update');
                    Route::post('delete', 'Master_lembur_pengaturan@delete')->name('payroll.master.lembur.pengaturan.delete');
                });

                Route::group('karyawan', function () {
                    Route::get('', 'Master_lembur_karyawan@view_data')->name('payroll.master.lembur.karyawan');
                    Route::get('form/delete/{id?}', 'Master_lembur_karyawan@form_delete')->name('payroll.master.lembur.karyawan.form.delete');
                    Route::get('download/{params}', 'Master_lembur_karyawan@download')->name('payroll.master.lembur.karyawan.download');
                    Route::post('save', 'Master_lembur_karyawan@save')->name('payroll.master.lembur.karyawan.save');
                    Route::post('delete', 'Master_lembur_karyawan@delete')->name('payroll.master.lembur.karyawan.delete');

                    Route::group('import', function () {
                        Route::get('', 'Master_lembur_karyawan_import@index')->name('payroll.master.lembur.karyawan.import');
                        Route::get('list_data', 'Master_lembur_karyawan_import@list_data')->name('payroll.master.lembur.karyawan.import.data');
                        Route::get('modal', 'Master_lembur_karyawan_import@template_import')->name('payroll.master.lembur.karyawan.import.template');
                        Route::get('template/{id_cabang}/{id_departemen}', 'Master_lembur_karyawan_import@download_template_import')->name('payroll.master.lembur.karyawan.import.template.download');
                        Route::post('file', 'Master_lembur_karyawan_import@import_data_excel')->name('payroll.master.lembur.karyawan.import.template.upload');
                        Route::post('publish/all', 'Master_lembur_karyawan_import@publish_all_temp')->name('payroll.master.lembur.karyawan.import.publish');
                        Route::delete('delete/all', 'Master_lembur_karyawan_import@delete_all_temp')->name('payroll.master.lembur.karyawan.import.delete');
                    });
                });
            });
        });

        Route::group('tunjangan', function () {
            Route::group('tetap', function () {
                // home
                Route::get('', 'payroll/tunjangan/Tetap@index')->name('payroll.tunjangan.tetap.home');
                Route::post('datatable/{id_karyawan?}', 'payroll/tunjangan/Tetap@list_data')->name('payroll.tunjangan.tetap.datatable');
                Route::get('form/tambah', 'payroll/tunjangan/Tetap@form')->name('payroll.tunjangan.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}', 'payroll/tunjangan/Tetap@detail')->name('payroll.tunjangan.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}', 'payroll/tunjangan/Tetap@list_data_detail')->name('payroll.tunjangan.tetap.datatable.detail');
                Route::get('form/tambah_item', 'payroll/tunjangan/Tetap@form_detail')->name('payroll.tunjangan.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}', 'payroll/tunjangan/Tetap@form_detail')->name('payroll.tunjangan.tetap.form.edit');
                Route::get('form/delete_item/{id?}', 'payroll/tunjangan/Tetap@form_detail')->name('payroll.tunjangan.tetap.form.delete');
                Route::post('save', 'payroll/tunjangan/Tetap@save')->name('payroll.tunjangan.tetap.save');
                Route::post('delete', 'payroll/tunjangan/Tetap@delete')->name('payroll.tunjangan.tetap.delete');
            });
            Route::group('tidak-tetap', function () {
                // home
                Route::get('', 'payroll/tunjangan/TidakTetap@index')->name('payroll.tunjangan.tidak.tetap.home');
                Route::post('datatable/{id_karyawan?}/{bulan?}', 'payroll/tunjangan/TidakTetap@list_data')->name('payroll.tunjangan.tidak.tetap.datatable');
                Route::get('form/tambah', 'payroll/tunjangan/TidakTetap@form')->name('payroll.tunjangan.tidak.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}/{bulan?}', 'payroll/tunjangan/TidakTetap@detail')->name('payroll.tunjangan.tidak.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}/{bulan?}', 'payroll/tunjangan/TidakTetap@list_data_detail')->name('payroll.tunjangan.tidak.tetap.datatable.detail');
                Route::get('form/tambah_item', 'payroll/tunjangan/TidakTetap@form_detail')->name('payroll.tunjangan.tidak.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}', 'payroll/tunjangan/TidakTetap@form_detail')->name('payroll.tunjangan.tidak.tetap.form.edit');
                Route::get('form/delete_item/{id?}', 'payroll/tunjangan/TidakTetap@form_detail')->name('payroll.tunjangan.tidak.tetap.form.delete');
                Route::post('save', 'payroll/tunjangan/TidakTetap@save')->name('payroll.tunjangan.tidak.tetap.save');
                Route::post('delete', 'payroll/tunjangan/TidakTetap@delete')->name('payroll.tunjangan.tidak.tetap.delete');
            });
        });

        Route::group('potongan', function () {
            Route::group('tetap', function () {
                // home
                Route::get('', 'payroll/potongan/Tetap@index')->name('payroll.potongan.tetap.home');
                Route::post('datatable/{id_karyawan?}', 'payroll/potongan/Tetap@list_data')->name('payroll.potongan.tetap.datatable');
                Route::get('form/tambah', 'payroll/potongan/Tetap@form')->name('payroll.potongan.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}', 'payroll/potongan/Tetap@detail')->name('payroll.potongan.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}', 'payroll/potongan/Tetap@list_data_detail')->name('payroll.potongan.tetap.datatable.detail');
                Route::get('form/tambah_item', 'payroll/potongan/Tetap@form_detail')->name('payroll.potongan.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}', 'payroll/potongan/Tetap@form_detail')->name('payroll.potongan.tetap.form.edit');
                Route::get('form/delete_item/{id?}', 'payroll/potongan/Tetap@form_detail')->name('payroll.potongan.tetap.form.delete');
                Route::post('save', 'payroll/potongan/Tetap@save')->name('payroll.potongan.tetap.save');
                Route::post('delete', 'payroll/potongan/Tetap@delete')->name('payroll.potongan.tetap.delete');
            });

            Route::group('tidak-tetap', function () {
                // home
                Route::get('', 'payroll/potongan/TidakTetap@index')->name('payroll.potongan.tidak.tetap.home');
                Route::post('datatable/{id_karyawan?}/{bulan?}', 'payroll/potongan/TidakTetap@list_data')->name('payroll.potongan.tidak.tetap.datatable');
                Route::get('form/tambah', 'payroll/potongan/TidakTetap@form')->name('payroll.potongan.tidak.tetap.form.tambah');

                // detail
                Route::get('detail/{id_karyawan?}/{bulan?}', 'payroll/potongan/TidakTetap@detail')->name('payroll.potongan.tidak.tetap.detail');
                Route::post('datatable/detail/{id_karyawan?}/{bulan?}', 'payroll/potongan/TidakTetap@list_data_detail')->name('payroll.potongan.tidak.tetap.datatable.detail');
                Route::get('form/tambah_item', 'payroll/potongan/TidakTetap@form_detail')->name('payroll.potongan.tidak.tetap.form.tambah.item');
                Route::get('form/edit_item/{id?}', 'payroll/potongan/TidakTetap@form_detail')->name('payroll.potongan.tidak.tetap.form.edit');
                Route::get('form/delete_item/{id?}', 'payroll/potongan/TidakTetap@form_detail')->name('payroll.potongan.tidak.tetap.form.delete');
                Route::post('save', 'payroll/potongan/TidakTetap@save')->name('payroll.potongan.tidak.tetap.save');
                Route::post('delete', 'payroll/potongan/TidakTetap@delete')->name('payroll.potongan.tidak.tetap.delete');
            });
        });

        Route::group('data-komponen-kehadiran', ['namespace' => 'payroll/data_komponen_kehadiran'], function () {
            Route::get('', 'Data_komponen@index')->name('payroll.data.komponen.kehadiran.home');
            Route::get('list-data/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Data_komponen@list_data')->name('payroll.data.komponen.kehadiran.datatable');
            Route::get('form', 'Data_komponen@form')->name('payroll.data.komponen.kehadiran.form');
            Route::post('update', 'Data_komponen@update')->name('payroll.data.komponen.kehadiran.update');

            Route::group('import', function () {
                Route::get('home', 'Data_komponen_import@index')->name("payroll.data.komponen.kehadiran.import.home");
                Route::get('view-data', 'Data_komponen_import@view_data')->name('payroll.data.komponen.kehadiran.import.viewdata');
                Route::get('list-data', 'Data_komponen_import@list_data')->name('payroll.data.komponen.kehadiran.import.listdata');
                Route::get('unduh/template/{id_cabang?}/{id_departemen?}', 'Data_komponen_import@download_template')->name('payroll.data.komponen.kehadiran.import.unduh.template');
                Route::post('excel', 'Data_komponen_import@import_data_excel')->name('payroll.data.komponen.kehadiran.import.excel');
                Route::get('form/template-import', 'Data_komponen_import@form_template_import')->name('payroll.data.komponen.kehadiran.import.form.templateimport');
                Route::post('publish/all', 'Data_komponen_import@publish_all')->name('payroll.data.komponen.kehadiran.import.publishall');
                Route::delete('delete/all', 'Data_komponen_import@delete_all_temp')->name('payroll.data.komponen.kehadiran.import.deleteall');
            });
        });

        Route::group('data-komponen', ['namespace' => 'payroll/data_komponen'], function () {
            Route::get('', 'Data_komponen@index')->name('payroll.data.komponen.home');
            Route::get('list-data/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Data_komponen@list_data')->name('payroll.data.komponen.datatable');
            Route::get('form', 'Data_komponen@form')->name('payroll.data.komponen.form');
            Route::post('update', 'Data_komponen@update')->name('payroll.data.komponen.update');

            Route::group('import', function () {
                Route::get('home', 'Data_komponen_import@index')->name("payroll.data.komponen.import.home");
                Route::get('view-data', 'Data_komponen_import@view_data')->name('payroll.data.komponen.import.viewdata');
                Route::get('list-data', 'Data_komponen_import@list_data')->name('payroll.data.komponen.import.listdata');
                Route::get('unduh/template/{id_cabang?}/{id_departemen?}', 'Data_komponen_import@download_template')->name('payroll.data.komponen.import.unduh.template');
                Route::post('excel', 'Data_komponen_import@import_data_excel')->name('payroll.data.komponen.import.excel');
                Route::get('form/template-import', 'Data_komponen_import@form_template_import')->name('payroll.data.komponen.import.form.templateimport');
                Route::post('publish/all', 'Data_komponen_import@publish_all')->name('payroll.data.komponen.import.publishall');
                Route::delete('delete/all', 'Data_komponen_import@delete_all_temp')->name('payroll.data.komponen.import.deleteall');
            });
        });

        Route::group('data-komponen-tidak-tetap', ['namespace' => 'payroll/data_komponen_tdk_tetap'], function () {
            Route::get('', 'Data_komponen@index')->name('payroll.data.komponen.tdk.tetap.home');
            Route::get('dropdown-cabang', 'Data_komponen@cabang')->name('payroll.data.komponen.tdk.tetap.dropdown.cabang');
            Route::get('dropdown-departemen/{id_cabang?}', 'Data_komponen@departemen_by_cabang')->name('payroll.data.komponen.tdk.tetap.dropdown.departemen');
            Route::get('view-data/{bulan}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Data_komponen@view_data')->name('payroll.data.komponen.tdk.tetap.viewdata');
            Route::get('list-data/{bulan}/{id_karyawan?}/{id_cabang?}/{id_departemen?}', 'Data_komponen@list_data')->name('payroll.data.komponen.tdk.tetap.datatable');
            Route::get('form', 'Data_komponen@form')->name('payroll.data.komponen.tdk.tetap.form');
            Route::post('update', 'Data_komponen@update')->name('payroll.data.komponen.tdk.tetap.update');

            Route::group('import', function () {
                Route::get('home', 'Data_komponen_import@index')->name("payroll.data.komponen.tdk.tetap.import.home");
                Route::get('view-data', 'Data_komponen_import@view_data')->name('payroll.data.komponen.tdk.tetap.import.viewdata');
                Route::get('list-data', 'Data_komponen_import@list_data')->name('payroll.data.komponen.tdk.tetap.import.listdata');
                Route::get('dropdown-komponen', 'Data_komponen_import@dropdown_komponen')->name('payroll.data.komponen.tdk.tetap.dropdown.komponen');
                Route::get('unduh/template/{bulan}/{id_cabang?}/{id_departemen?}', 'Data_komponen_import@download_template')->name('payroll.data.komponen.tdk.tetap.import.unduh.template');
                Route::post('excel', 'Data_komponen_import@import_data_excel')->name('payroll.data.komponen.tdk.tetap.import.excel');
                Route::get('form/template-import', 'Data_komponen_import@form_template_import')->name('payroll.data.komponen.tdk.tetap.import.form.templateimport');
                Route::post('publish/all', 'Data_komponen_import@publish_all')->name('payroll.data.komponen.tdk.tetap.import.publishall');
                Route::delete('delete/all', 'Data_komponen_import@delete_all_temp')->name('payroll.data.komponen.tdk.tetap.import.deleteall');
            });
        });

        Route::group('bpjs', function () {
            Route::get('', 'payroll/bpjs/Bpjs@index')->name('payroll.bpjs');
            Route::get('config', 'payroll/bpjs/Bpjs_config@index')->name('payroll.bpjs.config');
            Route::get('form/{jenis}/{name?}', 'payroll/bpjs/Bpjs_config@form')->name('payroll.bpjs.config.form');
            Route::post('save/{jenis}', 'payroll/bpjs/Bpjs_config@save')->name('payroll.bpjs.config.save');
            Route::get('input-nominal/{name}', 'payroll/bpjs/Bpjs_config@input_nominal')->name('payroll.bpjs.config.input-nominal');
            Route::post('save-nominal', 'payroll/bpjs/Bpjs_config@save_nominal')->name('payroll.bpjs.config.save-nominal');
            Route::group('master', function () {
                Route::get('', 'payroll/bpjs/Bpjs_master@index')->name('payroll.bpjs.master');
                Route::get('list_data/{params}', 'payroll/bpjs/Bpjs_master@list_data')->name('payroll.bpjs.master.list-data');
                Route::get('form/{jenis}/{id?}', 'payroll/bpjs/Bpjs_master@form');
                Route::get('get-data', 'payroll/bpjs/Bpjs_master@get_data')->name('payroll.bpjs.master.get-data');
                Route::post('save', 'payroll/bpjs/Bpjs_master@save')->name('payroll.bpjs.master.save');
                Route::post('delete', 'payroll/bpjs/Bpjs_master@delete')->name('payroll.bpjs.master.delete');
                Route::group('import', function () {
                    Route::get('', 'payroll/bpjs/Import@index')->name('payroll.bpjs.master.import');
                    Route::get('list-data', 'payroll/bpjs/Import@list_data')->name('payroll.master.bpjs.import.listdata');
                    Route::get('form/template-import', 'payroll/bpjs/Import@form_template_import')->name('payroll.master.bpjs.import.form.templateimport');
                    Route::get('unduh/excel/{id_cabang?}/{id_departemen?}', 'payroll/bpjs/Import@download_template')->name('payroll.master.bpjs.import.unduh.templateimport');
                    Route::post('excel', 'payroll/bpjs/Import@import_data_excel')->name('payroll.master.bpjs.import.excel');
                    Route::delete('delete/all', 'payroll/bpjs/Import@delete_all_temp')->name('payroll.master.bpjs.import.deleteall');
                    Route::get('form/{id}', 'payroll/bpjs/Import@form');
                    Route::post('save', 'payroll/bpjs/Import@save')->name('payroll.master.bpjs.import.save');
                    Route::post('delete', 'payroll/bpjs/Import@delete')->name('payroll.master.bpjs.import.delete');
                    Route::post('publish/all', 'payroll/bpjs/Import@publish_all')->name('payroll.master.bpjs.import.publishall');
                });
            });
        });

        Route::group('gaji', ['middleware' => ['Auth_payroll'], 'namespace' => 'payroll/gaji'], function () {
            Route::get('', 'Gaji@index')->name('payroll.gaji.home');
            Route::get('view/{periode}/{cabang}/{departemen}/{karyawan}', 'Gaji@view')->name('payroll.gaji.view');
            Route::get('datatable/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Gaji@list_data')->name('payroll.gaji.datatable');
            Route::get('form/hitung', 'Gaji@form')->name('payroll.gaji.form.hitung');
            Route::get('form/delete/{id?}', 'Gaji@form')->name('payroll.gaji.form.delete');
            Route::get('form/publish/{key?}', 'Gaji@form_publish')->name('payroll.gaji.form.publish');
            Route::get('detail/upah-lembur/{id}', 'Gaji@detail_upah_lembur')->name('payroll.gaji.detail.upah_lembur');
            Route::get('detail/pot-absensi/{id}', 'Gaji@detail_pot_absensi')->name('payroll.gaji.detail.pot_absensi');

            Route::get('detail/{id?}/{bulan?}', 'Gaji@detail')->name('payroll.gaji.detail');
            Route::post('hitung', 'Gaji@hitung_gaji')->name('payroll.gaji.hitung');
            Route::post('publishunpublish', 'Gaji@publish_unpublish')->name('payroll.gaji.publishunpublish');
            Route::post('publis-all', 'Gaji@publish_all')->name("payroll.gaji.publishall");
            Route::post('unpublish-all', 'Gaji@unpublish_all')->name("payroll.gaji.unpublishall");
            Route::post('delete', 'Gaji@delete')->name('payroll.gaji.delete');
            Route::get('download/excel/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Gaji@download_excel')->name('payroll.gaji.download.excel');
            Route::get('download/slip/{token}', 'Gaji@download_pdf')->name('payroll.gaji.download.slip');
            Route::get('download/excel/bank/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Gaji@download_excel_bank')->name('payroll.gaji.download.excel.bank');

            Route::group('ptkp', function () {
                Route::get('', 'Ptkp@index')->name('payroll.gaji.ptkp.index');
                Route::get('data', 'Ptkp@list_data')->name('payroll.gaji.ptkp.data');
                Route::post('save', 'Ptkp@save')->name('payroll.gaji.ptkp.save');
            });
        });


        // laporan pph
        // Route::group('laporan-pph', function () {
        //     Route::get('', 'payroll/laporan_pph/Laporan_pph@index')->name('payroll.laporan.pph.home');
        //     Route::get('view-data/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'payroll/laporan_pph/Laporan_pph@view_data')->name('payroll.laporan.pph.view.data');
        //     Route::get('list-data/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'payroll/laporan_pph/Laporan_pph@list_data')->name('payroll.laporan.pph.list.data');
        //     Route::get('download/excel/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'payroll/laporan_pph/Laporan_pph@download_excel')->name('payroll.laporan.pph.download.excel');
        // });

        // laporan pph uu24
        Route::group('laporan-pph', ['namespace' => 'payroll/laporan_pph'], function () {
            Route::get('', 'Laporan_pph_uu24@index')->name('payroll.laporan.pph.home');
            Route::get('view-data/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Laporan_pph_uu24@view_data')->name('payroll.laporan.pph.view.data');
            Route::get('list-data/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Laporan_pph_uu24@list_data')->name('payroll.laporan.pph.list.data');
            Route::get('download/excel/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Laporan_pph_uu24@download_excel')->name('payroll.laporan.pph.download.excel');
            Route::get('download/excel/djp/{bulan?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}', 'Laporan_pph_uu24@download_excel_djp')->name('payroll.laporan.pph.download.excel.djp');
        });
    });
    # END PAYROLL

    # BEGIN SALES ACTIVITY
    Route::group('sales-activity', ['namespace' => 'sales_activity'], function () {
        Route::get('', 'Sales_activity@index')->name('sales_activity.home');
        Route::get('list_data/{tab}/{params?}', 'Sales_activity@list_data')->name('sales_activity.data');
        Route::get('get-target-harian-bulanan', 'Sales_activity@get_target_harian_bulanan')->name('sales_activity.get_target.harian_bulanan');

        # Start Dashboard
        Route::group('dashboard', ['namespace' => 'dashboard'], function () {
            Route::get('', 'Dashboard@index')->name('sales_activity.dashboard.home');
            Route::get('dropdown/group-area', 'Dashboard@dropdown_group_area')->name('sales_activity.dashboard.dropdown.group.area');

            Route::group('data', function () {
                Route::get('sales-summary', 'Dashboard@list_data_sales_summary')->name('sales_activity.dashboard.data.sales.summary');
                Route::get('po-per-sales', 'Dashboard@list_data_po_per_sales')->name('sales_activity.dashboard.data.po.per.sales');
                Route::get('po-per-product', 'Dashboard@list_data_po_per_product')->name('sales_activity.dashboard.data.po.per.product');
                Route::get('activity', 'Dashboard@list_data_activity')->name('sales_activity.dashboard.data.activity');
                Route::get('target-realisasi', 'Dashboard@list_data_target_realisasi')->name('sales_activity.dashboard.data.target.realisasi');
            });
        });
        # End Dashboard

        # Start Master
        Route::group('master', ['namespace' => 'master'], function () {
            Route::get('', 'Master@index')->name('sales_activity.master.home');
            Route::get('tabs/{tabs?}', 'Master@tabs')->name('sales_activity.master.tabs');
            Route::get('dropdown/group-area/{opsi_all?}', 'Master@dropdown_group_area')->name('sales_activity.master.dropdown.group.area');

            Route::group('aktivitas', function () {
                Route::get('list-data', 'Aktivitas@list_data')->name('sales_activity.master.aktivitas.list.data');
                Route::get('form/tambah', 'Aktivitas@form')->name('sales_activity.master.aktivitas.form.tambah');
                Route::get('form/edit/{id?}', 'Aktivitas@form')->name('sales_activity.master.aktivitas.form.edit');
                Route::get('form/hapus/{id?}', 'Aktivitas@form')->name('sales_activity.master.aktivitas.form.hapus');
                Route::post('save', 'Aktivitas@save')->name('sales_activity.master.aktivitas.save');
                Route::post('delete', 'Aktivitas@delete')->name('sales_activity.master.aktivitas.delete');
                Route::post('order', 'Aktivitas@update_order')->name("sales_activity.master.aktivitas.order");
            });

            Route::group('lead-source', function () {
                Route::get('list-data', 'Lead_source@list_data')->name('sales_activity.master.lead.source.list.data');
                Route::get('form/tambah', 'Lead_source@form')->name('sales_activity.master.lead.source.form.tambah');
                Route::get('form/edit/{id?}', 'Lead_source@form')->name('sales_activity.master.lead.source.form.edit');
                Route::get('form/hapus/{id?}', 'Lead_source@form')->name('sales_activity.master.lead.source.form.hapus');
                Route::post('save', 'Lead_source@save')->name('sales_activity.master.lead.source.save');
                Route::post('delete', 'Lead_source@delete')->name('sales_activity.master.lead.source.delete');
                Route::post('order', 'Lead_source@update_order')->name("sales_activity.master.lead.source.order");
            });

            Route::group('tahapan', function () {
                Route::post('save', 'Tahapan@save')->name('sales_activity.master.tahapan.save');
                Route::post('delete', 'Tahapan@delete')->name('sales_activity.master.tahapan.delete');
                Route::post('order', 'Tahapan@order')->name('sales_activity.master.tahapan.order');
            });

            Route::group('group-product', function () {
                Route::get('list-data', 'Group_product@list_data')->name('sales_activity.master.group.product.list.data');
                Route::get('form/tambah', 'Group_product@form')->name('sales_activity.master.group.product.form.tambah');
                Route::get('form/edit/{id?}', 'Group_product@form')->name('sales_activity.master.group.product.form.edit');
                Route::get('form/hapus/{id?}', 'Group_product@form')->name('sales_activity.master.group.product.form.hapus');
                Route::post('save', 'Group_product@save')->name('sales_activity.master.group.product.save');
                Route::post('delete', 'Group_product@delete')->name('sales_activity.master.group.product.delete');
                Route::post('order', 'Group_product@update_order')->name("sales_activity.master.group.product.order");
            });

            Route::group('product', function () {
                Route::get('list-data', 'Product@list_data')->name('sales_activity.master.product.list.data');
                Route::get('form/tambah', 'Product@form')->name('sales_activity.master.product.form.tambah');
                Route::get('form/edit/{id?}', 'Product@form')->name('sales_activity.master.product.form.edit');
                Route::get('form/hapus/{id?}', 'Product@form')->name('sales_activity.master.product.form.hapus');
                Route::post('save', 'Product@save')->name('sales_activity.master.product.save');
                Route::post('delete', 'Product@delete')->name('sales_activity.master.product.delete');
                Route::get('dropdown/group-product', 'Product@dropdown_group_product')->name('sales_activity.master.dropdown.group.product');
            });

            Route::group('jenis-perusahaan', function () {
                Route::get('list-data', 'Jenis_perusahaan@list_data')->name('sales_activity.master.jenis.perusahaan.list.data');
                Route::get('form/tambah', 'Jenis_perusahaan@form')->name('sales_activity.master.jenis.perusahaan.form.tambah');
                Route::get('form/edit/{id?}', 'Jenis_perusahaan@form')->name('sales_activity.master.jenis.perusahaan.form.edit');
                Route::get('form/hapus/{id?}', 'Jenis_perusahaan@form')->name('sales_activity.master.jenis.perusahaan.form.hapus');
                Route::post('save', 'Jenis_perusahaan@save')->name('sales_activity.master.jenis.perusahaan.save');
                Route::post('delete', 'Jenis_perusahaan@delete')->name('sales_activity.master.jenis.perusahaan.delete');
            });

            Route::group('jenis-perorangan', function () {
                Route::get('list-data', 'Jenis_perorangan@list_data')->name('sales_activity.master.jenis.perorangan.list.data');
                Route::get('form/tambah', 'Jenis_perorangan@form')->name('sales_activity.master.jenis.perorangan.form.tambah');
                Route::get('form/edit/{id?}', 'Jenis_perorangan@form')->name('sales_activity.master.jenis.perorangan.form.edit');
                Route::get('form/hapus/{id?}', 'Jenis_perorangan@form')->name('sales_activity.master.jenis.perorangan.form.hapus');
                Route::post('save', 'Jenis_perorangan@save')->name('sales_activity.master.jenis.perorangan.save');
                Route::post('delete', 'Jenis_perorangan@delete')->name('sales_activity.master.jenis.perorangan.delete');
            });

            Route::group('group-area', function () {
                Route::get('list-data', 'Group_area@list_data')->name('sales_activity.master.group-area.list.data');
                Route::get('form/tambah', 'Group_area@form')->name('sales_activity.master.group-area.form.tambah');
                Route::get('form/edit/{id?}', 'Group_area@form')->name('sales_activity.master.group-area.form.edit');
                Route::get('form/hapus/{id?}', 'Group_area@form')->name('sales_activity.master.group-area.form.hapus');
                Route::post('save', 'Group_area@save')->name('sales_activity.master.group-area.save');
                Route::post('delete', 'Group_area@delete')->name('sales_activity.master.group-area.delete');
                Route::post('order', 'Group_area@update_order')->name("sales_activity.master.group-area.order");
            });
        });
        # End Master

        # Start Pengaturan
        Route::group('pengaturan', ['namespace' => 'pengaturan'], function () {
            Route::get('', 'Pengaturan@index')->name('sales_activity.pengaturan.home');
            Route::get('tabs/{tabs?}', 'Pengaturan@tabs')->name('sales_activity.pengaturan.tabs');

            Route::group('admin_sales', function () {
                Route::get('list-data', 'Admin_sales@list_data')->name('sales_activity.pengaturan.admin.sales.list.data');
                Route::get('form/tambah', 'Admin_sales@form')->name('sales_activity.pengaturan.admin.sales.form.tambah');
                Route::get('form/edit/{id?}', 'Admin_sales@form')->name('sales_activity.pengaturan.admin.sales.form.edit');
                Route::get('form/hapus/{id?}', 'Admin_sales@form')->name('sales_activity.pengaturan.admin.sales.form.hapus');
                Route::post('save', 'Admin_sales@save')->name('sales_activity.pengaturan.admin.sales.save');
                Route::post('delete', 'Admin_sales@delete')->name('sales_activity.pengaturan.admin.sales.delete');
            });

            Route::group('approval_atasan', function () {
                Route::get('list-data', 'Approval_atasan@list_data')->name('sales_activity.pengaturan.approval.atasan.list.data');
                Route::get('form/tambah', 'Approval_atasan@form')->name('sales_activity.pengaturan.approval.atasan.form.tambah');
                Route::get('form/edit/{id?}', 'Approval_atasan@form')->name('sales_activity.pengaturan.approval.atasan.form.edit');
                Route::get('form/hapus/{id?}', 'Approval_atasan@form')->name('sales_activity.pengaturan.approval.atasan.form.hapus');
                Route::post('save', 'Approval_atasan@save')->name('sales_activity.pengaturan.approval.atasan.save');
                Route::post('delete', 'Approval_atasan@delete')->name('sales_activity.pengaturan.approval.atasan.delete');
                Route::get('cek-maximal-sales', 'Approval_atasan@cek_maximal_sales')->name('sales_activity.pengaturan.approval.atasan.cek.maximal.sales');
                Route::get('dropdown/atasan/{id_group?}', 'Approval_atasan@dropdown_atasan')->name('sales_activity.pengaturan.approval.atasan.dropdown.atasan');
            });

            Route::group('target-tahunan', function () {
                Route::get('list-data', 'Target_tahunan@list_data')->name('sales_activity.master.target.tahunan.list.data');
                Route::get('form/edit/{id?}', 'Target_tahunan@form')->name('sales_activity.master.target.tahunan.form.edit');
                Route::post('save', 'Target_tahunan@save')->name('sales_activity.master.target.tahunan.save');
                Route::get('onchange/filter-tahun', 'Target_tahunan@onchange_filter_tahun')->name('sales_activity.master.target.tahunan.onchange.filter.tahun');
            });

            Route::group('target-kuartal', function () {
                Route::get('list-data', 'Target_kuartal@list_data')->name('sales_activity.master.target.kuartal.list.data');
                Route::get('form/edit/{id?}', 'Target_kuartal@form')->name('sales_activity.master.target.kuartal.form.edit');
                Route::post('save', 'Target_kuartal@save')->name('sales_activity.master.target.kuartal.save');
                Route::get('onchange/filter-tahun', 'Target_kuartal@onchange_filter_tahun')->name('sales_activity.master.target.kuartal.onchange.filter.tahun');
            });

            Route::group('target-bulanan', function () {
                Route::get('list-data', 'Target_bulanan@list_data')->name('sales_activity.master.target.bulanan.list.data');
                Route::get('form/edit/{id?}', 'Target_bulanan@form')->name('sales_activity.master.target.bulanan.form.edit');
                Route::post('save', 'Target_bulanan@save')->name('sales_activity.master.target.bulanan.save');
                Route::get('onchange/filter-tahun', 'Target_bulanan@onchange_filter_tahun')->name('sales_activity.master.target.bulanan.onchange.filter.tahun');
            });

            Route::group('target-personil', function () {
                Route::get('list-data', 'Target_personil@list_data')->name('sales_activity.master.target.personil.list.data');
                Route::post('save', 'Target_personil@save')->name('sales_activity.master.target.personil.save');
            });

            Route::group('target-poin', function () {
                Route::get('list-data', 'Target_poin@list_data')->name('sales_activity.master.target.poin.list.data');
                Route::post('save', 'Target_poin@save')->name('sales_activity.master.target.poin.save');
            });
        });
        # End Pengaturan

        # Start Kanban
        Route::group('kanban-board', ['namespace' => 'kanban'], function () {
            Route::get('', 'Kanban@index')->name('sales_activity.kanban.home');
            Route::get('form/{jenis?}/{id_pipeline?}', 'Kanban@form')->name('sales_activity.kanban.form');
            Route::get('form-layanan/{id_pipeline?}', 'Kanban@form_layanan')->name('sales_activity.kanban.form_layanan');
            Route::get('list-produk', 'Kanban@list_produk')->name('sales_activity.kanban.list_produk');
            Route::get('list-group', 'Kanban@list_group')->name('sales_activity.kanban.list_group');
            Route::get('list-pelanggan/{kategori?}', 'Kanban@list_pelanggan')->name('sales_activity.kanban.list_pelanggan');
            Route::get('list-jenis-perusahaan', 'Kanban@list_jenis_perusahaan')->name('sales_activity.kanban.list_jenis_perusahaan');
            Route::get('list-lead-source', 'Kanban@list_lead_source')->name('sales_activity.kanban.list_lead_source');
            Route::get('list-sales', 'Kanban@list_sales')->name('sales_activity.kanban.list_sales');
            Route::get('list-activity', 'Kanban@list_activity')->name('sales_activity.kanban.list_activity');
            Route::get('data/{periode}/{group}/{pelanggan}/{sales}', 'Kanban@data_kanban')->name('sales_activity.kanban.data');
            Route::get('option/{id}/{action}/{periode?}', 'Kanban@option_task')->name('sales_activity.kanban.option_task');

            Route::post('save', 'Kanban@save_pipeline')->name('sales_activity.kanban.save_pipeline');
            Route::post('update', 'Kanban@update_pipeline')->name('sales_activity.kanban.update_pipeline');
            Route::post('update-pindah-bulan', 'Kanban@update_pindah_bulan')->name('sales_activity.kanban.update_pindah_bulan');
            Route::post('delete', 'Kanban@delete_pipeline')->name('sales_activity.kanban.delete_pipeline');

            Route::group('detail', function () {
                Route::get('perusahaan/index/{id}/{periode}', 'Kanban_detail@detail_perusahaan')->name('sales_activity.kanban.detail.perusahaan');
                Route::get('perusahaan/form/{id}', 'Kanban_detail@detail_perusahaan_form')->name('sales_activity.kanban.detail.perusahaan.form');
                Route::post('update/perusahaan', 'Kanban_detail@update_perusahaan')->name('sales_activity.kanban.detail.update_perusahaan');

                Route::get('layanan/{id}/index', 'Kanban_detail@detail_layanan')->name('sales_activity.kanban.detail.layanan');
                Route::get('layanan/{id}/hapus/{id_layanan}', 'Kanban_detail@detail_layanan_hapus')->name('sales_activity.kanban.detail.layanan.hapus');
                Route::post('save/layanan', 'Kanban_detail@save_layanan')->name('sales_activity.kanban.detail.save_layanan');
                Route::post('update/layanan', 'Kanban_detail@update_layanan')->name('sales_activity.kanban.detail.update_layanan');
                Route::post('delete/layanan', 'Kanban_detail@delete_layanan')->name('sales_activity.kanban.detail.delete_layanan');

                Route::get('aktivitas/{id}/index', 'Kanban_detail@detail_aktivitas')->name('sales_activity.kanban.detail.aktivitas');
                Route::get('aktivitas/{id}/form/{aktivitas?}', 'Kanban_detail@detail_aktivitas_form')->name('sales_activity.kanban.detail.aktivitas.form');
                Route::get('aktivitas/{id}/preview/{po_or_fail?}', 'Kanban_detail@detail_aktivitas_preview')->name('sales_activity.kanban.detail.aktivitas.preview');
                Route::post('save/aktivitas', 'Kanban_detail@save_aktivitas')->name('sales_activity.kanban.detail.save_aktivitas');
                Route::post('update/aktivitas', 'Kanban_detail@update_aktivitas')->name('sales_activity.kanban.detail.update_aktivitas');
            });
        });
        # End Kanban

        # Start Report
        Route::group('report', ['namespace' => 'report'], function () {
            Route::get('', 'Home@index')->name('sales_activity.report.home');
            Route::get('tabs/{tabs?}', 'Home@tabs')->name('sales_activity.report.tabs');

            Route::group('data_sales', function () {
                Route::get('list-data/{bulan?}/{nama_group?}', 'Data_sales@list_data')->name('sales_activity.report.data.sales.list.data');
                Route::get('view_data/{bulan?}/{nama_group?}', 'Data_sales@view_data')->name('sales_activity.report.data.sales.view.data');
                Route::get('list-data-diagram/{bulan?}/{nama_group?}', 'Data_sales@list_data_diagram')->name('sales_activity.report.data.sales.list.data.diagram');
                Route::get('view_diagram/{bulan?}/{nama_group?}', 'Data_sales@view_diagram')->name('sales_activity.report.data.sales.view.diagram');
                Route::get('download/{bulan?}/{nama_group?}', 'Data_sales@download')->name('sales_activity.report.data.sales.download');
                Route::get('dropdown/group/{bulan?}', 'Data_sales@dropdown_nama_group')->name('sales_activity.report.data.sales.dropdown.group');
            });

            Route::group('realisasi-nominal', function () {
                Route::group('data', function () {
                    Route::get('list', 'Realisasi_nominal@list_data')->name('sales_activity.report.realisasi.nominal.list.data');
                    Route::get('view', 'Realisasi_nominal@view_data')->name('sales_activity.report.realisasi.nominal.view.data');
                });
                Route::group('diagram', function () {
                    Route::get('list', 'Realisasi_nominal@list_data_diagram')->name('sales_activity.report.realisasi.nominal.list.data.diagram');
                    Route::get('view', 'Realisasi_nominal@view_diagram')->name('sales_activity.report.realisasi.nominal.view.diagram');
                });
                Route::group('dropdown', function () {
                    Route::get('group/{tahun?}', 'Realisasi_nominal@dropdown_nama_group')->name('sales_activity.report.realisasi.nominal.dropdown.group');
                    Route::get('karyawan', 'Realisasi_nominal@dropdown_karyawan')->name('sales_activity.report.realisasi.nominal.dropdown.karyawan');
                });
                Route::get('download', 'Realisasi_nominal@download')->name('sales_activity.report.realisasi.nominal.download');
            });

            Route::group('realisasi-po', function () {
                Route::group('dropdown', function () {
                    Route::get('group', 'Realisasi_won@dropdown_group')->name('sales_activity.report.realisasi.won.dropdown.group');
                    Route::get('karyawan', 'Realisasi_won@dropdown_karyawan')->name('sales_activity.report.realisasi.won.dropdown.karyawan');
                });
                Route::get('list-data', 'Realisasi_won@list_data')->name('sales_activity.report.realisasi.won.list.data');
                Route::get('download', 'Realisasi_won@download')->name('sales_activity.report.realisasi.won.download');
            });

            Route::group('realisasi-poin', ['namespace' => 'realisasi_poin'], function () {
                Route::get('tabs/{tabs_poin?}', 'Home@tabs')->name('sales_activity.report.poin.tabs');

                Route::group('harian', function () {
                    Route::group('table', function () {
                        Route::get('data-view/table', 'Poin_harian@view_data')->name('sales_activity.report.poin.harian.table.data.view');
                        Route::get('data-list/table', 'Poin_harian@list_data')->name('sales_activity.report.poin.harian.table.data.list');
                    });
                    Route::group('diagram', function () {
                        Route::get('data-view/diagram', 'Poin_harian@view_data_diagram')->name('sales_activity.report.poin.harian.diagram.data.view');
                        Route::get('data-list/diagram', 'Poin_harian@list_data_diagram')->name('sales_activity.report.poin.harian.diagram.data.list');
                    });

                    Route::group('dropdown', function () {
                        Route::get('group', 'Poin_harian@dropdown_group')->name('sales_activity.report.poin.harian.dropdown.group');
                        Route::get('karyawan', 'Poin_harian@dropdown_karyawan')->name('sales_activity.report.poin.harian.dropdown.karyawan');
                    });

                    Route::get('download', 'Poin_harian@download')->name('sales_activity.report.poin.harian.download');
                });

                Route::group('mingguan', function () {
                    Route::group('table', function () {
                        Route::get('data-view', 'Poin_mingguan@view_data')->name('sales_activity.report.poin.mingguan.table.data.view');
                        Route::get('data-list', 'Poin_mingguan@list_data')->name('sales_activity.report.poin.mingguan.table.data.list');
                        Route::get('download', 'Poin_mingguan@download')->name('sales_activity.report.poin.mingguan.table.download');
                    });
                    Route::group('diagram', function () {
                        Route::get('data-view', 'Poin_mingguan@view_data_diagram')->name('sales_activity.report.poin.mingguan.diagram.data.view');
                        Route::get('data-list', 'Poin_mingguan@list_data_diagram')->name('sales_activity.report.poin.mingguan.diagram.data.list');
                    });
                    Route::group('dropdown', function () {
                        Route::get('group', 'Poin_mingguan@dropdown_group')->name('sales_activity.report.poin.mingguan.dropdown.group');
                        Route::get('karyawan', 'Poin_mingguan@dropdown_karyawan')->name('sales_activity.report.poin.mingguan.dropdown.karyawan');
                    });
                });

                Route::group('bulanan', function () {
                    Route::group('table', function () {
                        Route::get('data-view', 'Poin_bulanan@view_data')->name('sales_activity.report.poin.bulanan.table.data.view');
                        Route::get('data-list', 'Poin_bulanan@list_data')->name('sales_activity.report.poin.bulanan.table.data.list');
                        Route::get('download', 'Poin_bulanan@download')->name('sales_activity.report.poin.bulanan.table.download');
                    });
                    Route::group('diagram', function () {
                        Route::get('data-view', 'Poin_bulanan@view_data_diagram')->name('sales_activity.report.poin.bulanan.diagram.data.view');
                        Route::get('data-list', 'Poin_bulanan@list_data_diagram')->name('sales_activity.report.poin.bulanan.diagram.data.list');
                    });
                    Route::group('dropdown', function () {
                        Route::get('group', 'Poin_bulanan@dropdown_group')->name('sales_activity.report.poin.bulanan.dropdown.group');
                        Route::get('karyawan', 'Poin_bulanan@dropdown_karyawan')->name('sales_activity.report.poin.bulanan.dropdown.karyawan');
                    });
                });
            });

            Route::group('aktivitas', function () {
                Route::group('data', function () {
                    Route::get('view', 'Aktivitas@view_data')->name('sales_activity.report.aktivitas.data.view');
                    Route::get('list', 'Aktivitas@list_data')->name('sales_activity.report.aktivitas.data.list');
                    Route::get('download', 'Aktivitas@download')->name('sales_activity.report.aktivitas.data.download');
                });
                Route::group('dropdown', function () {
                    Route::get('group', 'Aktivitas@dropdown_group')->name('sales_activity.report.aktivitas.dropdown.group');
                    Route::get('karyawan', 'Aktivitas@dropdown_karyawan')->name('sales_activity.report.aktivitas.dropdown.karyawan');
                });
            });

            Route::group('download-semua', function () {
                Route::get('modal', 'Download_all@download_semua_modal')->name('sales_activity.report.download.semua.modal');
                Route::get('action', 'Download_all@download_semua_action')->name('sales_activity.report.download.semua.action');
                Route::group('dropdown', function () {
                    Route::get('group', 'Download_all@dropdown_group')->name('sales_activity.report.download.semua.dropdown.group');
                    Route::get('karyawan', 'Download_all@dropdown_karyawan')->name('sales_activity.report.download.semua.dropdown.karyawan');
                });
            });
        });
        # End Report

        # Start daily activity
        Route::group('daily-activity', ['namespace' => 'daily_activity'], function () {
            Route::get('', 'Daily_activity@index')->name('sales_activity.daily_activity.home');
            Route::get('list-data/{mulai}/{selesai}/{status}/{pelanggan?}/{karyawan?}/{group?}', 'Daily_activity@list_data')->name('sales_activity.daily_activity.data');
        });
        # End daily activity

        # Start approval activity
        Route::group('approval-activity', ['namespace' => 'approval_activity'], function () {
            Route::get('', 'Approval_activity@index')->name('sales_activity.approval_activity.home');
            Route::get('list-data/{mulai}/{selesai}/{status}/{karyawan?}/{group?}', 'Approval_activity@list_data')->name('sales_activity.approval_activity.data');
            Route::group('verify', function () {
                Route::get('confirmation/single/{tabel}/{id}', 'Approval_activity@verify_confirmation')->name('sales_activity.approval_activity.verification');
                Route::post('single/approve', 'Approval_activity@verify_approve')->name('sales_activity.approval_activity.verification.approve');
                Route::post('single/reject', 'Approval_activity@verify_reject')->name('sales_activity.approval_activity.verification.reject');

                Route::post('confirmation/mass', 'Approval_activity@verify_mass_confirmation')->name('sales_activity.approval_activity.verification.mass');
                Route::post('mass/approve', 'Approval_activity@verify_mass_approve')->name('sales_activity.approval_activity.verification.approve.mass');
                Route::post('mass/reject', 'Approval_activity@verify_mass_reject')->name('sales_activity.approval_activity.verification.reject.mass');

                Route::get('confirmation/all/{mulai}/{selesai}/{id_karyawan}', 'Approval_activity@verify_all_confirmation')->name('sales_activity.approval_activity.verification.all');
            });
        });
        # End approval activity

        # Start Demografi Pelanggan
        Route::group('demografi', ['namespace' => 'demografi_pelanggan'], function () {
            Route::get('', 'Home@index')->name('sales_activity.demografi.pelanggan.home');
            Route::get('tabs/{tabs?}', 'Home@tabs')->name('sales_activity.demografi.pelanggan.tabs');
            Route::get('dropdown/group-area', 'Home@dropdown_group_area')->name('sales_activity.demografi.dropdown.group.area');

            Route::group('download-semua', function () {
                Route::get('modal', 'Home@download_semua_modal')->name('sales_activity.demografi.pelanggan.download.semua.modal');
                Route::get('action', 'Home@download_semua_action')->name('sales_activity.demografi.pelanggan.download.semua.action');
            });

            Route::group('pelanggan', function () {
                Route::get('list-data', 'Pelanggan@list_data')->name('sales_activity.demografi.pelanggan.nama.pelanggan.list.data');
                Route::get('download', 'Pelanggan@download')->name('sales_activity.demografi.pelanggan.nama.pelanggan.download');
            });

            Route::group('source', function () {
                Route::get('list-data', 'Source@list_data')->name('sales_activity.demografi.pelanggan.source.list.data');
                Route::get('download', 'Source@download')->name('sales_activity.demografi.pelanggan.source.download');
                Route::get('dropdown/source', 'Source@dropdown_source')->name('sales_activity.demografi.pelanggan.source.dropdown.lead.source');
            });

            Route::group('wilayah', ['namespace' => 'wilayah'], function () {
                Route::get('tabs/{tabs_wilayah?}', 'Home@tabs')->name('sales_activity.demografi.pelanggan.wilayah.tabs');
                Route::group('provinsi', function () {
                    Route::get('list-data', 'Provinsi@list_data')->name('sales_activity.demografi.pelanggan.provinsi.list.data');
                    Route::get('download', 'Provinsi@download')->name('sales_activity.demografi.pelanggan.provinsi.download');
                });
                Route::group('kota', function () {
                    Route::get('list-data', 'Kota@list_data')->name('sales_activity.demografi.pelanggan.kota.list.data');
                    Route::get('download', 'Kota@download')->name('sales_activity.demografi.pelanggan.kota.download');
                    Route::get('dropdown/kota', 'Kota@dropdown_kota')->name('sales_activity.demografi.pelanggan.kota.dropdown.kota');
                });
                Route::group('kecamatan', function () {
                    Route::get('list-data', 'Kecamatan@list_data')->name('sales_activity.demografi.pelanggan.kecamatan.list.data');
                    Route::get('download', 'Kecamatan@download')->name('sales_activity.demografi.pelanggan.kecamatan.download');
                    Route::get('dropdown/kecamatan', 'Kecamatan@dropdown_kecamatan')->name('sales_activity.demografi.pelanggan.kecamatan.dropdown.kecamatan');
                });
                Route::group('kelurahan', function () {
                    Route::get('list-data', 'Kelurahan@list_data')->name('sales_activity.demografi.pelanggan.kelurahan.list.data');
                    Route::get('download', 'Kelurahan@download')->name('sales_activity.demografi.pelanggan.kelurahan.download');
                    Route::get('dropdown/kelurahan', 'Kelurahan@dropdown_kelurahan')->name('sales_activity.demografi.pelanggan.kelurahan.dropdown.kelurahan');
                });
            });

            Route::group('j-pelanggan', function () {
                Route::get('tabs/{tabs_jenis?}', 'Jenis_pelanggan@tabs')->name('sales_activity.demografi.pelanggan.jenis.pelanggan.tabs');
                Route::group('jenis-pelanggan', function () {
                    Route::get('list-data', 'Jenis_pelanggan@list_data')->name('sales_activity.demografi.pelanggan.jenis.pelanggan.list.data');
                    Route::get('download', 'Jenis_pelanggan@download')->name('sales_activity.demografi.pelanggan.jenis.pelanggan.download');
                });
                Route::group('jenis-perusahaan', function () {
                    Route::get('list-data', 'Jenis_perusahaan@list_data')->name('sales_activity.demografi.pelanggan.jenis.perusahaan.list.data');
                    Route::get('download', 'Jenis_perusahaan@download')->name('sales_activity.demografi.pelanggan.jenis.perusahaan.download');
                    Route::get('dropdown/jenis-perusahaan', 'Jenis_perusahaan@dropdown_jenis_perusahaan')->name('sales_activity.demografi.pelanggan.jenis-perusahaan.dropdown.jenis.perusahaan');
                });
                Route::group('jenis-perorangan', function () {
                    Route::get('list-data', 'Jenis_perorangan@list_data')->name('sales_activity.demografi.pelanggan.jenis.perorangan.list.data');
                    Route::get('download', 'Jenis_perorangan@download')->name('sales_activity.demografi.pelanggan.jenis.perorangan.download');
                    Route::get('dropdown/jenis-perorangan', 'Jenis_perorangan@dropdown_jenis_perorangan')->name('sales_activity.demografi.pelanggan.jenis-perorangan.dropdown.jenis.perorangan');
                });
            });

            Route::group('grup-produk', function () {
                Route::get('list-data', 'Grup_produk@list_data')->name('sales_activity.demografi.pelanggan.grup.produk.list.data');
                Route::get('download', 'Grup_produk@download')->name('sales_activity.demografi.pelanggan.grup.produk.download');
                Route::get('dropdown/grup-produk', 'Grup_produk@dropdown_grup_produk')->name('sales_activity.demografi.pelanggan.grup.produk.dropdown.grup.produk');
            });

            Route::group('product', function () {
                Route::get('list-data', 'Product@list_data')->name('sales_activity.demografi.pelanggan.product.list.data');
                Route::get('download', 'Product@download')->name('sales_activity.demografi.pelanggan.product.download');
                Route::get('dropdown/product', 'Product@dropdown_produk')->name('sales_activity.demografi.pelanggan.product.dropdown.product');
            });
        });
        # End Demografi Pelanggan
    });
    # END SALES ACTIVITY

    # BEGIN KPI
    Route::group('kpi', ['middleware' => 'Auth_paket:kpi', 'namespace' => 'kpi'], function () {
        Route::get('', 'Kpi@index')->name('kpi');
        Route::group('', ['middleware' => 'Auth_menu:1'], function () {
            # 1. Tab Pengaturan
            Route::group('pengaturan', function () {
                Route::get('', 'Kpi@view_pengaturan')->name('kpi.pengaturan');
                Route::group('bobot', ['namespace' => 'admin/pengaturan'], function () {
                    Route::get('', 'Bobot@index')->name('kpi.pengaturan.bobot');
                    Route::get('list_data', 'Bobot@list_data')->name('kpi.pengaturan.bobot.list.data');
                    Route::get('form/edit/{id?}', 'Bobot@form')->name('kpi.pengaturan.bobot.form.edit');
                    Route::post('update', 'Bobot@update')->name('kpi.pengaturan.bobot.update');
                });

                Route::group('predikat', ['namespace' => 'admin/pengaturan'], function () {
                    Route::get('', 'Predikat@index')->name('kpi.pengaturan.predikat');
                    Route::get('list_data', 'Predikat@list_data')->name('kpi.pengaturan.predikat.data');
                    Route::get('form/edit/{id?}', 'Predikat@form')->name('kpi.pengaturan.predikat.form.edit');
                    Route::post('save', 'Predikat@save')->name('kpi.pengaturan.predikat.save');
                });

                Route::group('approver', ['namespace' => 'admin/pengaturan'], function () {
                    Route::get('home', 'Approver@index')->name('kpi.pengaturan.approver');
                    Route::get('list_data', 'Approver@list_data')->name('kpi.pengaturan.approver.data');
                    Route::get('form/edit/{id?}', 'Approver@form')->name('kpi.pengaturan.approver.form.edit');
                    Route::get('form/hapus/{id?}', 'Approver@form')->name('kpi.pengaturan.approver.form.hapus');
                    Route::post('update', 'Approver@update')->name('kpi.pengaturan.approver.update');
                    Route::post('delete', 'Approver@delete')->name('kpi.pengaturan.approver.delete');
                });
            });

            # 2. Tab Master
            Route::group('master', function () {
                Route::get('', 'Kpi@view_master')->name('kpi.master');
                Route::group('kinerja', ['namespace' => 'admin/master'], function () {
                    Route::get('', 'Kinerja@index')->name('kpi.master.kinerja');
                    Route::get('list_data', 'Kinerja@list_data')->name('kpi.master.kinerja.data');

                    Route::get('form/tambah', 'Kinerja@form')->name('kpi.master.kinerja.form.tambah');
                    Route::get('form/edit/{id?}', 'Kinerja@form')->name('kpi.master.kinerja.form.edit');
                    Route::get('form/hapus/{id?}', 'Kinerja@form')->name('kpi.master.kinerja.form.hapus');
                    Route::post('save', 'Kinerja@save')->name('kpi.master.kinerja.form.save');
                    Route::post('update', 'Kinerja@update')->name('kpi.master.kinerja.form.update');
                    Route::post('delete', 'Kinerja@delete')->name('kpi.master.kinerja.form.delete');
                    Route::post('order', 'Kinerja@update_order')->name("kpi.master.kinerja.order");
                });

                Route::group('kepribadian', ['namespace' => 'admin/master/kepribadian'], function () {
                    Route::get('', 'Home@index')->name('kpi.master.kepribadian');
                    Route::get('view_home', 'Home@view_home')->name('kpi.master.kepribadian.view_home');
                    Route::get('list_data', 'Home@list_data')->name('kpi.master.kepribadian.list.data');

                    Route::group('detail', function () {
                        Route::get('id/{id_jabatan?}', 'Detail@view_detail')->name('kpi.master.kepribadian.detail.view.detail');
                        Route::get('list_data', 'Detail@list_data')->name('kpi.master.kepribadian.detail.data');
                        Route::get('form/tambah', 'Detail@form')->name('kpi.master.kepribadian.form.tambah');
                        Route::get('form/edit/{id?}', 'Detail@form')->name('kpi.master.kepribadian.form.edit');
                        Route::get('form/hapus/{id?}', 'Detail@form')->name('kpi.master.kepribadian.form.hapus');
                        Route::post('save', 'Detail@save')->name('kpi.master.kepribadian.save');
                        Route::post('delete', 'Detail@delete')->name('kpi.master.kepribadian.delete');
                    });
                });

                Route::group('kedisiplinan', ['namespace' => 'admin/master'], function () {
                    Route::get('', 'Kedisiplinan@index')->name('kpi.master.kedisiplinan');
                    Route::post('update', 'Kedisiplinan@update')->name('kpi.master.kedisiplinan.bobot.update');
                    Route::post('update_poin', 'Kedisiplinan@update_poin')->name('kpi.master.kedisiplinan.bobot.update.poin');
                });
            });

            # 3. Tab Periode
            Route::group('periode', function () {
                Route::get('', 'Kpi@view_periode')->name('kpi.periode');

                Route::group('target-kpi', ['namespace' => 'admin/periode'], function () {
                    Route::get('', 'Target_kpi@index')->name('kpi.periode.target');
                    Route::get('list_data', 'Target_kpi@list_data')->name("kpi.periode.target.data");
                    Route::post('save', 'Target_kpi@save')->name("kpi.periode.target.save");
                });

                Route::group('aktual-kpi', ['namespace' => 'admin/periode'], function () {
                    Route::get('', 'Aktual_kpi@index')->name('kpi.periode.aktual');
                    Route::get('list_data', 'Aktual_kpi@list_data')->name("kpi.periode.aktual.data");
                    Route::post('save', 'Aktual_kpi@save')->name("kpi.periode.aktual.save");
                });

                Route::group('approval-kpi', ['namespace' => 'admin/periode'], function () {
                    Route::get('', 'Approval_kpi@index')->name('kpi.periode.approval');
                    Route::get('list_data', 'Approval_kpi@list_data')->name("kpi.periode.approval.data");
                    Route::post('save', 'Approval_kpi@save')->name("kpi.periode.approval.save");
                });
            });

            # 4. Tab Laporan
            Route::group('laporan', ['namespace' => 'admin/laporan'], function () {
                Route::get('', 'Home@index')->name('kpi.laporan');
                Route::get('view_home', 'Home@view_home')->name('kpi.laporan.view_home');
                Route::get('list_data', 'Home@list_data')->name('kpi.laporan.list-data');
                Route::get('download_all/{periode}', 'Home@download_all')->name('kpi.laporan.download-all');

                Route::group('detail', ['namespace' => 'detail'], function () {
                    Route::get('id/{id?}', 'Detail@view_detail')->name('kpi.laporan.detail.view.detail');
                    Route::get('tabs/{tabs?}/{id?}', 'Detail@tabs')->name('kpi.laporan.detail.tabs');
                    Route::get('download/{id}', 'Detail@download')->name('kpi.laporan.detail.download');
                });
            });
        });

        Route::group('', ['namespace' => 'user'], function () {
            Route::group('saya', ['middleware' => 'Auth_menu:2,3,4,5,6,7', 'namespace' => 'saya'], function () {
                Route::group('detail', function () {
                    Route::get('list_data', 'Detail@list_data')->name('kpi.saya.detail.list-data');
                    Route::post('save', 'Detail@save')->name('kpi.saya.detail.save');
                    Route::get('form', 'Detail@form')->name('kpi.saya.detail.form');
                    Route::get('form_terima', 'Detail@form_terima')->name('kpi.saya.detail.form-terima');
                    Route::post('terima', 'Detail@terima')->name('kpi.saya.detail.terima');
                    Route::post('ajukan', 'Detail@ajukan')->name('kpi.saya.detail.ajukan');
                    Route::get('button/{tahun}/{bulan}/{karyawan}/{jenis}', 'Detail@button')->name('kpi.saya.detail.button');
                    Route::get('{id}', 'Detail@index')->name('kpi.saya.detail');
                });
                Route::get('list_data', 'Home@list_data')->name('kpi.saya.list-data');
                Route::get('', 'Home@index')->name('kpi.saya');
            });
            Route::group('team', ['middleware' => 'Auth_menu:2,3,4,5,6,7', 'namespace' => 'team'], function () {
                Route::get('', 'Home@index')->name('kpi.team');
                Route::get('list_data', 'Home@list_data')->name('kpi.team.list.data');
                Route::group('detail', function () {
                    Route::get('list_data', 'Detail@list_data')->name('kpi.team.detail.list.data');
                    Route::get('button/{tahun}/{bulan}/{karyawan}/{jenis}', 'Detail@button')->name('kpi.team.detail.button');
                    Route::get('form/{id?}', 'Detail@form')->name('kpi.team.detail.form');
                    Route::get('form-publish', 'Detail@form_publish')->name('kpi.team.detail.form-publish');
                    Route::post('publish', 'Detail@publish')->name('kpi.team.detail.publish');
                    Route::post('save', 'Detail@save')->name('kpi.team.detail.save');
                    Route::post('delete', 'Detail@delete')->name('kpi.team.detail.delete');
                    Route::get('{id}', 'Detail@index')->name('kpi.team.detail');
                });
            });
            Route::group('approval', ['middleware' => 'Auth_menu:1,2,3,4,5,6,7', 'namespace' => 'approval'], function () {
                Route::group('detail', function () {
                    Route::get('button/{tahun}/{bulan}/{karyawan}/{jenis}', 'Detail@button')->name('kpi.approval.detail.button');
                    Route::group('aspek_kinerja', function () {
                        Route::get('list_data', 'Aspek_kinerja@list_data')->name('kpi.approval.detail.aspek-kinerja.list-data');
                        Route::post('save', 'Aspek_kinerja@save')->name('kpi.approval.detail.aspek-kinerja.save');
                        Route::get('', 'Aspek_kinerja@index')->name('kpi.approval.detail.aspek-kinerja');
                    });
                    Route::group('aspek_kepribadian', function () {
                        Route::get('list_data', 'Aspek_kepribadian@list_data')->name('kpi.approval.detail.aspek-kepribadian.list-data');
                        Route::post('save', 'Aspek_kepribadian@save')->name('kpi.approval.detail.aspek-kepribadian.save');
                        Route::get('', 'Aspek_kepribadian@index')->name('kpi.approval.detail.aspek-kepribadian');
                    });
                    Route::group('aspek_kedisiplinan', function () {
                        Route::get('list_data', 'Aspek_kedisiplinan@list_data')->name('kpi.approval.detail.aspek-kedisiplinan.list-data');
                        Route::get('', 'Aspek_kedisiplinan@index')->name('kpi.approval.detail.aspek-kedisiplinan');
                    });
                    Route::group('nilai_individu', function () {
                        Route::get('list_data', 'Nilai_individu@list_data')->name('kpi.approval.detail.nilai-individu.list-data');
                        Route::get('', 'Nilai_individu@index')->name('kpi.approval.detail.nilai-individu');
                    });
                    Route::get('form', 'Detail@form')->name('kpi.approval.detail.form');
                    Route::post('setujui', 'Detail@setujui')->name('kpi.approval.detail.setujui');
                    Route::get('{id}', 'Detail@index')->name('kpi.approval.detail');
                });
                Route::get('view_data/{jenis}', 'Home@view_data')->name('kpi.approval.view_data');
                Route::get('list_data', 'Home@list_data')->name('kpi.approval.list-data');
                Route::get('', 'Home@index')->name('kpi.approval');
            });
        });
    });
    # END KPI

    # BEGIN PATROLI
    Route::group('patroli', ['namespace' => 'patroli'], function () {
        Route::get('', 'Patroli@index')->name('patroli.home');
        Route::get('list_data/{tab}/{params?}', 'Patroli@list_data')->name('patroli.data');

        # Start master qr code
        Route::group('masterqrcode', ['namespace' => 'masterqrcode'], function () {
            Route::get('', 'Master_qrcode@index')->name('patroli.master.qrcode.home');
            Route::get('list-data', 'Master_qrcode@list_data')->name('patroli.master.qrcode.list.data');
            Route::get('form/tambah', 'Master_qrcode@form')->name('patroli.master.qrcode.form.tambah');
            Route::get('form/hapus/{id?}', 'Master_qrcode@form')->name('patroli.master.qrcode.form.hapus');
            Route::post('save', 'Master_qrcode@save')->name('patroli.master.qrcode.save');
            Route::post('delete', 'Master_qrcode@delete')->name('patroli.master.qrcode.delete');
        });
        # End master qr code

        # Start Jadwal Patroli
        Route::group('jadwal', ['namespace' => 'jadwal'], function () {
            Route::get('','Jadwal@index')->name('patroli.jadwal.home');
            Route::get('list_data','Jadwal@list_data')->name('patroli.jadwal.list.data');

            Route::get('form/tambah','Jadwal@form')->name('patroli.jadwal.form.tambah');
            Route::get('form/edit/{id?}','Jadwal@form')->name('patroli.jadwal.form.edit');
            Route::get('form/hapus/{id?}','Jadwal@form')->name('patroli.jadwal.form.hapus');
            Route::post('save','Jadwal@save')->name('patroli.jadwal.save');
            Route::post('delete','Jadwal@delete')->name('patroli.jadwal.delete');
        });
        # End Jadwal Patroli

        # Start Laporan Patroli
        Route::group('laporan', ['namespace' => 'laporan'], function () {
            Route::get('','Laporan_patroli@index')->name('patroli.laporan.home');
            Route::get('data/tabel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_patroli@data_tabel')->name('patroli.laporan.data.tabel');
            Route::get('list-data/ajax/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_patroli@list_data')->name('patroli.laporan.listdata');
            Route::get('detail/{id?}','Laporan_patroli@detail')->name('patroli.laporan.detail');
            Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_patroli@download_excel')->name('patroli.laporan.download.excel');
            Route::get('download2/excel2/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_patroli@download_excel2')->name('patroli.laporan.download2.excel2');
            Route::get('data/maps/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_patroli@data_maps')->name('patroli.laporan.data.maps');
            Route::get('data/maps/lokasi/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_patroli@lokasi_aktivitas')->name('patroli.laporan.data.maps.lokasi');

            Route::get('list-data/ajax/rekap/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}/','Laporan_patroli@rekap_aktifitas')->name('patroli.laporan.listrekap');
            Route::post('delete','Laporan_patroli@delete')->name('patroli.laporan.delete');
        });
        # END Laporan Patroli
    });
    # END PATROLI

    # START SOS
    Route::group('sos', function () {
        Route::get('', 'Laporan_sos@index')->name('sos.laporan.home');
        Route::get('detail/{id?}','Laporan_sos@detail')->name('sos.laporan.detail');
        Route::get('data/tabel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_sos@data_tabel')->name('sos.laporan.data.tabel');
        Route::get('download/excel/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_sos@download_excel')->name('sos.laporan.download.excel');
        Route::get('list-data/ajax/{tgl_mulai?}/{tgl_selesai?}/{id_karyawan?}/{id_cabang?}/{id_departemen?}','Laporan_sos@list_data')->name('sos.laporan.listdata');
        Route::get('detail_foto/{id?}', 'Laporan_sos@detail_foto')->name('sos.laporan.detail.foto');
        Route::post('delete','Laporan_sos@delete')->name('sos.laporan.delete');
    });

    // Route::group('quick-setup', ['middleware' => 'Auth_menu:1'], function () {
    //     Route::get('', 'Quick_setup@index');
    //     Route::group('cabang', function () {
    //         Route::get('', 'Quick_setup_cabang@index')->name('quick-setup.cabang');
    //         Route::post('list_data', 'Quick_setup_cabang@list_data')->name('quick-setup.cabang.list_data');
    //         Route::post('save', 'Quick_setup_cabang@save')->name('quick-setup.cabang.save');
    //         Route::post('update', 'Quick_setup_cabang@update')->name('quick-setup.cabang.update');
    //         Route::post('delete', 'Quick_setup_cabang@delete')->name('quick-setup.cabang.delete');
    //         Route::get('detail/{id_cabang?}/{id_lokasi_kantor?}', 'Quick_setup_cabang@detail')->name('quick-setup.cabang.detail');
    //     });
    //     Route::group('departemen', function () {
    //         Route::get('', 'Quick_setup_departemen@index')->name('quick-setup.departemen');
    //         Route::post('list_data', 'Quick_setup_departemen@list_data')->name('quick-setup.departemen.list_data');
    //         Route::post('save', 'Quick_setup_departemen@save')->name('quick-setup.departemen.save');
    //         Route::post('update', 'Quick_setup_departemen@update')->name('quick-setup.departemen.update');
    //         Route::post('delete', 'Quick_setup_departemen@delete')->name('quick-setup.departemen.delete');
    //         Route::get('detail/{id_departemen?}', 'Quick_setup_departemen@detail')->name('quick-setup.departemen.detail');
    //     });
    //     Route::group('kepala', function () {
    //         Route::group('cabang', function () {
    //             Route::get('', 'Quick_setup_kepala_cabang@index')->name('quick-setup.kepala.cabang');
    //             Route::get('cek_nik/{id_karyawan?}', 'Quick_setup_kepala_cabang@cek_nik')->name('quick-setup.kepala.cabang.cek_nik');
    //             Route::post('list_data', 'Quick_setup_kepala_cabang@list_data')->name('quick-setup.kepala.cabang.list_data');
    //             Route::post('save', 'Quick_setup_kepala_cabang@save')->name('quick-setup.kepala.cabang.save');
    //             Route::post('update', 'Quick_setup_kepala_cabang@update')->name('quick-setup.kepala.cabang.update');
    //             Route::post('delete', 'Quick_setup_kepala_cabang@delete')->name('quick-setup.kepala.cabang.delete');
    //             Route::get('detail/{id_karyawan?}', 'Quick_setup_kepala_cabang@detail')->name('quick-setup.kepala.cabang.detail');
    //         });
    //         Route::group('departemen', function () {
    //             Route::get('', 'Quick_setup_kepala_departemen@index')->name('quick-setup.kepala.departemen');
    //             Route::post('list_data', 'Quick_setup_kepala_departemen@list_data')->name('quick-setup.kepala.departemen.list_data');
    //             Route::post('save', 'Quick_setup_kepala_departemen@save')->name('quick-setup.kepala.departemen.save');
    //             Route::post('update', 'Quick_setup_kepala_departemen@update')->name('quick-setup.kepala.departemen.update');
    //             Route::post('delete', 'Quick_setup_kepala_departemen@delete')->name('quick-setup.kepala.departemen.delete');
    //             Route::get('detail/{id_karyawan?}', 'Quick_setup_kepala_departemen@detail')->name('quick-setup.kepala.departemen.detail');
    //         });
    //     });
    //     Route::group('staff', function () {
    //         Route::get('', 'Quick_setup_staff@index')->name('quick-setup.staff');
    //         Route::post('list_data', 'Quick_setup_staff@list_data')->name('quick-setup.staff.list_data');
    //         Route::post('update', 'Quick_setup_staff@update')->name('quick-setup.staff.update');
    //         Route::post('delete', 'Quick_setup_staff@delete')->name('quick-setup.staff.delete');
    //         Route::post('save', 'Quick_setup_staff@save')->name('quick-setup.staff.save');
    //     });
    // });

    // END KELOLA ABSENSI

    # START PKWT
    Route::group('pkwt',['middleware' => ['Auth_paket:pkwt', 'Auth_menu:1'], 'namespace' => 'pkwt'],function(){
        Route::group('perpanjangan', ['namespace' => 'perpanjang'], function() {
            Route::get('','home@index')->name('pkwt.home');
            Route::get('tabs/{tabs?}','home@tabs')->name('pkwt.tabs');
            Route::get('download/pdf/{id_pkwt?}/{jenis?}','home@download_pdf_web')->name('pkwt.download_pdf');
            
            Route::get('data/tabs/content/habis_masa_kerja/{tanggal_mulai?}/{tanggal_selesai?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','Habis_masa_kerja@list_data')->name('pkwt.kayawan.tabs.content.habis.masa.kerja');
            Route::get('form/tambah/{id_karyawan?}','habis_masa_kerja@tambah_pkwt')->name('pkwt.form.tambah');
            Route::post('save','habis_masa_kerja@save')->name('pkwt.save');
            
            Route::get('data/tabs/content/draft_pkwt/{tanggal_mulai?}/{tanggal_selesai?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','Draft_pkwt@list_data')->name('pkwt.kayawan.tabs.content.draft.pkwt');
            Route::get('form/edit/{id_pkwt?}','Draft_pkwt@edit_pkwt')->name('pkwt.form.edit');
            Route::post('delete','Draft_pkwt@delete')->name('pkwt.delete');
            Route::post('kirim-draft','Draft_pkwt@kirim_draft')->name('pkwt.kirim.draft');
            
            Route::get('data/tabs/content/verifikasi/{tanggal_mulai?}/{tanggal_selesai?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','Verifikasi@list_data')->name('pkwt.kayawan.tabs.content.verifikasi');
            Route::get('verifikasi/form/{id_pkwt?}','Verifikasi@verifikasi_form')->name('pkwt.verifikasi.form');
            Route::post('verifikasi/approve','Verifikasi@verifikasi_approve')->name('pkwt.verifikasi.approve');
            Route::get('verifikasi/form-all','Verifikasi@verifikasi_form_all')->name('pkwt.verifikasi.form.all');
            Route::post('verifikasi/approve-all','Verifikasi@verifikasi_approve_all')->name('pkwt.verifikasi.approve.all');
            Route::get('verifikasi/onchange/path-ttd','Verifikasi@onchange_path_ttd')->name('pkwt.verifikasi.onchange.path.ttd');

            Route::group('import', function() {
                Route::get('','import@index')->name('pkwt.import.home');
                Route::get('list-data','import@list_data')->name('pkwt.import.list.data');
                Route::get('form/template','import@form_template')->name('pkwt.import.form.template');
                Route::get('template-excel','import@template_excel')->name('pkwt.import.template.excel');
                
                Route::get('form/edit/{id_pkwt_temp?}','import@form_edit')->name('pkwt.import.form.edit');
                Route::post('update','import@update')->name('pkwt.import.update');
                Route::post('delete','import@delete')->name('pkwt.import.delete');

                Route::post('preview','import@import_preview')->name('pkwt.import.preview');
                Route::post('simpan-semua','import@simpan_semua')->name('pkwt.import.simpan.semua');
                Route::post('delete-semua','import@delete_semua')->name('pkwt.import.delete.semua');
            });
        });

        Route::group('baru', ['namespace' => 'baru'], function() {
            Route::get('','home@index')->name('pkwt.baru.home');
            Route::get('tabs/{tabs?}','home@tabs')->name('pkwt.baru.tabs');
            Route::get('download/pdf/{id_pkwt?}/{jenis?}','home@download_pdf_web')->name('pkwt.baru.download_pdf');
            
            Route::get('data/tabs/content/habis_masa_kerja/{tanggal_mulai?}/{tanggal_selesai?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','Habis_masa_kerja@list_data')->name('pkwt.baru.kayawan.tabs.content.habis.masa.kerja');
            Route::get('form/tambah/{id_karyawan?}','habis_masa_kerja@tambah_pkwt')->name('pkwt.baru.form.tambah');
            Route::get('form/parameter/{id_template?}/{id_pkwt?}', 'habis_masa_kerja@form_parameter')->name('pkwt.baru.form.parameter');
            Route::post('save','habis_masa_kerja@save')->name('pkwt.baru.save');
            
            Route::get('data/tabs/content/draft_pkwt/{tanggal_mulai?}/{tanggal_selesai?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','Draft_pkwt@list_data')->name('pkwt.baru.kayawan.tabs.content.draft.pkwt');
            Route::get('form/edit/{id_pkwt?}','Draft_pkwt@edit_pkwt')->name('pkwt.baru.form.edit');
            Route::post('delete','Draft_pkwt@delete')->name('pkwt.baru.delete');
            Route::post('kirim-draft','Draft_pkwt@kirim_draft')->name('pkwt.baru.kirim.draft');
            
            Route::get('data/tabs/content/verifikasi/{tanggal_mulai?}/{tanggal_selesai?}/{id_cabang?}/{id_departemen?}/{id_karyawan?}','Verifikasi@list_data')->name('pkwt.baru.kayawan.tabs.content.verifikasi');
            Route::get('verifikasi/form/{id_pkwt?}','Verifikasi@verifikasi_form')->name('pkwt.baru.verifikasi.form');
            Route::post('verifikasi/approve','Verifikasi@verifikasi_approve')->name('pkwt.baru.verifikasi.approve');
            Route::get('verifikasi/form-all','Verifikasi@verifikasi_form_all')->name('pkwt.baru.verifikasi.form.all');
            Route::post('verifikasi/approve-all','Verifikasi@verifikasi_approve_all')->name('pkwt.baru.verifikasi.approve.all');
            Route::get('verifikasi/onchange/path-ttd','Verifikasi@onchange_path_ttd')->name('pkwt.baru.verifikasi.onchange.path.ttd');

            Route::group('import', function() {
                Route::get('','import@index')->name('pkwt.baru.import.home');
                Route::get('list-data','import@list_data')->name('pkwt.baru.import.list.data');
                Route::get('form/template','import@form_template')->name('pkwt.baru.import.form.template');
                Route::get('template-excel','import@template_excel')->name('pkwt.baru.import.template.excel');
                Route::get('form/edit/{id_pkwt_temp?}','import@form_edit')->name('pkwt.baru.import.form.edit');
                Route::post('update','import@update')->name('pkwt.baru.import.update');
                Route::post('delete','import@delete')->name('pkwt.baru.import.delete');

                Route::post('preview','import@import_preview')->name('pkwt.baru.import.preview');
                Route::post('simpan-semua','import@simpan_semua')->name('pkwt.baru.import.simpan.semua');
                Route::post('delete-semua','import@delete_semua')->name('pkwt.baru.import.delete.semua');
            });
        });

        Route::group('master', ['namespace' => 'master'], function(){
            Route::group('ttd',function(){
                Route::group('direktur',function(){
                    Route::get('','ttd@index')->name('pkwt.master.ttd.direktur.home');
                    Route::post('list_data','ttd@list_data')->name('pkwt.master.ttd.direktur.list.data');

                    Route::get('form/tambah','ttd@form')->name('pkwt.master.ttd.direktur.form.tambah');
                    Route::get('form/edit/{id?}','ttd@form')->name('pkwt.master.ttd.direktur.form.edit');
                    Route::get('form/hapus/{id?}','ttd@form')->name('pkwt.master.ttd.direktur.form.hapus');
                    Route::post('save','ttd@save')->name('pkwt.master.ttd.direktur.save');
                    Route::post('delete','ttd@delete')->name('pkwt.master.ttd.direktur.delete');
                });
            });

            Route::group('template', function() 
            {
                Route::get('', 'template@index')->name('pkwt.master.template');
                Route::get('list_data', 'template@list_data')->name('pkwt.master.template.list-data');
                Route::get('form/tambah', 'template@form')->name('pkwt.master.template.form.tambah');
                Route::get('form/edit/{id}', 'template@form')->name('pkwt.master.template.form.edit');
                Route::get('form/parameter/{id}', 'template@form_parameter')->name('pkwt.master.template.form.parameter');
                Route::get('preview/{id}', 'template@preview')->name('pkwt.master.template.preview');
                Route::post('save', 'template@save')->name('pkwt.master.template.save');
                Route::post('save_parameter', 'template@save_parameter')->name('pkwt.master.template.save.parameter');
                Route::post('delete', 'template@delete')->name('pkwt.master.template.delete');
            });
        });
    });
    # END PKWT
});

Route::get('payroll/gaji/download/pdf/{token}', 'payroll/gaji/Gaji@download_pdf');
// Approve Izin Sales Activity
Route::get('sales-activity/poin/izin/{tanggal_mulai?}/{tanggal_selesai?}/{id_karyawan?}', 'sales_activity/report/realisasi_poin/Home@approve_izin_sales');
