<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Product_m extends CI_Model
{
    var $table = 'sales_product_m';

    function get_datatables(){
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("
            product.id_product_m,
            product.kode AS kode_product,
            product.nama AS nama_product,
            product.harga AS harga_product,
            product.id_product_group_m,
            g_product.kode AS kode_g_product,
            g_product.nama AS nama_g_product,
            g_area.kode AS kode_g_area,
            g_area.nama AS nama_g_area
        ")
        ->from($this->table. ' AS product')
        ->join('sales_product_group_m as g_product', 'g_product.id_product_group_m = product.id_product_group_m')
        ->join('sales_group_m as g_area', 'g_product.id_group_m = g_area.id_group_m', 'LEFT')
        ->where("product.id_company", $this->id_company);

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('g_product.id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $column_search = array('product.kode', 'product.nama');
        $i = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('', 'kode', 'nama', 'flag');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("group.kode ASC, product.kode ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null){
        return $this->db->select("
                    product.id_product_m,
                    product.kode AS kode_product,
                    product.nama AS nama_product,
                    product.harga AS harga_product,
                    product.id_product_group_m,
                    g_product.kode AS kode_g_product,
                    g_product.nama AS nama_g_product,
                    g_area.kode AS kode_g_area,
                    g_area.nama AS nama_g_area
                ")
                ->from($this->table. ' AS product')
                ->join('sales_product_group_m as g_product', 'g_product.id_product_group_m = product.id_product_group_m')
                ->join('sales_group_m as g_area', 'g_product.id_group_m = g_area.id_group_m', 'LEFT')
                ->where("product.id_company", $this->id_company)
                ->where("MD5(product.id_product_m)", $id)
                ->get()
                ->row();
    }

    public function save($data = [], $id){
        $cek_kode_produk = $this->_cek_kode_produk($data['kode'], $id);

        if(!empty($cek_kode_produk)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_kode_product_duplicate') . '</font>');
            return __response_save(false, $message);
        }else{
            if(!empty($id)){
                // PROSES UPDATE
                $user_update    = array('tgl_update'     => date("Y-m-d H:i:s"),
                                        'user_update'	=> $this->nik_karyawan. " - ". $this->nm_karyawan);
                $this->db->where("md5(id_product_m)",$id);
                $this->db->where('id_company', $this->id_company);
                $update = $this->db->update($this->table, array_merge($data,$user_update));
                return  __response_update($update);
            }else{
                // PROSES SAVE
                $id = $this->fungsi->getNextId($this->table, 'id_product_m', $this->id_company, 5);
    
                $user_input = array('id_product_m' => $id,
                                    'tgl_input'  => date("Y-m-d H:i:s"),
                                    'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan);
    
                $save = $this->db->insert($this->table, array_merge($data,$user_input));
                return  __response_save($save);
            }
        }
    }

    public function delete($id = null){
        $this->db->where('MD5(id_product_m)', $id);
        $this->db->where('id_company', $this->id_company);
        $delete = $this->db->delete($this->table);
        return  __response_delete($delete);
    }

    private function _cek_kode_produk($kode='', $id=''){
        if(!empty($id)){
            $this->db->where('MD5(id_product_m) !=', $id);
        }

        $query = $this->db->select("kode")
                        ->from($this->table)
                        ->where('id_company', $this->id_company)
                        ->where('kode', $kode)
                        ->get()
                        ->row()
                        ->kode;

        return $query;
    }
}